/*
 * Decompiled with CFR 0.152.
 */
package oracle.ops.verification.framework.engine.task;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import oracle.cluster.verification.VerificationException;
import oracle.cluster.verification.util.CollectionGroup;
import oracle.ops.mgmt.trace.Trace;
import oracle.ops.verification.framework.engine.CollectionElement;
import oracle.ops.verification.framework.engine.ErrorDescription;
import oracle.ops.verification.framework.engine.Result;
import oracle.ops.verification.framework.engine.ResultKeyType;
import oracle.ops.verification.framework.engine.factory.context.VerificationTaskContext;
import oracle.ops.verification.framework.engine.task.Task;
import oracle.ops.verification.framework.util.ASMUtils;
import oracle.ops.verification.framework.util.ASMUtilsException;
import oracle.ops.verification.framework.util.VerificationUtil;

public class TaskASMDiskGroupConfigurationCollection
extends Task {
    public TaskASMDiskGroupConfigurationCollection(VerificationTaskContext ctx) {
        super(ctx);
    }

    public TaskASMDiskGroupConfigurationCollection(String[] nodeList) {
        super(nodeList);
    }

    @Override
    protected boolean isTaskApplicable() throws VerificationException {
        return VerificationUtil.isBaselineCollectionMode() || VerificationUtil.isCVUResource();
    }

    @Override
    public boolean performTask() {
        boolean retVal = true;
        Trace.out((String)"Performing ASM Disk Group Configuration Collection");
        try {
            CollectionElement dgCE;
            Result asmDGResult = new Result(m_localNode);
            HashSet<String> dgNameSet = new HashSet<String>();
            HashMap asmDiskGroupDetailsCEHM = new HashMap();
            HashMap<String, HashMap<String, String>> asmInstanceDiskGroupsHM = ASMUtils.getASMDiskGroups(asmDGResult);
            String diskGroupDesc = s_gMsgBundle.getMessage("13164", false);
            for (String asmInstance : asmInstanceDiskGroupsHM.keySet()) {
                this.m_resultSet.addResult(asmInstance, 1, ResultKeyType.ASMINSTANCE);
                HashMap<String, CollectionElement> instnaceDGHM = new HashMap<String, CollectionElement>();
                asmDiskGroupDetailsCEHM.put(asmInstance, instnaceDGHM);
                HashMap<String, String> dgHM = asmInstanceDiskGroupsHM.get(asmInstance);
                for (String dgName : dgHM.values()) {
                    dgNameSet.add(dgName);
                    dgCE = new CollectionElement(dgName, null, null, null, diskGroupDesc, 1);
                    this.m_resultSet.addCollectionElement(asmInstance, dgCE);
                    instnaceDGHM.put(dgName, dgCE);
                }
            }
            for (String dgName : dgNameSet) {
                HashMap<String, HashMap<String, String>> asmDiskGroupDetailsHM = ASMUtils.getASMDiskGroupDetails(dgName, asmDGResult);
                for (String asmInstance : asmDiskGroupDetailsHM.keySet()) {
                    HashMap instanceDGDetailsHM = (HashMap)asmDiskGroupDetailsCEHM.get(asmInstance);
                    CollectionElement collectionElement = dgCE = instanceDGDetailsHM != null ? (CollectionElement)instanceDGDetailsHM.get(dgName) : null;
                    if (dgCE == null) continue;
                    for (String dgAttrName : asmDiskGroupDetailsHM.get(asmInstance).keySet()) {
                        CollectionElement dgAttrCE = new CollectionElement(dgAttrName, asmDiskGroupDetailsHM.get(asmInstance).get(dgAttrName), null, null, dgAttrName, 1);
                        dgCE.addChild(dgAttrCE);
                    }
                }
            }
        }
        catch (ASMUtilsException e) {
            this.m_resultSet.addErrorDescription(new ErrorDescription(e.getMessage()));
            this.m_resultSet.setStatus(2);
        }
        try {
            Result asmDiskResult = new Result(m_localNode);
            HashMap<String, HashMap<String, HashMap<String, String>>> asmDiskDetailsHM = ASMUtils.getASMDiskDetails(asmDiskResult);
            for (String asmInstance : asmDiskDetailsHM.keySet()) {
                Set<String> diskSet = asmDiskDetailsHM.get(asmInstance).keySet();
                for (String disk : diskSet) {
                    CollectionElement diskCE = new CollectionElement(disk, null, null, null, "Disk", 1);
                    this.m_resultSet.addCollectionElement(asmInstance, diskCE);
                    HashMap<String, String> pathDetails = asmDiskDetailsHM.get(asmInstance).get(disk);
                    for (String diskAttr : pathDetails.keySet()) {
                        CollectionElement diskAttrCE = new CollectionElement(diskAttr, pathDetails.get(diskAttr), null, null, diskAttr, 1);
                        diskCE.addChild(diskAttrCE);
                    }
                }
            }
        }
        catch (ASMUtilsException e) {
            this.m_resultSet.addErrorDescription(new ErrorDescription(e.getMessage()));
            this.m_resultSet.setStatus(2);
        }
        return retVal;
    }

    @Override
    public String getTaskID() {
        return "ASM_DISK_GROUP_CONFIGURATION_COLLECTION";
    }

    @Override
    public CollectionGroup getCollectionGroup() {
        return CollectionGroup.ASM_DISK_GROUP_CONFIGURATION_COLLECTION;
    }

    @Override
    public String getDefaultElementName() {
        return s_gMsgBundle.getMessage("11212", false);
    }

    @Override
    public String getDefaultDescription() {
        return s_gMsgBundle.getMessage("11213", false);
    }
}

