/*
 * Decompiled with CFR 0.152.
 */
package oracle.ops.verification.framework.engine.task;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.List;
import java.util.Set;
import java.util.Vector;
import oracle.cluster.verification.NodeRoleCapability;
import oracle.cluster.verification.VerificationError;
import oracle.cluster.verification.VerificationException;
import oracle.cluster.verification.common.CVUException;
import oracle.cluster.verification.util.VerificationType;
import oracle.ops.mgmt.nativesystem.NativeSystem;
import oracle.ops.mgmt.nativesystem.SystemFactory;
import oracle.ops.mgmt.trace.Trace;
import oracle.ops.verification.framework.config.VDMUtil;
import oracle.ops.verification.framework.engine.ErrorDescription;
import oracle.ops.verification.framework.engine.Result;
import oracle.ops.verification.framework.engine.ResultSet;
import oracle.ops.verification.framework.engine.factory.context.VerificationTaskContext;
import oracle.ops.verification.framework.engine.task.MultiTaskHandler;
import oracle.ops.verification.framework.engine.task.Task;
import oracle.ops.verification.framework.engine.task.TaskACLChecks;
import oracle.ops.verification.framework.engine.task.TaskASMDeviceSharedness;
import oracle.ops.verification.framework.engine.task.TaskASMLibChecks;
import oracle.ops.verification.framework.engine.task.TaskAnonymousProxy;
import oracle.ops.verification.framework.engine.task.TaskCheckDiskScheduler;
import oracle.ops.verification.framework.engine.task.TaskSharedStorageAccess;
import oracle.ops.verification.framework.engine.task.TaskUSMUdevChecks;
import oracle.ops.verification.framework.report.ReportUtil;
import oracle.ops.verification.framework.storage.StorageInfo;
import oracle.ops.verification.framework.storage.StorageUtil;
import oracle.ops.verification.framework.util.ASMDiskGroupsUtil;
import oracle.ops.verification.framework.util.ASMDiskGroupsUtilException;
import oracle.ops.verification.framework.util.CVUVariableConstants;
import oracle.ops.verification.framework.util.CVUVariables;
import oracle.ops.verification.framework.util.VerificationLogData;
import oracle.ops.verification.framework.util.VerificationUtil;

public class TaskASMDeviceChecks
extends Task {
    String[] m_inputDeviceList = null;
    String m_asmDiscoveryString = null;
    private List<String> m_deviceListAll;
    private TaskSharedStorageAccess.StorageThread[] m_stThreadArr;
    private Vector<TaskSharedStorageAccess.StorageThread> m_sharedSet;
    private Vector<TaskSharedStorageAccess.StorageThread> m_nonSharedSet;
    private boolean m_verifySharedness = true;
    private boolean m_verifyACLs = true;
    private boolean m_verifyAFDPrereq = false;
    private boolean m_verifyUdevAttr = true;
    private boolean m_checkDiscoveryString = false;
    private boolean m_verifyDiskIOScheduler = true;
    private String m_referenceOwner;
    private String m_referenceGroup;
    private String m_referencePermissions;
    private String m_version = null;
    private boolean m_dgReuse = false;
    private ResultSet m_diskGroupRS = new ResultSet();
    private Hashtable<String, Hashtable<String, List<String>>> m_htdg = new Hashtable();
    private Hashtable<Object, Vector<Object>> m_signaturePathMap = new Hashtable();

    public TaskASMDeviceChecks(VerificationTaskContext ctx) {
        super(ctx);
    }

    @Override
    protected void init() {
        if (!this.m_globalContext.isASMCheck()) {
            return;
        }
        String dgName = null;
        String dgReuseOptionStr = CVUVariables.getValue(CVUVariableConstants.ASM_DISKGROUP_REUSE_OPTION);
        boolean bl = this.m_dgReuse = VerificationUtil.isStringGood(dgReuseOptionStr) && "TRUE".equalsIgnoreCase(dgReuseOptionStr);
        if (this.m_dgReuse) {
            dgName = CVUVariables.getValue(CVUVariableConstants.ASM_DISKGROUP);
            if (VerificationUtil.isStringGood(dgName) && this.updateDiskGroupDiskMap() && this.m_htdg.get(m_localNode) != null) {
                this.m_deviceListAll = this.m_htdg.get(m_localNode).get(dgName);
            }
            return;
        }
        String asmDiskListStr = CVUVariables.getValue(CVUVariableConstants.ASM_DISKGROUP_DISKS);
        this.m_asmDiscoveryString = CVUVariables.getValue(CVUVariableConstants.ASM_DISK_DISCOVERY_STRING);
        String asmGimrDisks = CVUVariables.getValue(CVUVariableConstants.ASM_GIMR_DISKGROUP_DISKS);
        Trace.out((int)5, (String)"ASM_DISKGROUP_DISKS=%s, ASM_DISK_DISCOVERY_STRING=%s, ASM_GIMR_DISKGROUP_DISKS=%s", (Object[])new Object[]{asmDiskListStr, this.m_asmDiscoveryString, asmGimrDisks});
        if (asmDiskListStr == null) {
            asmDiskListStr = this.m_asmDiscoveryString;
        } else if (asmDiskListStr != null && this.m_asmDiscoveryString != null) {
            this.m_checkDiscoveryString = true;
            if (asmGimrDisks != null) {
                asmDiskListStr = asmDiskListStr + "," + asmGimrDisks;
            }
        }
        this.m_inputDeviceList = asmDiskListStr != null ? asmDiskListStr.split(",") : this.m_globalContext.getASMdevices();
        Trace.out((String)("Input device list = " + VerificationUtil.strArr2List(this.m_inputDeviceList)));
        VerificationType verType = this.m_globalContext.getVerificationType();
        switch (verType) {
            case PREREQ_CRS_INST: 
            case BESTPRACTICE_PRE_CRS_INST: 
            case PREREQ_USM_CONFIG: {
                this.initPre();
                break;
            }
            case COMPONENT_ASM_INTEGRITY: 
            case POSTREQ_CRS_INST: {
                this.initPost(false);
                break;
            }
            case PREREQ_NODE_ADD: {
                if (this.m_globalContext.isBigCluster()) {
                    this.setNodeList(VerificationUtil.filterHubNodeList(VerificationUtil.addLocalNodeToNodeList(this.m_nodeList)));
                } else {
                    this.setNodeList(VerificationUtil.addLocalNodeToNodeList(this.m_nodeList));
                }
                this.initPost(true);
                break;
            }
        }
    }

    private void initPre() {
        String enableAFDChecks;
        String referenceGroup;
        if (this.m_inputDeviceList != null && VerificationUtil.isCellOSSetup()) {
            List<String> deviceList = Arrays.asList(this.m_inputDeviceList);
            String[] stringArray = this.m_inputDeviceList = (deviceList = this.filterOutCellOsPaths(deviceList)).isEmpty() ? null : deviceList.toArray(new String[0]);
        }
        if (!VerificationUtil.isStringGood(referenceGroup = this.m_globalContext.getASMAdminGroup())) {
            referenceGroup = VDMUtil.getDefaultAsmAdminGroup();
        }
        this.setReferenceOwner(VerificationUtil.getDefaultCRSUser());
        this.setReferenceGroup(referenceGroup);
        this.setReferencePermissions(VDMUtil.getDefaultAsmDisksPermissions());
        String reqRel = VerificationUtil.getCRSActiveVersion();
        if (!VerificationUtil.isStringGood(reqRel)) {
            reqRel = this.m_globalContext.getRequestedRelease();
        }
        if (VerificationUtil.isStringGood(reqRel)) {
            this.setVersion(reqRel);
        }
        if (VerificationUtil.isStringGood(enableAFDChecks = CVUVariables.getValue(CVUVariableConstants.ENABLE_AFD_CHECKS))) {
            this.setVerifyAFDPrereq(Boolean.valueOf(enableAFDChecks));
        }
    }

    private void initPost(boolean verifySharedness) {
        if (this.m_inputDeviceList == null) {
            this.m_deviceListAll = new ArrayList<String>();
            if (this.updateDiskGroupDiskMap() && this.m_htdg.get(m_localNode) != null) {
                Enumeration<String> e = this.m_htdg.get(m_localNode).keys();
                while (e.hasMoreElements()) {
                    String dg = e.nextElement();
                    if (dg.equals("#")) {
                        Trace.out((String)("skipping the following disks which do not belong toany diskgroup: " + this.m_htdg.get(m_localNode).get(dg)));
                        continue;
                    }
                    Trace.out((String)("Adding the disks of disk group " + dg));
                    this.m_deviceListAll.addAll((Collection<String>)this.m_htdg.get(m_localNode).get(dg));
                }
            }
        }
        if (this.m_deviceListAll != null && VerificationUtil.isCellOSSetup()) {
            this.m_deviceListAll = this.filterOutCellOsPaths(this.m_deviceListAll);
        }
        this.setReferenceOwner(VerificationUtil.getCRSUser(m_localNode, new Result(m_localNode), false));
        String group = null;
        try {
            group = VerificationUtil.getASMAdminGroup();
        }
        catch (CVUException ce) {
            Trace.out((String)("CVUEXCEPTION: getting ASM admin group ::" + ce.getMessage()));
        }
        if (!VerificationUtil.isStringGood(group)) {
            group = VDMUtil.getDefaultAsmAdminGroup();
        }
        this.setReferenceGroup(group);
        this.setReferencePermissions(VDMUtil.getDefaultAsmDisksPermissions());
        this.setVerifySharedness(verifySharedness);
        this.setVerifyAFDPrereq(false);
    }

    @Override
    protected boolean isTaskApplicable() throws VerificationException {
        VerificationType verType = this.m_globalContext.getVerificationType();
        switch (verType) {
            case PREREQ_CRS_INST: 
            case BESTPRACTICE_PRE_CRS_INST: 
            case PREREQ_USM_CONFIG: {
                return this.m_inputDeviceList != null;
            }
            case POSTREQ_CRS_INST: 
            case PREREQ_NODE_ADD: {
                return this.m_deviceListAll != null && !this.m_deviceListAll.isEmpty();
            }
        }
        return false;
    }

    public TaskASMDeviceChecks(String[] nodeList) {
        this(nodeList, null, 1);
    }

    public TaskASMDeviceChecks(String[] nodeList, MultiTaskHandler multiTaskHandler) {
        this(nodeList, multiTaskHandler, 1);
    }

    public TaskASMDeviceChecks(String[] nodeList, MultiTaskHandler multiTaskHandler, int actionOnCompletion) {
        super(nodeList, multiTaskHandler, actionOnCompletion);
    }

    @Override
    public boolean performTask() {
        this.m_resultSet.addResult(this.m_nodeList, 1);
        NativeSystem nativeSystem = new SystemFactory().CreateSystem();
        if (VerificationUtil.isCVUTestEnv() && VerificationUtil.isStringGood(VerificationUtil.getEnv("OSM_INSTALL_TEST"))) {
            Trace.out((String)"Found OSM_INSTALL_TEST variable set. It's a dummy Disk environment Hence skipping all the further ASM device Checks and returning SUCCESS");
        } else {
            ReportUtil.sureblankln();
            ReportUtil.sureprintln(LSEP + s_msgBundle.getMessage("4385", false));
            if (this.m_checkDiscoveryString) {
                this.expandDevicePaths(this.m_nodeList, this.m_asmDiscoveryString);
            }
            if (this.m_dgReuse) {
                if (this.m_deviceListAll == null) {
                    this.m_resultSet.addResultSetData(this.m_diskGroupRS);
                }
            } else if (this.m_deviceListAll == null) {
                if (this.m_inputDeviceList == null) {
                    if (this.m_version == null) {
                        this.m_version = "12.2.0.1.0";
                    }
                    String[] defaultDS = VerificationUtil.getDefaultDiscoveryDevice(this.m_version);
                    Trace.out((String)("No device string was specified on the command line. Using default ASM discovery string " + defaultDS));
                    String discoverMsg = s_msgBundle.getMessage("5194", false, (Object[])new String[]{Arrays.asList(defaultDS).toString()});
                    ReportUtil.sureprintln(discoverMsg);
                    ReportUtil.verboseReportPrintln(discoverMsg);
                    this.m_inputDeviceList = defaultDS;
                }
                this.m_deviceListAll = this.expandDevicePaths(this.m_inputDeviceList);
            }
            if (this.m_deviceListAll != null && !this.m_deviceListAll.isEmpty()) {
                this.performASMDeviceChecks();
                this.reportMultiplePaths();
            }
        }
        if (this.m_resultSet.allSuccess()) {
            if (this.m_resultSet.anyWarning()) {
                Trace.out((String)"ResultSet shows some Warnings");
            } else {
                Trace.out((String)"ResultSet shows all Success");
            }
            ReportUtil.printResult(s_msgBundle.getMessage("4386", false));
            ReportUtil.sureblankln();
            return true;
        }
        Trace.out((String)"ResultSet shows at least one failure");
        ReportUtil.printResult(s_msgBundle.getMessage("4387", false));
        ReportUtil.sureblankln();
        return false;
    }

    public void performASMDeviceChecks() {
        HashMap<String, Vector<StorageInfo>> storageInfoMap = new HashMap<String, Vector<StorageInfo>>();
        ArrayList<String> getFileInfoQueryPathList = new ArrayList<String>();
        NativeSystem nativeSystem = new SystemFactory().CreateSystem();
        boolean isUnixSystem = nativeSystem.isUnixSystem();
        String[] devArrAll = this.m_deviceListAll.toArray(new String[this.m_deviceListAll.size()]);
        if (this.m_nodeList != null && this.m_nodeList.length > 0) {
            if (devArrAll.length > 0) {
                List<String> deviceList = Arrays.asList(devArrAll);
                ArrayList<String> devicesManagedByASM = new ArrayList<String>();
                ArrayList<String> resolvedDevicePathList = new ArrayList<String>();
                ResultSet resolveDiskRes = StorageUtil.processASMDiskStamps(this.m_nodeList, deviceList, devicesManagedByASM, resolvedDevicePathList);
                this.m_resultSet.addResultSetData(resolveDiskRes);
                if (resolveDiskRes.anyFailure()) {
                    this.m_resultSet.addResult(this.m_nodeList, 2);
                    List<VerificationError> errorList = this.m_resultSet.getErrors();
                    String[] failedNodes = this.m_resultSet.getFailureNodes();
                    if (failedNodes != null && failedNodes.length > 0) {
                        for (String node : failedNodes) {
                            Result failedNodeRes = this.m_resultSet.getResult(node);
                            if (failedNodeRes == null) continue;
                            errorList.addAll(failedNodeRes.getErrors());
                        }
                    }
                    for (VerificationError err : errorList) {
                        ReportUtil.printError(err.getErrorMessage());
                    }
                    Trace.out((String)"Failed to resolve one or more of the ASM stamps to the real device path");
                    VerificationLogData.log("Failed to resolve one or more of the ASM stamps to the real device path");
                    return;
                }
                if (!devicesManagedByASM.isEmpty()) {
                    Trace.out((String)("The devices found to be managed by ASM are (" + devicesManagedByASM + ") and the complete device list is (" + deviceList + ")"));
                    VerificationLogData.log("The devices found to be managed by ASM are (" + devicesManagedByASM + ") and the complete device list is (" + deviceList + ")");
                    if (!resolvedDevicePathList.isEmpty()) {
                        Trace.out((String)("The resolved device path list is (" + resolvedDevicePathList + ") and the complete device list is (" + deviceList + ")"));
                        VerificationLogData.log("The resolved device path list is (" + resolvedDevicePathList + ") and the complete device list is (" + deviceList + ")");
                    }
                    String asmStampPassMsg = s_gMsgBundle.getMessage("10522", false, (Object[])new String[]{VerificationUtil.strCollection2String(devicesManagedByASM)});
                    ReportUtil.sureprintln(asmStampPassMsg);
                    ReportUtil.verboseReportPrintln(asmStampPassMsg);
                }
                if (devicesManagedByASM.size() == deviceList.size()) {
                    Trace.out((String)("All the devices (" + deviceList + ") were found to be " + "managed by ASM, no further device checks required"));
                    VerificationLogData.log("All the devices (" + deviceList + ") were " + "found to be managed by ASM, no further device checks required");
                    this.m_resultSet.setStatus(1);
                    return;
                }
                if (resolvedDevicePathList.size() > 0) {
                    Trace.out((String)("All the resolved stamps and devices list is (" + resolvedDevicePathList + ")"));
                    devArrAll = resolvedDevicePathList.toArray(new String[0]);
                }
            } else {
                Trace.out((String)("The discovery string " + VerificationUtil.strArr2List(this.m_inputDeviceList) + "Failed to discover any devices"));
                String errMsg = s_gMsgBundle.getMessage("11800", true, (Object[])new String[]{VerificationUtil.strArr2List(this.m_inputDeviceList), m_localNode});
                ReportUtil.sureprintln(errMsg);
                this.m_resultSet.addResult(this.m_nodeList, 3);
                this.m_resultSet.addErrorDescription(this.m_nodeList, new ErrorDescription(errMsg));
                return;
            }
        }
        getFileInfoQueryPathList.addAll(Arrays.asList(devArrAll));
        boolean cvuqdiskAvailable = false;
        if (VerificationUtil.isPlatformLinux() && this.m_verifySharedness) {
            ResultSet pkgRsltSet;
            if (devArrAll != null && devArrAll.length > 0 && VerificationUtil.isVirtualEnvironment()) {
                HashSet<String> storagesToCheck = new HashSet<String>();
                HashSet<String> storagesToSkip = new HashSet<String>();
                StorageUtil.filterStoragesIfVirtualEnvironment(Arrays.asList(devArrAll), storagesToCheck, storagesToSkip);
                if (storagesToCheck.isEmpty() && !VerificationUtil.isCVUTestEnv()) {
                    this.setVerifySharedness(false);
                    this.setVerifyDiskIOScheduler(false);
                }
            }
            if (this.m_verifySharedness && !(cvuqdiskAvailable = VerificationUtil.isCVUQDiskAvailable(this.m_nodeList, pkgRsltSet = new ResultSet(), this))) {
                Trace.out((String)"cvuqdisk is not available. Skipping sharedness check");
                this.setVerifySharedness(false);
                this.setVerifyDiskIOScheduler(false);
                this.m_resultSet.uploadResultSet(pkgRsltSet);
            }
        }
        if (this.m_verifySharedness) {
            TaskASMDeviceSharedness taskASMSharedness = new TaskASMDeviceSharedness(this.m_nodeList);
            taskASMSharedness.setDeviceArray(devArrAll);
            taskASMSharedness.setCvuqdiskCheckRequired(false);
            this.addChildTask(taskASMSharedness);
            taskASMSharedness.perform();
            this.m_resultSet.uploadResultSet(taskASMSharedness.getResultSet());
            storageInfoMap = taskASMSharedness.getStorageInfoMap();
            this.m_sharedSet = taskASMSharedness.getSharedSetVector();
            this.m_nonSharedSet = taskASMSharedness.getNonSharedSetVector();
            this.m_signaturePathMap = taskASMSharedness.getSignaturePathMap();
            this.m_stThreadArr = taskASMSharedness.getSharedStorageThreadArray();
            ArrayList nfsPathList = new ArrayList();
            if (storageInfoMap != null) {
                ArrayList<String> pathsProcessedList = new ArrayList<String>();
                pathsProcessedList.addAll(storageInfoMap.keySet());
                for (String path : pathsProcessedList) {
                    StorageInfo stinfo;
                    Vector<StorageInfo> stInfoSet = storageInfoMap.get(path);
                    if (stInfoSet.size() <= 0 || (stinfo = stInfoSet.firstElement()).getType() != 2) continue;
                    Trace.out((String)("Mark NFS path" + path + "for further processing"));
                    storageInfoMap.remove(path);
                }
                getFileInfoQueryPathList.removeAll(storageInfoMap.keySet());
                Trace.out((String)("removed all the paths processed " + storageInfoMap.keySet()));
            }
        }
        if (getFileInfoQueryPathList.isEmpty() && storageInfoMap.isEmpty()) {
            return;
        }
        if (isUnixSystem) {
            if (this.m_verifyACLs) {
                TaskACLChecks taskACLs = new TaskACLChecks(this.m_nodeList);
                taskACLs.setPathList(getFileInfoQueryPathList);
                taskACLs.setStorageInfoMap(storageInfoMap);
                taskACLs.setReferenceGroup(this.m_referenceGroup);
                taskACLs.setReferenceOwner(this.m_referenceOwner);
                taskACLs.setReferencePermissions(this.m_referencePermissions);
                this.addChildTask(taskACLs);
                taskACLs.perform();
                this.m_resultSet.uploadResultSet(taskACLs.getResultSet());
            }
            if (this.m_verifyAFDPrereq && StorageUtil.isAFDSupported()) {
                Trace.out((String)"Performing the prerequisites check for ASM Filter Driver");
                String proxyName = s_gMsgBundle.getMessage("10465", false);
                ResultSet afdResSet = this.performASMFilterDriverPrerequisites();
                TaskAnonymousProxy afdTask = new TaskAnonymousProxy(proxyName, this.m_nodeList, this, afdResSet);
                afdTask.perform();
                this.m_resultSet.uploadResultSet(afdResSet);
            }
            if (VerificationUtil.isPlatformLinux() && this.m_verifyDiskIOScheduler) {
                TaskCheckDiskScheduler taskDS = new TaskCheckDiskScheduler(this.m_nodeList);
                taskDS.setPathList(getFileInfoQueryPathList.toArray(new String[0]));
                taskDS.setStorageInfoMap(storageInfoMap);
                taskDS.setCvuqdiskCheckRequired(false);
                if (this.m_globalContext.isPreCRS()) {
                    taskDS.setPreCRSInst();
                }
                try {
                    if (taskDS.isApplicable()) {
                        this.addChildTask(taskDS);
                        taskDS.perform();
                        this.m_resultSet.uploadResultSet(taskDS.getResultSet());
                    }
                }
                catch (VerificationException ve) {
                    VerificationUtil.traceAndLog("Exception during checking task applicability of IO scheduler check. " + ve.getMessage());
                }
            }
        }
    }

    private ResultSet performASMFilterDriverPrerequisites() {
        ResultSet resultSet = new ResultSet();
        ReportUtil.sureblankln();
        ReportUtil.sureprintln(s_gMsgBundle.getMessage("12800", false));
        ResultSet deviceResultSet = null;
        if (this.m_htdg != null && !this.m_htdg.isEmpty()) {
            Trace.out((String)"Using device list retrieved using kfod for each node to validate if devices are AFD capable");
            deviceResultSet = StorageUtil.checkDiskListAFDCapable(this.m_nodeList, this.m_htdg);
        } else if (this.m_deviceListAll != null && !this.m_deviceListAll.isEmpty()) {
            Trace.out((String)"Using device list to validate if devices are AFD capable");
            deviceResultSet = StorageUtil.checkDiskListAFDCapable(this.m_nodeList, this.m_deviceListAll);
        }
        if (deviceResultSet != null) {
            resultSet.addResultSetData(deviceResultSet);
        }
        return resultSet;
    }

    private void reportMultiplePaths() {
        if (this.m_signaturePathMap.size() > 0) {
            Enumeration<Object> e = this.m_signaturePathMap.keys();
            while (e.hasMoreElements()) {
                ErrorDescription errorDesc;
                String mesg;
                String pathListStr;
                String signature = (String)e.nextElement();
                Vector<Object> pathListVec = this.m_signaturePathMap.get(signature);
                ArrayList<Object> diskSlices = new ArrayList<Object>();
                if (pathListVec.size() <= 1) continue;
                NativeSystem nativeSystem = new SystemFactory().CreateSystem();
                boolean isUnixSystem = nativeSystem.isUnixSystem();
                if (isUnixSystem) {
                    Hashtable filekeyPathMap = new Hashtable();
                    for (Object pathObj : pathListVec) {
                        String path = (String)pathObj;
                        String filekey = StorageUtil.getFileKey(path);
                        if (filekey == null) continue;
                        if (filekeyPathMap.containsKey(filekey)) {
                            ((List)filekeyPathMap.get(filekey)).add(path);
                            continue;
                        }
                        ArrayList<String> pathList = new ArrayList<String>();
                        pathList.add(path);
                        filekeyPathMap.put(filekey, pathList);
                    }
                    if (filekeyPathMap.size() > 0) {
                        Enumeration ef = filekeyPathMap.keys();
                        while (ef.hasMoreElements()) {
                            String filekey = (String)ef.nextElement();
                            List pathList = (List)filekeyPathMap.get(filekey);
                            if (pathList.size() != 1) continue;
                            diskSlices.add(pathList.get(0));
                            pathListVec.remove(pathList.get(0));
                        }
                    }
                } else {
                    diskSlices.addAll(pathListVec);
                    pathListVec.removeAllElements();
                }
                if (!pathListVec.isEmpty()) {
                    pathListStr = VerificationUtil.strCollection2String(pathListVec);
                    Trace.out((String)("The following paths point to the same physical disk: '" + pathListStr + "'"));
                    mesg = s_gMsgBundle.getMessage("1297", true, (Object[])new String[]{pathListStr});
                    errorDesc = new ErrorDescription(mesg);
                    this.m_resultSet.addResult(this.m_nodeList, 3);
                    this.m_resultSet.addErrorDescription(errorDesc);
                    ReportUtil.printError(mesg + LSEP);
                }
                if (diskSlices.isEmpty()) continue;
                pathListStr = VerificationUtil.strCollection2String(diskSlices);
                Trace.out((String)("The following paths with signature " + signature + " are slices of the same physical disk:" + " '" + pathListStr + "'"));
                mesg = s_gMsgBundle.getMessage("1303", true, (Object[])new String[]{pathListStr});
                errorDesc = new ErrorDescription(mesg);
                this.m_resultSet.addResult(this.m_nodeList, 3);
                this.m_resultSet.addErrorDescription(errorDesc);
                ReportUtil.printError(mesg + LSEP);
            }
        }
    }

    private void performUDEVChecks(String[] devArrAll) {
        TaskASMLibChecks asmPathCheck = new TaskASMLibChecks(this.m_nodeList);
        boolean devASMLIBManaged = false;
        if (this.m_inputDeviceList != null) {
            for (String devStr : this.m_inputDeviceList) {
                if (devStr.indexOf("ORCL") != -1) {
                    Trace.out((String)("Path '" + devStr + "' managed by ASMLIB."));
                    devASMLIBManaged = true;
                    break;
                }
                if (!asmPathCheck.isASMLIBPath(devStr)) continue;
                Trace.out((String)("Path '" + devStr + "' managed by ASMLIB."));
                devASMLIBManaged = true;
                break;
            }
        }
        if (VerificationUtil.isUDEVSupported() && !devASMLIBManaged) {
            Vector<String> nonMapperDevs = new Vector<String>();
            for (int i = 0; i < devArrAll.length; ++i) {
                if (devArrAll[i].matches("^/+dev/+mapper\\S*") || devArrAll[i].matches("^/+dev/+mpath\\S*")) continue;
                nonMapperDevs.add(devArrAll[i]);
            }
            if (nonMapperDevs.size() > 0) {
                TaskUSMUdevChecks taskASMDiskUdev = new TaskUSMUdevChecks(this.m_nodeList);
                taskASMDiskUdev.setASMDiskUDevCheck();
                taskASMDiskUdev.setASMDiskOwner(this.m_referenceOwner);
                taskASMDiskUdev.setASMDiskGroup(this.m_referenceGroup);
                taskASMDiskUdev.setASMDiskPermissions(this.m_referencePermissions);
                taskASMDiskUdev.setUdevCheckPaths(nonMapperDevs.toArray(new String[0]));
                this.addChildTask(taskASMDiskUdev);
                taskASMDiskUdev.perform();
                this.m_resultSet.uploadResultSet(taskASMDiskUdev.getResultSet());
            }
        }
    }

    public void setDeviceString(String[] devicestring) {
        this.m_inputDeviceList = devicestring;
    }

    public void setDeviceString(String devicestring) {
        this.m_inputDeviceList = new String[]{devicestring};
    }

    public TaskSharedStorageAccess.StorageThread[] getSharedStorageThreadArray() {
        return this.m_stThreadArr;
    }

    public String[] getDeviceString() {
        return this.m_inputDeviceList;
    }

    public void setVerifySharedness(boolean verifySharedness) {
        this.m_verifySharedness = verifySharedness;
    }

    public void setVerifyACLs(boolean verifyACLs) {
        this.m_verifyACLs = verifyACLs;
    }

    public void setVerifyAFDPrereq(boolean verifyAFDPrereq) {
        this.m_verifyAFDPrereq = verifyAFDPrereq;
    }

    public void setVerifyUdev(boolean verifyUdev) {
        this.m_verifyUdevAttr = verifyUdev;
    }

    public void setVerifyDiskIOScheduler(boolean verifyDiskIOScheduler) {
        this.m_verifyDiskIOScheduler = verifyDiskIOScheduler;
    }

    public void setReferenceOwner(String owner) {
        this.m_referenceOwner = owner;
    }

    public void setReferenceGroup(String group) {
        this.m_referenceGroup = group;
    }

    public void setReferencePermissions(String permissions) {
        this.m_referencePermissions = permissions;
    }

    public void setVersion(String version) {
        this.m_version = version;
    }

    @Override
    public NodeRoleCapability getApplicableNodeRoleCapability() {
        return NodeRoleCapability.HUB_CAPABLE;
    }

    public Vector<TaskSharedStorageAccess.StorageThread> getSharedSetVector() {
        return this.m_sharedSet;
    }

    public Vector<TaskSharedStorageAccess.StorageThread> getNonSharedSetVector() {
        return this.m_nonSharedSet;
    }

    private boolean updateDiskGroupDiskMap() {
        boolean result = false;
        try {
            result = new ASMDiskGroupsUtil().getDiskGroupsDiskMap(new String[]{m_localNode}, this.m_diskGroupRS, this.m_htdg) && this.m_diskGroupRS.anySuccess();
        }
        catch (ASMDiskGroupsUtilException e) {
            Trace.out((String)("Failed to discover the asm disks of the disk groups\n" + e.getMessage()));
        }
        return result;
    }

    private List<String> expandDevicePaths(String[] nodes, String[] deviceArr) {
        ResultSet resSet = new ResultSet();
        ArrayList<String> deviceListAll = null;
        if (deviceArr != null && deviceArr.length > 0) {
            Set<String> deviceSet = StorageUtil.expandDevicePaths(nodes, deviceArr, resSet);
            if (deviceSet != null && !deviceSet.isEmpty()) {
                deviceListAll = new ArrayList<String>();
                deviceListAll.addAll(deviceSet);
            }
            if (resSet.getStatus() == 2) {
                this.m_resultSet.addResult(this.m_nodeList, 2);
                String errMsg = s_gMsgBundle.getMessage("11800", true, (Object[])new String[]{VerificationUtil.strArr2List(deviceArr), VerificationUtil.strArr2List(nodes)});
                this.m_resultSet.addErrorDescription(m_localNode, new ErrorDescription(errMsg));
                return null;
            }
            this.m_resultSet.addResultSetData(resSet);
        }
        return deviceListAll;
    }

    private List<String> expandDevicePaths(String[] nodes, String discoveryString) {
        if (VerificationUtil.isStringGood(discoveryString)) {
            return this.expandDevicePaths(nodes, discoveryString.split(","));
        }
        return null;
    }

    private List<String> expandDevicePaths(String[] deviceString) {
        String[] nodes = new String[]{VerificationUtil.getLocalNode()};
        return this.expandDevicePaths(nodes, deviceString);
    }

    private List<String> filterOutCellOsPaths(List<String> deviceList) {
        ArrayList<String> filteredList = new ArrayList<String>();
        for (String path : deviceList) {
            if (StorageUtil.isExadataPath(path)) continue;
            filteredList.add(path);
        }
        return filteredList;
    }

    @Override
    public String getDefaultElementName() {
        return s_msgBundle.getMessage("4444", false);
    }

    @Override
    public String getDefaultDescription() {
        return s_msgBundle.getMessage("4496", false);
    }
}

