/*
 * Decompiled with CFR 0.152.
 */
package oracle.ops.verification.framework.engine.task;

import java.util.ArrayList;
import java.util.List;
import oracle.cluster.impl.verification.DiskGroupResultSetImpl;
import oracle.cluster.verification.VerificationException;
import oracle.cluster.verification.util.VerificationType;
import oracle.cluster.winsecurity.Home;
import oracle.cluster.winsecurity.WinSecurityFactory;
import oracle.cluster.winsecurity.WindowsSecurityException;
import oracle.ops.mgmt.cluster.Version;
import oracle.ops.mgmt.trace.Trace;
import oracle.ops.verification.framework.engine.ErrorDescription;
import oracle.ops.verification.framework.engine.factory.context.VerificationTaskContext;
import oracle.ops.verification.framework.engine.task.Task;
import oracle.ops.verification.framework.report.ReportUtil;
import oracle.ops.verification.framework.util.ASMDiskGroupsUtil;
import oracle.ops.verification.framework.util.ASMDiskGroupsUtilException;
import oracle.ops.verification.framework.util.ASMUtils;
import oracle.ops.verification.framework.util.ASMUtilsException;
import oracle.ops.verification.framework.util.CVUVariableConstants;
import oracle.ops.verification.framework.util.CVUVariables;
import oracle.ops.verification.framework.util.NodelistNotFoundException;
import oracle.ops.verification.framework.util.VerificationUtil;

public class TaskASMACLAttributeCheck
extends Task {
    private List<String> m_dgList = null;
    private VerificationType m_vfyType = null;
    boolean m_isAclCheckRequired = false;
    boolean m_asmRunning = false;
    private DiskGroupResultSetImpl m_dgResultSet;

    public TaskASMACLAttributeCheck() {
    }

    public TaskASMACLAttributeCheck(VerificationTaskContext ctx) {
        super(ctx);
    }

    public TaskASMACLAttributeCheck(List<String> dgList) {
        if (dgList != null) {
            this.m_dgList = new ArrayList<String>();
            this.m_dgList.addAll(dgList);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected void init() {
        try {
            this.m_nodeList = VerificationUtil.getStaticNodelist();
        }
        catch (NodelistNotFoundException ne) {
            Trace.out((String)("Node list was not found " + ne.getMessage()));
            return;
        }
        ArrayList<String> runningNodeList = new ArrayList<String>();
        ArrayList<String> failedNodeList = new ArrayList<String>();
        ASMDiskGroupsUtil asmdg = new ASMDiskGroupsUtil();
        try {
            Trace.out((String)"checking if asm is running");
            asmdg.checkASMRunning(this.m_nodeList, runningNodeList, failedNodeList);
        }
        catch (ASMDiskGroupsUtilException e) {
            Trace.out((String)("ASMDG exception while checking for asm " + e.getMessage()));
            return;
        }
        if (runningNodeList.size() > 0) {
            this.m_asmRunning = true;
        }
        this.m_vfyType = this.m_globalContext.getVerificationType();
        if (this.m_vfyType == null) return;
        switch (this.m_vfyType) {
            case PREREQ_DB_INST: {
                if (!this.m_globalContext.isUpgrade()) {
                    return;
                }
                String oracleHome = CVUVariables.getValue(CVUVariableConstants.SRC_RAC_HOME);
                if (oracleHome == null || oracleHome.length() == 0) {
                    Trace.out((String)"Source Oracle home variable is not set");
                    return;
                }
                String srcHomeUser = null;
                String destHomeUser = null;
                String destloc = VerificationUtil.getDestLoc();
                String srcloc = VerificationUtil.getCVHome();
                try {
                    WinSecurityFactory wsecFac = WinSecurityFactory.getInstance((String)srcloc, (String)destloc);
                    Home home = wsecFac.getHome(oracleHome, new Version());
                    srcHomeUser = home.getServiceUserFromHomePath().getUsername();
                }
                catch (WindowsSecurityException e) {
                    Trace.out((String)("WSE in pre upgrade check" + e.getMessage()));
                    return;
                }
                if (VerificationUtil.isCLIMode()) {
                    if (!this.m_globalContext.isServiceUserSpecifiedOnCLI()) {
                        Trace.out((String)"Commmand line mode with no service user credentials.");
                        return;
                    }
                    destHomeUser = CVUVariables.getValue(CVUVariableConstants.SERVICE_USER);
                } else if (VerificationUtil.isAPIMode()) {
                    destHomeUser = CVUVariables.getValue(CVUVariableConstants.WINSEC_SERVICE_USERNAME);
                }
                if (!VerificationUtil.isStringGood(srcHomeUser)) return;
                if (!VerificationUtil.isStringGood(destHomeUser)) return;
                if (srcHomeUser.equalsIgnoreCase(destHomeUser)) {
                    Trace.out((String)"ASM ACL enabled check is skipped as the user specified  is same as the current oracle home user");
                    return;
                }
                this.m_isAclCheckRequired = true;
                return;
            }
        }
    }

    @Override
    protected boolean isTaskApplicable() throws VerificationException {
        return this.m_asmRunning && this.m_isAclCheckRequired;
    }

    @Override
    public boolean performTask() {
        this.m_dgResultSet = new DiskGroupResultSetImpl();
        ReportUtil.sureprintln(s_gMsgBundle.getMessage("13165", false));
        try {
            if (this.m_dgList == null || this.m_dgList.isEmpty()) {
                this.m_dgList = ASMUtils.getASMDgList();
            }
            this.m_resultSet.addResult(m_localNode, 1);
            this.m_dgResultSet.addResult(this.m_dgList, 1);
            List<String> dgList = ASMUtils.getACLEnabledDGList(this.m_dgList);
            if (dgList.isEmpty()) {
                ReportUtil.sureprintln(s_gMsgBundle.getMessage("13166", false));
                return true;
            }
            String errMsg = s_gMsgBundle.getMessage("13167", true, (Object[])new String[]{VerificationUtil.strList2List(dgList)});
            ErrorDescription errDesc = new ErrorDescription(errMsg);
            this.m_dgResultSet.addErrorDescription(errDesc);
            this.m_dgResultSet.addResult(dgList, 3);
            ReportUtil.sureprintln(errMsg);
            return false;
        }
        catch (ASMUtilsException ae) {
            Trace.out((String)("failed to get diskgroup list from ASM" + ae.getMessage()));
            String errMsg = s_gMsgBundle.getMessage("13168", true) + LSEP + ae.getMessage();
            ErrorDescription errDesc = new ErrorDescription(errMsg);
            this.m_resultSet.addErrorDescription(errDesc);
            this.m_resultSet.addResult(m_localNode, 2);
            ReportUtil.sureprintln(errMsg);
            return false;
        }
    }

    public DiskGroupResultSetImpl getDiskGroupResultSetImpl() {
        return this.m_dgResultSet;
    }

    @Override
    public String getDefaultElementName() {
        return s_gMsgBundle.getMessage("13169", false);
    }

    @Override
    public String getDefaultDescription() {
        return s_gMsgBundle.getMessage("13170", false);
    }
}

