/*
 * Decompiled with CFR 0.152.
 */
package oracle.ops.verification.framework.engine.task;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import oracle.cluster.impl.verification.SharedStorageResultSetImpl;
import oracle.cluster.verification.StorageSize;
import oracle.cluster.verification.StorageUnit;
import oracle.cluster.verification.VerificationException;
import oracle.cluster.verification.common.CVUException;
import oracle.cluster.verification.util.VerificationType;
import oracle.ops.mgmt.trace.Trace;
import oracle.ops.verification.framework.VerificationConstants;
import oracle.ops.verification.framework.config.VDMUtil;
import oracle.ops.verification.framework.engine.ErrorDescription;
import oracle.ops.verification.framework.engine.Result;
import oracle.ops.verification.framework.engine.ResultSet;
import oracle.ops.verification.framework.engine.factory.context.VerificationTaskContext;
import oracle.ops.verification.framework.engine.factory.data.ExecutableArgument;
import oracle.ops.verification.framework.engine.factory.data.ExecutableInfo;
import oracle.ops.verification.framework.engine.task.MultiTaskHandler;
import oracle.ops.verification.framework.engine.task.Task;
import oracle.ops.verification.framework.global.GlobalExecution;
import oracle.ops.verification.framework.report.ReportUtil;
import oracle.ops.verification.framework.storage.StorageInfo;
import oracle.ops.verification.framework.util.FileInfo;
import oracle.ops.verification.framework.util.VerificationUtil;

public class TaskACLChecks
extends Task {
    private final int DEV_OWNER = 1;
    private final int DEV_GROUP = 2;
    private final int DEV_PERMS = 3;
    private final int DEV_SIZE = 4;
    private final String DEV_OWNER_STR = "Owner";
    private final String DEV_GROUP_STR = "Group";
    private final String DEV_PERMS_STR = "Permissions";
    private final String DEV_SIZE_STR = "Size";
    private static final String FILE_STATUS_FAILED = "1";
    private SharedStorageResultSetImpl m_ssResSetImpl;
    private String m_referenceOwner = null;
    private String m_referenceGroup = null;
    private String m_referencePermissions = null;
    private HashMap<String, Vector<StorageInfo>> m_storageInfoMap = new HashMap();
    List<String> m_pathList = null;

    public TaskACLChecks(VerificationTaskContext ctx) {
        super(ctx);
    }

    public TaskACLChecks(String[] nodeList) {
        this(nodeList, null, 1);
    }

    public TaskACLChecks(String[] nodeList, MultiTaskHandler multiTaskHandler) {
        this(nodeList, multiTaskHandler, 1);
    }

    public TaskACLChecks(String[] nodeList, MultiTaskHandler multiTaskHandler, int actionOnCompletion) {
        super(nodeList, multiTaskHandler, actionOnCompletion);
    }

    @Override
    protected void init() {
        if (this.m_globalContext.isASMCheck()) {
            this.m_pathList = Arrays.asList(this.m_globalContext.getASMdevices());
        }
        String deviceType = null;
        ExecutableInfo execInfo = this.m_ctx.getExecInfo();
        for (ExecutableArgument arg : execInfo.getExecutableArgs()) {
            String argName = arg.getArgName();
            String argVal = arg.getArgVal(true);
            if ("TYPE".equals(argName)) {
                deviceType = argVal;
                continue;
            }
            Trace.out((String)("unknown argument. name=" + argName + ". value=" + argVal));
        }
        if (deviceType != null && deviceType.equalsIgnoreCase("ASM")) {
            VerificationType verType = this.m_globalContext.getVerificationType();
            switch (verType) {
                case PREREQ_CRS_INST: 
                case BESTPRACTICE_PRE_CRS_INST: 
                case PREREQ_USM_CONFIG: {
                    String referenceGroup = this.m_globalContext.getASMAdminGroup();
                    if (!VerificationUtil.isStringGood(referenceGroup)) {
                        referenceGroup = VDMUtil.getDefaultAsmAdminGroup();
                    }
                    this.setReferenceOwner(VerificationUtil.getDefaultCRSUser());
                    this.setReferenceGroup(referenceGroup);
                    this.setReferencePermissions(VDMUtil.getDefaultAsmDisksPermissions());
                    break;
                }
                case COMPONENT_ASM_INTEGRITY: 
                case POSTREQ_CRS_INST: {
                    this.setReferenceOwner(VerificationUtil.getCRSUser(m_localNode, new Result(m_localNode), false));
                    String group = null;
                    try {
                        group = VerificationUtil.getASMAdminGroup();
                    }
                    catch (CVUException ce) {
                        Trace.out((String)("CVUEXCEPTION: getting ASM admin group ::" + ce.getMessage()));
                    }
                    if (!VerificationUtil.isStringGood(group)) {
                        group = VerificationUtil.getDefaultAsmAdminGroup();
                    }
                    this.setReferenceGroup(group);
                    this.setReferencePermissions(VDMUtil.getDefaultAsmDisksPermissions());
                    break;
                }
            }
        }
    }

    @Override
    protected boolean isTaskApplicable() throws VerificationException {
        return this.m_pathList != null && VerificationUtil.isStringGood(this.m_referenceOwner) && VerificationUtil.isStringGood(this.m_referenceGroup) && VerificationUtil.isStringGood(this.m_referencePermissions);
    }

    @Override
    public boolean performTask() {
        this.m_ssResSetImpl = new SharedStorageResultSetImpl();
        if (this.m_pathList.size() > 0) {
            GlobalExecution globalExec = new GlobalExecution();
            ResultSet fileInfoResultSet = new ResultSet();
            boolean fileInfoResult = globalExec.getFileInfo(this.m_nodeList, this.m_pathList, fileInfoResultSet);
            if (!fileInfoResult) {
                ReportUtil.printError(s_msgBundle.getMessage("4160", false));
                fileInfoResultSet.addResult(this.m_nodeList, 2);
                ErrorDescription errDesc = new ErrorDescription("4160", s_msgBundle);
                fileInfoResultSet.addErrorDescription(this.m_nodeList, errDesc);
                this.m_ssResSetImpl.addResultSetData(fileInfoResultSet);
            } else {
                Hashtable fileInforResultTable = fileInfoResultSet.getResultTable();
                Hashtable<String, ArrayList<String>> failedFileHT = new Hashtable<String, ArrayList<String>>();
                Hashtable<String, ArrayList<String>> fileNodeListHT = new Hashtable<String, ArrayList<String>>();
                for (String node : this.m_nodeList) {
                    Result result = (Result)fileInforResultTable.get(node);
                    if (result != null && result.getStatus() == 1) {
                        Hashtable nodeFileHT = (Hashtable)result.getResultInfoSet().elementAt(0);
                        for (String file : nodeFileHT.keySet()) {
                            FileInfo nodeFileInfo = (FileInfo)nodeFileHT.get(file);
                            if (FILE_STATUS_FAILED.equals(nodeFileInfo.getStatus())) {
                                fileInfoResultSet.addResult(node, 3);
                                String failedFile = nodeFileInfo.getFileName();
                                ArrayList<String> fileErrors = (ArrayList<String>)failedFileHT.get(failedFile);
                                ArrayList<String> failedNodeList = (ArrayList<String>)fileNodeListHT.get(failedFile);
                                if (fileErrors == null) {
                                    fileErrors = new ArrayList<String>();
                                }
                                fileErrors.add(nodeFileInfo.getErrorString());
                                failedFileHT.put(failedFile, fileErrors);
                                if (failedNodeList == null) {
                                    failedNodeList = new ArrayList<String>();
                                }
                                failedNodeList.add(node);
                                fileNodeListHT.put(failedFile, failedNodeList);
                                String msg = s_msgBundle.getMessage("9994", true, (Object[])new String[]{failedFile, node});
                                ErrorDescription error = new ErrorDescription(msg + LSEP + nodeFileInfo.getErrorString());
                                fileInfoResultSet.addErrorDescription(node, error);
                                continue;
                            }
                            StorageInfo st = new StorageInfo();
                            st.setNode(node);
                            st.setName(nodeFileInfo.getFileName());
                            st.setOwner(nodeFileInfo.getFileOwner());
                            st.setGroup(nodeFileInfo.getFileGroup());
                            st.setPermissions(nodeFileInfo.getFilePermissions());
                            st.setSize(new StorageSize(0.0, StorageUnit.BYTE));
                            Vector<StorageInfo> storageInfoList = this.m_storageInfoMap.get(nodeFileInfo.getFileName());
                            if (storageInfoList == null) {
                                storageInfoList = new Vector();
                                this.m_storageInfoMap.put(nodeFileInfo.getFileName(), storageInfoList);
                            }
                            storageInfoList.add(st);
                        }
                        if (failedFileHT.size() == 0) continue;
                        for (String file : failedFileHT.keySet()) {
                            this.m_storageInfoMap.remove(file);
                            String fileErrors = VerificationUtil.strCollection2String((Collection)failedFileHT.get(file), VerificationConstants.LSEP);
                            String errorNodes = VerificationUtil.strCollection2String((Collection)fileNodeListHT.get(file));
                            String msg = s_msgBundle.getMessage("9994", true, (Object[])new String[]{file, errorNodes});
                            ReportUtil.printError(msg);
                            ReportUtil.sureprintln(fileErrors);
                        }
                        continue;
                    }
                    String msg = s_msgBundle.getMessage("9995", true, (Object[])new String[]{node});
                    ReportUtil.printError(msg);
                    ErrorDescription error = new ErrorDescription(msg);
                    fileInfoResultSet.addErrorDescription(node, error);
                }
            }
            this.m_ssResSetImpl.addResultSetData(fileInfoResultSet);
        }
        if (this.m_storageInfoMap.size() > 0) {
            this.verifyAttribPermissions(this.m_storageInfoMap, 1, "Owner", this.m_referenceOwner, "5115", "5116", "5117", "5118", "9991");
            this.verifyAttribPermissions(this.m_storageInfoMap, 2, "Group", this.m_referenceGroup, "5119", "5120", "5121", "5122", "9992");
            this.verifyAttribPermissions(this.m_storageInfoMap, 3, "Permissions", this.m_referencePermissions, "5123", "5124", "5125", "5126", "9993");
        }
        this.m_resultSet.addResultSetData(this.m_ssResSetImpl);
        if (this.m_ssResSetImpl.allSuccess()) {
            if (this.m_ssResSetImpl.anyWarning()) {
                Trace.out((String)"ResultSet shows some Warnings");
            } else {
                Trace.out((String)"ResultSet shows all Success");
            }
            return true;
        }
        Trace.out((String)"ResultSet shows at least one failure");
        return false;
    }

    private void verifyAttribPermissions(HashMap<String, Vector<StorageInfo>> storageInfoMap, int attrib, String header, String reference, String strtitle, String strpass, String strinconsistent, String strfail, String strincosistentRef) {
        Trace.out((int)2, (String)"Entry");
        Iterator<Vector<StorageInfo>> iter = storageInfoMap.values().iterator();
        StorageInfo firstst = null;
        if (iter.hasNext()) {
            firstst = iter.next().firstElement();
        }
        if (!this.getAttrib(attrib, firstst).equals("UNSUPPORTED")) {
            Trace.out((String)("Performing " + header + " permissions check..."));
            Trace.out((String)("Check if each device has same " + header + " on all nodes..."));
            ReportUtil.sureblankln();
            String titleMsg = LSEP + s_msgBundle.getMessage(strtitle, false);
            ReportUtil.sureprintln(titleMsg);
            ReportUtil.verboseReportPrintln(titleMsg);
            boolean overallfail = false;
            Set<String> pathSet = storageInfoMap.keySet();
            for (String path : pathSet) {
                HashMap<String, List<String>> hmap = this.getHashMapbyAttribute(storageInfoMap.get(path), attrib);
                if (hmap.size() == 1) {
                    String message;
                    Trace.out((String)("Device " + path + " has same " + header + " on all nodes."));
                    Iterator<Map.Entry<String, List<String>>> it = hmap.entrySet().iterator();
                    Map.Entry<String, List<String>> entry = it.next();
                    String nodeValue = entry.getKey();
                    List<String> nodeList = entry.getValue();
                    boolean match = true;
                    if (reference != null && reference.length() != 0) {
                        match = attrib == 3 ? Integer.parseInt(reference, 8) == Integer.parseInt(nodeValue, 8) : reference.equals(nodeValue);
                    }
                    if (match) {
                        message = s_msgBundle.getMessage(strpass, false, (Object[])new String[]{path});
                        this.m_ssResSetImpl.addResult(this.m_nodeList, 1);
                        ReportUtil.sureprintln(message);
                        ReportUtil.verboseReportPrintln(message);
                        continue;
                    }
                    Trace.out((String)("Device " + path + " " + header + " did not match the reference " + reference + " on nodes: " + nodeList.toString()));
                    overallfail = true;
                    message = s_msgBundle.getMessage(strincosistentRef, true, (Object[])new String[]{path, reference, nodeValue, nodeList.toString()});
                    this.m_ssResSetImpl.addResult(this.m_nodeList, 3);
                    this.m_ssResSetImpl.addErrorDescription(this.m_nodeList, new ErrorDescription(message));
                    ReportUtil.sureprintln(message);
                    continue;
                }
                overallfail = true;
                Trace.out((String)("Device " + path + " has different " + header + " across all nodes."));
                String message = s_msgBundle.getMessage(strinconsistent, true, (Object[])new String[]{path});
                for (Map.Entry<String, List<String>> entry : hmap.entrySet()) {
                    String device = entry.getKey();
                    List<String> nodes = entry.getValue();
                    switch (attrib) {
                        case 1: {
                            message = message + LSEP + s_gMsgBundle.getMessage("13364", false, (Object[])new String[]{device, VerificationUtil.strList2List(nodes)});
                            break;
                        }
                        case 2: {
                            message = message + LSEP + s_gMsgBundle.getMessage("13365", false, (Object[])new String[]{device, VerificationUtil.strList2List(nodes)});
                            break;
                        }
                        case 3: {
                            message = message + LSEP + s_gMsgBundle.getMessage("13366", false, (Object[])new String[]{device, VerificationUtil.strList2List(nodes)});
                        }
                    }
                }
                this.m_ssResSetImpl.addResult(this.m_nodeList, 3);
                this.m_ssResSetImpl.addErrorDescription(new ErrorDescription(message));
                ReportUtil.sureprintln(message);
            }
            if (overallfail) {
                Trace.out((String)("Check for " + header + " at least one path failed. Test failed."));
                ReportUtil.sureprintln(LSEP + s_msgBundle.getMessage(strfail, false));
            }
        }
    }

    private HashMap<String, List<String>> getHashMapbyAttribute(Vector<StorageInfo> stInfoSet, int attrib) {
        Trace.out((int)2, (String)"Entry");
        String strattrib = null;
        HashMap<String, List<String>> hmap = new HashMap<String, List<String>>();
        Enumeration<StorageInfo> shrEnum = stInfoSet.elements();
        while (shrEnum.hasMoreElements()) {
            StorageInfo strgInfo = shrEnum.nextElement();
            strattrib = this.getAttrib(attrib, strgInfo);
            if (strattrib == null) continue;
            List<String> ndList = hmap.get(strattrib);
            if (ndList == null) {
                ndList = new ArrayList<String>();
                hmap.put(strattrib, ndList);
                Trace.out((String)("Adding new entry into hmap for attribute " + attrib));
            }
            ndList.add(strgInfo.getNode());
        }
        Trace.out((int)2, (String)"Exit");
        return hmap;
    }

    private String getAttrib(int attrib, StorageInfo strgInfo) {
        String strattrib;
        switch (attrib) {
            case 1: {
                strattrib = strgInfo.getOwner();
                break;
            }
            case 2: {
                strattrib = strgInfo.getGroup();
                break;
            }
            case 3: {
                strattrib = strgInfo.getPermissions();
                break;
            }
            case 4: {
                StorageSize strgsize = strgInfo.getSize();
                if (strgsize.compareTo(new StorageSize(-2.0, StorageUnit.BYTE)) != 0) {
                    strattrib = new String(strgsize.toString());
                    Trace.out((String)("Size of disk = " + strattrib));
                    break;
                }
                strattrib = new String("UNSUPPORTED");
                break;
            }
            default: {
                strattrib = null;
            }
        }
        return strattrib;
    }

    public void setPathList(List<String> pathList) {
        this.m_pathList = pathList;
    }

    public void setStorageInfoMap(HashMap<String, Vector<StorageInfo>> stInfoMap) {
        this.m_storageInfoMap.putAll(stInfoMap);
    }

    public void setReferenceOwner(String owner) {
        this.m_referenceOwner = owner;
    }

    public void setReferenceGroup(String group) {
        this.m_referenceGroup = group;
    }

    public void setReferencePermissions(String permissions) {
        this.m_referencePermissions = permissions;
    }

    public HashMap<String, Vector<StorageInfo>> getStorageInfoMap() {
        return this.m_storageInfoMap;
    }

    public List<String> getPathList() {
        return this.m_pathList;
    }

    public SharedStorageResultSetImpl getSharedStorageResultSetImpl() {
        return this.m_ssResSetImpl;
    }

    @Override
    public String getDefaultElementName() {
        return s_gMsgBundle.getMessage("13162", false);
    }

    @Override
    public String getDefaultDescription() {
        return s_gMsgBundle.getMessage("13163", false);
    }
}

