/*
 * Decompiled with CFR 0.152.
 */
package oracle.ops.verification.framework.engine.task;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import oracle.cluster.verification.SubtasksUnavailableException;
import oracle.cluster.verification.VerificationTask;
import oracle.cluster.verification.pluggable.PluggableMsgType;
import oracle.ops.mgmt.trace.Trace;
import oracle.ops.verification.framework.engine.factory.context.PluggableTaskContext;
import oracle.ops.verification.framework.engine.factory.data.ArgType;
import oracle.ops.verification.framework.engine.factory.data.DataType;
import oracle.ops.verification.framework.engine.factory.data.ExecutableArgument;
import oracle.ops.verification.framework.engine.factory.data.ExecutableInfo;
import oracle.ops.verification.framework.engine.task.ContainerTaskInterface;
import oracle.ops.verification.framework.engine.task.PluggableTask;
import oracle.ops.verification.framework.engine.task.Task;
import oracle.ops.verification.framework.util.CVUVariableConstants;
import oracle.ops.verification.framework.util.CVUVariables;
import oracle.ops.verification.framework.util.VerificationUtil;

public class PluggableDatabaseTask
extends PluggableTask
implements ContainerTaskInterface {
    private static final String DB_NAME_SEP = ",";
    private String m_dbName = null;
    private List<Task> m_subTaskList = new ArrayList<Task>();
    private boolean m_isInitialized = false;
    private static HashMap<String, PluggableDatabaseTask> m_containerObjMap = new HashMap();

    public PluggableDatabaseTask(PluggableTaskContext ctx, String pluggableTaskID) {
        super(ctx, pluggableTaskID);
        if (!m_containerObjMap.containsKey(pluggableTaskID)) {
            m_containerObjMap.put(pluggableTaskID, this);
        }
    }

    public PluggableDatabaseTask(PluggableTaskContext ctx, String pluggableTaskID, String dbName) {
        super(ctx, pluggableTaskID);
        this.m_dbName = dbName;
    }

    public PluggableDatabaseTask(PluggableTaskContext ctx, String pluggableTaskID, Collection<Task> subtaskList) {
        super(ctx, pluggableTaskID);
        this.m_subTaskList.addAll(subtaskList);
    }

    @Override
    protected void init() {
        if (!this.m_isInitialized) {
            String dbNameStr = CVUVariables.getValue(CVUVariableConstants.DB_NAME);
            if (VerificationUtil.isStringGood(dbNameStr)) {
                if (dbNameStr.contains(DB_NAME_SEP)) {
                    String[] dbNameArr;
                    for (String dbName : dbNameArr = dbNameStr.split(DB_NAME_SEP)) {
                        ExecutableInfo ei = (ExecutableInfo)this.m_ctx.getExecInfo().clone();
                        ei.setExecutableArgs(new ArrayList<ExecutableArgument>());
                        ei.addExecArgument(new ExecutableArgument(CVUVariableConstants.DB_NAME.name(), ArgType.DEFINED, DataType.STRING, dbName.trim()));
                        PluggableTaskContext ctx = new PluggableTaskContext(ei, this.getIdMsgParams(), this.m_ctx.isDarwin());
                        ctx.setNodeList(this.m_ctx.getNodeList());
                        PluggableDatabaseTask dbTask = new PluggableDatabaseTask(ctx, this.m_defaultTaskID, dbName);
                        ((PluggableTask)dbTask).setInitialValidation(this.m_initValidation);
                        m_containerObjMap.get(this.m_defaultTaskID).addTaskToContainer(dbTask);
                        Trace.out((String)("Pluggable database task " + this.m_defaultTaskID + " created " + "for the database " + dbName));
                    }
                } else {
                    this.m_dbName = dbNameStr;
                    this.m_ctx.getExecInfo().addExecArgument(new ExecutableArgument(CVUVariableConstants.DB_NAME.name(), ArgType.DEFINED, DataType.STRING, dbNameStr.trim()));
                }
            }
            this.m_isInitialized = true;
        }
    }

    @Override
    public boolean isTaskApplicable() {
        return VerificationUtil.isStringGood(this.m_dbName) || !this.m_subTaskList.isEmpty();
    }

    public String getDatabaseName() {
        return this.m_dbName;
    }

    public void setDatabaseName(String dbName) {
        this.m_dbName = dbName;
    }

    @Override
    public Task addTaskToContainer(Task t) {
        Task taskObj = t;
        boolean addTask = true;
        for (Task uet : this.m_subTaskList) {
            if (!this.compare((PluggableDatabaseTask)t, (PluggableDatabaseTask)uet)) continue;
            Trace.out((String)("Found an existing instance of database check for database (" + this.m_dbName));
            taskObj = uet;
            addTask = false;
        }
        if (addTask) {
            this.m_subTaskList.add(t);
        }
        return taskObj;
    }

    private Collection<Task> getSubtaskList() {
        return this.m_subTaskList;
    }

    private boolean compare(PluggableDatabaseTask t1, PluggableDatabaseTask t2) {
        return t1.getDatabaseName().trim().equalsIgnoreCase(t2.getDatabaseName().trim());
    }

    @Override
    public Task getContainerObject() {
        return m_containerObjMap.get(this.m_defaultTaskID);
    }

    @Override
    public boolean hasSubtasks() {
        return !this.m_subTaskList.isEmpty();
    }

    @Override
    public List<VerificationTask> getSubtasks() throws SubtasksUnavailableException {
        ArrayList<VerificationTask> listOfSubtasks = new ArrayList<VerificationTask>();
        if (this.m_subTaskList.isEmpty()) {
            throw new SubtasksUnavailableException(s_msgBundle.getMessage("7504", false));
        }
        for (Task t : this.m_subTaskList) {
            listOfSubtasks.add(t);
        }
        return listOfSubtasks;
    }

    @Override
    public void setNodeList(String[] nodeList) {
        this.m_nodeList = nodeList;
        for (Task t : this.m_subTaskList) {
            t.setNodeList(this.m_nodeList);
        }
    }

    @Override
    public boolean isContainerTask() {
        return !this.m_subTaskList.isEmpty();
    }

    @Override
    public Task finalizeContainer() {
        Trace.out((String)"Finalizing the container.");
        Task container = m_containerObjMap.get(this.m_defaultTaskID);
        m_containerObjMap.remove(this.m_defaultTaskID);
        return container;
    }

    @Override
    public String getTaskName() {
        return !VerificationUtil.isHealthCheckMode() && !VerificationUtil.isBaselineCollectionMode() && VerificationUtil.isStringGood(this.m_dbName) ? this.getTaskID() + "_" + this.m_dbName : this.getTaskID();
    }

    @Override
    public String getDefaultElementName() {
        String elementName = this.m_plgUtil.getPluggableMsg(PluggableMsgType.TASK_ELEMENT_NAME, this.getTaskID(), this.m_ctx.getIdMsgParams());
        if (VerificationUtil.isStringGood(elementName)) {
            return !VerificationUtil.isHealthCheckMode() && !VerificationUtil.isBaselineCollectionMode() && VerificationUtil.isStringGood(this.m_dbName) ? elementName + ": " + this.m_dbName : elementName;
        }
        return "";
    }
}

