/*
 * Decompiled with CFR 0.152.
 */
package oracle.ops.verification.framework.engine.task;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.FactoryConfigurationError;
import javax.xml.parsers.ParserConfigurationException;
import oracle.ops.mgmt.nls.MessageBundle;
import oracle.ops.mgmt.trace.Trace;
import oracle.ops.verification.framework.VerificationConstants;
import oracle.ops.verification.framework.engine.task.CompSoftwareConfigLoaderException;
import oracle.ops.verification.framework.util.VerificationUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class CompsXMLParser
implements VerificationConstants {
    private static final String COMPS_FILE = "comps.xml";
    private static String COMPS_XML_LOCATION = FSEP + "inventory" + FSEP + "ContentsXML" + FSEP;
    private static String COMP_ELEMENT = "COMP";
    private static String COMP_NAME_ATTR = "NAME";
    private static MessageBundle s_gMsgBundle = VerificationUtil.getMessageBundle("Prvg");
    private String m_home;

    public CompsXMLParser(String home) {
        this.m_home = home;
    }

    public List<String> parse() throws CompSoftwareConfigLoaderException {
        ArrayList<String> components = new ArrayList<String>();
        String compsDataFileURI = null;
        File compsDataFile = null;
        try {
            Trace.out((String)("home[" + this.m_home + "]"));
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            factory.setValidating(true);
            DocumentBuilder parser = factory.newDocumentBuilder();
            DefaultHandler handler = new DefaultHandler();
            parser.setErrorHandler(handler);
            compsDataFileURI = this.m_home + COMPS_XML_LOCATION + COMPS_FILE;
            compsDataFile = new File(compsDataFileURI);
            if (!compsDataFile.exists()) {
                throw new CompSoftwareConfigLoaderException(s_gMsgBundle.getMessage("7500", false, (Object[])new String[]{COMPS_FILE}));
            }
            compsDataFileURI = compsDataFile.toURI().toString();
            Trace.out((String)(" comps file[" + compsDataFile + "]"));
            Document doc = parser.parse(compsDataFileURI);
            Element relm = doc.getDocumentElement();
            NodeList softwareComponents = relm.getElementsByTagName(COMP_ELEMENT);
            for (int i = 0; i < softwareComponents.getLength(); ++i) {
                Element comp = (Element)softwareComponents.item(i);
                components.add(comp.getAttribute(COMP_NAME_ATTR));
            }
            return components;
        }
        catch (SAXException e) {
            String errtxt = "'" + compsDataFile + " is not well-formed. ";
            e.printStackTrace();
            throw new CompSoftwareConfigLoaderException(errtxt + e.getMessage());
        }
        catch (IOException e) {
            throw new CompSoftwareConfigLoaderException(e.getMessage());
        }
        catch (FactoryConfigurationError e) {
            throw new CompSoftwareConfigLoaderException(e.getMessage());
        }
        catch (ParserConfigurationException e) {
            throw new CompSoftwareConfigLoaderException(e.getMessage());
        }
    }
}

