/*
 * Decompiled with CFR 0.152.
 */
package oracle.ops.verification.framework.engine.task;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.regex.Pattern;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.FactoryConfigurationError;
import javax.xml.parsers.ParserConfigurationException;
import oracle.cluster.verification.constraints.XmlParserException;
import oracle.cluster.verification.constraints.parser.NodeVisitorCB;
import oracle.cluster.verification.database.DatabaseEdition;
import oracle.ops.mgmt.trace.Trace;
import oracle.ops.verification.framework.engine.task.CompSoftwareConfigLoaderException;
import oracle.ops.verification.framework.util.CVUVariables;
import oracle.ops.verification.framework.util.FileInfo;
import oracle.ops.verification.framework.util.VerificationUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

class CompSoftwareConfigLoader {
    static final String CHAR_INDIRECTION = "$";
    static final String TAG_ROOTSOFTWARE_COMPONENTS = "SoftwareComponents";
    static final String DATABASE_COMPONENT = "database";
    static final String TAG_SOFTWARE_COMPONENT = "SoftwareComponent";
    static final String TAG_COMPONENT_NAME = "Name";
    static final String TAG_COMPONENT_HOME = "Home";
    static final String TAG_CONDITION = "CONDITION";
    static final String TAG_CONDITION_VAR = "VAR";
    static final String TAG_CONDITION_EQUALS = "EQ";
    static final String VALUE_CONDITION_VAR = "DB_EDITION";
    static final String VALUE_CONDITION_EQUALS = "EE";
    static final String TAG_FILE = "File";
    static final String TAG_FILE_NAME = "Name";
    static final String TAG_FILE_EXT = "Ext";
    static final String TAG_FILE_PATH = "Path";
    static final String TAG_FILE_ABS_PATH = "AbsolutePath";
    static final String TAG_FILE_OWNER = "Owner";
    static final String TAG_FILE_GROUP = "Group";
    static final String TAG_FILE_PERMISSIONS = "Permissions";
    private static final String TAG_COMPONENT = "Component";
    private static final String ATTRIBUTE_NAME = "name";
    private String m_conDataFile;
    private String m_comp;
    private DatabaseEdition m_databaseEdition;
    private List<String> m_componentsCompsXML;

    CompSoftwareConfigLoader(String filename, String softwareComponent, DatabaseEdition databaseEdition) {
        this(filename, softwareComponent, databaseEdition, null);
    }

    CompSoftwareConfigLoader(String filename, String softwareComponent, DatabaseEdition databaseEdition, List<String> componentsCompsXml) {
        this.m_conDataFile = filename;
        this.m_comp = softwareComponent;
        this.m_componentsCompsXML = componentsCompsXml;
        this.m_databaseEdition = databaseEdition;
        this.m_databaseEdition = DatabaseEdition.STANDARD_EDITION;
        this.m_componentsCompsXML = componentsCompsXml;
    }

    final HashMap load(boolean verifyAll) throws CompSoftwareConfigLoaderException {
        final boolean verifyAllFiles = verifyAll;
        try {
            Element relm;
            String rootElm;
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            factory.setValidating(true);
            DocumentBuilder parser = factory.newDocumentBuilder();
            DefaultHandler handler = new DefaultHandler();
            parser.setErrorHandler(handler);
            String conDataFile = this.m_conDataFile;
            if (!VerificationUtil.isAbsoluteURI(conDataFile)) {
                conDataFile = new File(conDataFile).toURI().toString();
            }
            Document doc = parser.parse(conDataFile);
            if (Trace.isTraceEnabled()) {
                Trace.out((String)("Parser validation set to: " + parser.isValidating()));
                Trace.out((String)(this.m_conDataFile + " is well-formed"));
            }
            if (!(rootElm = (relm = doc.getDocumentElement()).getTagName()).equalsIgnoreCase(TAG_ROOTSOFTWARE_COMPONENTS)) {
                if (Trace.isLevelEnabled((int)5)) {
                    Trace.out((String)"ERROR: Invalid root element");
                }
                throw new CompSoftwareConfigLoaderException("Invalid root element. Expected='SoftwareComponents' Found='" + rootElm + "'");
            }
            NodeList softwareComponents = relm.getElementsByTagName(TAG_SOFTWARE_COMPONENT);
            LinkedHashMap compFileListHash = new LinkedHashMap();
            for (int k = 0; k < softwareComponents.getLength(); ++k) {
                Element softwareComponent = (Element)softwareComponents.item(k);
                final ArrayList compFileList = new ArrayList();
                String compName = softwareComponent.getAttribute("Name");
                if (!compName.equals(this.m_comp)) continue;
                try {
                    this.parseFilesConditionally(new NodeVisitorCB(){

                        @Override
                        public void handle(Element elem, String conditionVar, String choiceVar, String selection) throws XmlParserException {
                            boolean matches = true;
                            if (elem.getNodeName().equals(CompSoftwareConfigLoader.TAG_FILE)) {
                                FileInfo fileInfo = CompSoftwareConfigLoader.this.readCompFile(elem);
                                if (!verifyAllFiles) {
                                    matches = CompSoftwareConfigLoader.this.isBinLibJlib(fileInfo.getFileName());
                                }
                                if (matches) {
                                    compFileList.add(fileInfo);
                                }
                            }
                        }
                    }, softwareComponent);
                }
                catch (XmlParserException xmlpe) {
                    throw new CompSoftwareConfigLoaderException(xmlpe.getMessage());
                }
                compFileListHash.put(compName, compFileList);
            }
            return compFileListHash;
        }
        catch (SAXException e) {
            String errtxt = "'" + this.m_conDataFile + " is not well-formed. ";
            throw new CompSoftwareConfigLoaderException(errtxt + e.getMessage());
        }
        catch (IOException e) {
            throw new CompSoftwareConfigLoaderException(e.getMessage());
        }
        catch (FactoryConfigurationError e) {
            throw new CompSoftwareConfigLoaderException(e.getMessage());
        }
        catch (ParserConfigurationException e) {
            throw new CompSoftwareConfigLoaderException(e.getMessage());
        }
    }

    private boolean isBinLibJlib(String fileName) {
        boolean matches = false;
        matches = Pattern.compile(".*bin" + File.separator + ".*", 2).matcher(fileName).matches() || Pattern.compile(".*lib" + File.separator + ".*", 2).matcher(fileName).matches() || Pattern.compile(".*jlib" + File.separator + ".*", 2).matcher(fileName).matches();
        return matches;
    }

    private void parseFilesConditionally(NodeVisitorCB nodeVisitor, Element xmlElem) throws XmlParserException {
        String componentName = null;
        NodeList childNodeList = xmlElem.getChildNodes();
        for (int i = 0; i < childNodeList.getLength(); ++i) {
            Node childNodeX = childNodeList.item(i);
            if (childNodeX.getNodeType() != 1) continue;
            Element childNode = (Element)childNodeList.item(i);
            if (childNode.getNodeName().equals(TAG_COMPONENT)) {
                componentName = childNode.getAttribute(ATTRIBUTE_NAME);
                if (this.m_componentsCompsXML != null) {
                    if (!this.m_componentsCompsXML.contains(componentName)) continue;
                    this.parseFilesConditionally(nodeVisitor, childNode);
                } else {
                    this.parseFilesConditionally(nodeVisitor, childNode);
                }
            }
            if (childNode.getNodeName().equals(TAG_FILE)) {
                nodeVisitor.handle(childNode, null, null, null);
                continue;
            }
            if (!childNode.getNodeName().equals(TAG_CONDITION) || !childNode.getAttribute(TAG_CONDITION_VAR).equals(VALUE_CONDITION_VAR) || !childNode.getAttribute(TAG_CONDITION_EQUALS).equals(VALUE_CONDITION_EQUALS) || this.m_databaseEdition != DatabaseEdition.ENTERPRISE_EDITION) continue;
            this.parseFilesConditionally(nodeVisitor, childNode);
        }
    }

    private FileInfo readCompFile(Element distributedFileElem) {
        String filePerms;
        String fileGroup;
        String fileCompRelativePath;
        FileInfo fileInfo = new FileInfo();
        String filePath = distributedFileElem.getAttribute(TAG_FILE_PATH);
        String fileName = distributedFileElem.getAttribute("Name");
        String fileExt = distributedFileElem.getAttribute(TAG_FILE_EXT);
        if (this.isVariable(fileExt)) {
            fileExt = this.resolveVariable(fileExt);
        }
        if (VerificationUtil.isStringGood(fileCompRelativePath = filePath) && !fileCompRelativePath.endsWith(Character.toString(File.separatorChar))) {
            fileCompRelativePath = fileCompRelativePath + Character.toString(File.separatorChar);
        }
        fileCompRelativePath = fileCompRelativePath + fileName;
        if (fileExt != null && fileExt.length() > 0) {
            fileCompRelativePath = fileCompRelativePath + fileExt;
        }
        fileInfo.setFileName(fileCompRelativePath);
        String fileOwner = this.getOptionalAttributeValue(distributedFileElem, TAG_FILE_OWNER);
        if (this.isVariable(fileOwner)) {
            fileOwner = this.resolveVariable(fileOwner);
        }
        if (fileOwner != null) {
            fileInfo.setFileOwner(fileOwner);
        }
        if (this.isVariable(fileGroup = this.getOptionalAttributeValue(distributedFileElem, TAG_FILE_GROUP))) {
            fileGroup = this.resolveVariable(fileGroup);
        }
        if (fileGroup != null) {
            fileInfo.setFileGroup(fileGroup);
        }
        if ((filePerms = this.getOptionalAttributeValue(distributedFileElem, TAG_FILE_PERMISSIONS)) != null && filePerms.length() > 0) {
            fileInfo.setFilePermissions(filePerms);
        }
        return fileInfo;
    }

    private boolean isVariable(String value) {
        return value != null && value.startsWith(CHAR_INDIRECTION);
    }

    private String resolveVariable(String variable) {
        return CVUVariables.getValue(variable.substring(CHAR_INDIRECTION.length()));
    }

    private String getOptionalAttributeValue(Element elem, String key) {
        String attributeValue = null;
        if (elem.hasAttribute(key)) {
            attributeValue = elem.getAttribute(key);
        }
        return attributeValue;
    }
}

