/*
 * Decompiled with CFR 0.152.
 */
package oracle.ops.verification.framework.engine.stage;

import java.util.List;
import oracle.cluster.verification.ParamPreReq;
import oracle.cluster.verification.ParamPreReqUSMConfig;
import oracle.cluster.verification.PreReqNotSupportedException;
import oracle.cluster.verification.util.VerificationType;
import oracle.ops.mgmt.trace.Trace;
import oracle.ops.verification.framework.engine.ErrorDescription;
import oracle.ops.verification.framework.engine.stage.Stage;
import oracle.ops.verification.framework.engine.stage.StageInitException;
import oracle.ops.verification.framework.engine.task.Task;
import oracle.ops.verification.framework.engine.task.TaskFactory;
import oracle.ops.verification.framework.engine.task.TaskFactoryException;
import oracle.ops.verification.framework.report.ReportUtil;
import oracle.ops.verification.framework.util.CVUVariableConstants;
import oracle.ops.verification.framework.util.CVUVariables;
import oracle.ops.verification.framework.util.NodelistNotFoundException;
import oracle.ops.verification.framework.util.VerificationUtil;

public class USMConfigStage
extends Stage {
    private String m_asmgrp;
    private String[] m_asmdev;

    @Override
    public void init() throws StageInitException {
        super.init();
        if (Trace.isTraceEnabled()) {
            Trace.out((String)"Inside USMConfigStage:init()...");
        }
        if (this.m_verificationMode == 1) {
            this.m_asmdev = this.m_paramMgr.getMultiPartArgVal(CVUVariables.getValue(CVUVariableConstants.ASM_DISKGROUP_DISKS));
            if (Trace.isTraceEnabled() && this.m_asmdev != null) {
                Trace.out((String)("==== ParamManager reports ASM device as : " + this.m_asmdev[0]));
            }
            this.m_asmgrp = CVUVariables.getValue(CVUVariableConstants.ASM_GROUP);
            if (Trace.isTraceEnabled()) {
                Trace.out((String)("==== ParamManager reports ASM group as : : " + this.m_asmgrp));
            }
        }
    }

    USMConfigStage(int verificationMode) throws StageInitException {
        super(verificationMode);
        this.init();
    }

    @Override
    protected boolean checkSetup() {
        try {
            if (this.m_nodeList.length == 1 && this.m_nodeList[0].equals(VerificationUtil.getLocalNodename()) && VerificationUtil.isHAConfigured() && !VerificationUtil.isCRSConfigured()) {
                this.setExcludeUserEquiv(true);
            }
        }
        catch (NodelistNotFoundException e) {
            Trace.out((String)("Node List not found:" + e));
            String msg = e.getMessage() + LSEP + s_msgBundle.getMessage("0007", false) + LSEP;
            ReportUtil.printError(msg);
            this.m_resultSet.addResult(this.m_nodeList, 2);
            this.m_resultSet.addErrorDescription(new ErrorDescription(msg));
            return false;
        }
        super.checkSetup();
        Trace.out((String)("m_validNodeList=" + VerificationUtil.strArr2List(this.m_validNodeList)));
        if (this.m_validNodeList == null || this.m_validNodeList.length == 0) {
            return false;
        }
        return this.checkCRSConfiguration(this.m_validNodeList);
    }

    @Override
    protected void setTaskList() throws TaskFactoryException, PreReqNotSupportedException {
        if (!VerificationUtil.isACFSSupported(true)) {
            ReportUtil.sureprintln(s_msgBundle.getMessage("0007", false));
            this.m_resultSet.addResult(this.m_nodeList, 2);
            return;
        }
        if (this.m_verificationMode == 1) {
            ParamPreReqUSMConfig param = new ParamPreReqUSMConfig();
            param.setASMDeviceArr(this.m_asmdev);
            param.setAsmGrp(this.m_asmgrp);
            List<Task> usmCfgStageTaskList = TaskFactory.getInstance().getTaskList(VerificationType.PREREQ_USM_CONFIG, this.getValidNodeList(), (ParamPreReq)param, this);
            this.addToCurrentTaskSet(usmCfgStageTaskList.toArray(new Task[0]));
        } else {
            String[] crsNodes = VerificationUtil.getNodesWithCRSInstall(this.getValidNodeList(), this.m_resultSet);
            if (null == crsNodes) {
                return;
            }
            List<Task> usmCfgStageTaskList = TaskFactory.getInstance().getTaskList(VerificationType.POSTREQ_USM_CONFIG, crsNodes, null, this);
            this.addToCurrentTaskSet(usmCfgStageTaskList.toArray(new Task[0]));
        }
    }

    @Override
    public void generateReport() {
    }
}

