/*
 * Decompiled with CFR 0.152.
 */
package oracle.ops.verification.framework.engine.stage;

import java.util.List;
import oracle.cluster.verification.ParamPreReq;
import oracle.cluster.verification.ParamPreReqHWOSSetup;
import oracle.cluster.verification.PreReqNotSupportedException;
import oracle.cluster.verification.util.VerificationType;
import oracle.ops.mgmt.trace.Trace;
import oracle.ops.verification.framework.VerificationConstants;
import oracle.ops.verification.framework.engine.stage.Stage;
import oracle.ops.verification.framework.engine.stage.StageInitException;
import oracle.ops.verification.framework.engine.task.Task;
import oracle.ops.verification.framework.engine.task.TaskFactory;
import oracle.ops.verification.framework.engine.task.TaskFactoryException;
import oracle.ops.verification.framework.util.CVUVariableConstants;
import oracle.ops.verification.framework.util.CVUVariables;
import oracle.ops.verification.framework.util.VerificationUtil;

public class HWOSSetupStage
extends Stage
implements VerificationConstants {
    private String[] m_storageIDlist;

    @Override
    public void init() throws StageInitException {
        super.init();
        Trace.out((String)"Inside HWOSSetupStage:init()...");
        if (this.m_verificationMode != 1) {
            this.m_storageIDlist = this.m_paramMgr.getMultiPartArgVal(CVUVariables.getValue(CVUVariableConstants.STORAGE_ID_LIST));
        }
    }

    HWOSSetupStage(int verificationMode) throws StageInitException {
        super(verificationMode);
        this.init();
    }

    @Override
    protected void setTaskList() throws TaskFactoryException, PreReqNotSupportedException {
        if (this.m_verificationMode != 1) {
            ParamPreReqHWOSSetup param = new ParamPreReqHWOSSetup();
            List<Task> hwosSetupStageTaskList = null;
            param.setStorageIDlist(this.m_storageIDlist);
            String[] nodeList = this.getValidNodeList();
            nodeList = VerificationUtil.addLocalNodeToNodeList(nodeList);
            hwosSetupStageTaskList = TaskFactory.getInstance().getTaskList(VerificationType.POSTREQ_HWOS_SETUP, nodeList, (ParamPreReq)param, this);
            this.addToCurrentTaskSet(hwosSetupStageTaskList.toArray(new Task[0]));
        }
    }

    @Override
    public void generateReport() {
    }
}

