/*
 * Decompiled with CFR 0.152.
 */
package oracle.ops.verification.framework.engine.stage;

import java.util.List;
import oracle.cluster.verification.ParamPreReq;
import oracle.cluster.verification.ParamPreReqDBConfig;
import oracle.cluster.verification.PreReqNotSupportedException;
import oracle.cluster.verification.util.VerificationType;
import oracle.ops.mgmt.cluster.ClusterCmd;
import oracle.ops.mgmt.cluster.ClusterException;
import oracle.ops.mgmt.nativesystem.NativeSystem;
import oracle.ops.mgmt.nativesystem.SystemFactory;
import oracle.ops.mgmt.trace.Trace;
import oracle.ops.verification.framework.engine.stage.Stage;
import oracle.ops.verification.framework.engine.stage.StageInitException;
import oracle.ops.verification.framework.engine.task.Task;
import oracle.ops.verification.framework.engine.task.TaskFactory;
import oracle.ops.verification.framework.engine.task.TaskFactoryException;
import oracle.ops.verification.framework.util.CVUVariableConstants;
import oracle.ops.verification.framework.util.CVUVariables;
import oracle.ops.verification.framework.util.NodelistNotFoundException;
import oracle.ops.verification.framework.util.VerificationLogData;
import oracle.ops.verification.framework.util.VerificationUtil;

public class DBConfigStage
extends Stage {
    private String m_oracleHome;
    private ParamPreReqDBConfig m_param;

    @Override
    public void init() throws StageInitException {
        super.init();
        Trace.out((String)"Inside DBConfigStage:init()...");
        if (this.m_verificationMode == 1) {
            this.m_oracleHome = CVUVariables.getValue(CVUVariableConstants.ORACLE_HOME);
            Trace.out((String)("==== ParamManager reports Oracle Home as: " + this.m_oracleHome));
            boolean ohomeExists = false;
            try {
                ohomeExists = new ClusterCmd().dirExists(VerificationUtil.getLocalNode(), this.m_oracleHome);
            }
            catch (ClusterException e) {
                Trace.out((String)("Could not check existence of  oracle home " + e.getMessage()));
                VerificationLogData.addGlobalErrorOnce("Prvf", "0006", true, new String[]{this.m_oracleHome}, null, new String[]{VerificationUtil.getLocalNode()});
            }
            if (!ohomeExists) {
                VerificationLogData.addGlobalErrorOnce("Prvf", "4900", false, new String[]{this.m_oracleHome}, null, new String[]{VerificationUtil.getLocalNode()});
            }
            this.m_param = new ParamPreReqDBConfig(this.m_oracleHome);
            String oraInvGroup = null;
            oraInvGroup = VerificationUtil.getOraInventoryGroup();
            NativeSystem nativeSystem = new SystemFactory().CreateSystem();
            if (oraInvGroup == null && nativeSystem.isUnixSystem()) {
                String errorMsg = s_msgBundle.getMessage("0049", false);
                VerificationLogData.addGlobalErrorOnce("Prvf", "0049", false, null, null, new String[]{VerificationUtil.getLocalNode()});
            }
            this.m_param.setOraInv(oraInvGroup);
            this.m_param.setCRSHome(VerificationUtil.getCRSHome());
            this.m_param.setHAHome(VerificationUtil.getHAHome());
            if (Trace.isLevelEnabled((int)1)) {
                Trace.out((String)"OracleHome=%s, OraInv=%s", (Object[])new Object[]{this.m_oracleHome, oraInvGroup});
            }
        }
    }

    DBConfigStage(int verificationMode) throws StageInitException {
        super(verificationMode);
        this.init();
    }

    @Override
    protected boolean checkSetup() {
        Trace.out((String)"Enter DBConfigStage.checkSetup() ");
        try {
            if (this.m_nodeList.length == 1 && this.m_nodeList[0].equals(VerificationUtil.getLocalNodename()) && VerificationUtil.isHAConfigured() && !VerificationUtil.isCRSConfigured()) {
                this.setExcludeUserEquiv(true);
            }
        }
        catch (NodelistNotFoundException e) {
            Trace.out((String)("Node List not found:" + e));
            String msg = e.getMessage() + LSEP + s_msgBundle.getMessage("0007", false) + LSEP;
            VerificationLogData.addGlobalErrorOnce("Prvf", "0007", false, null, null, new String[]{VerificationUtil.getLocalNode()});
            return false;
        }
        return super.checkSetup();
    }

    @Override
    protected void setTaskList() throws TaskFactoryException, PreReqNotSupportedException {
        if (this.m_verificationMode == 1) {
            List<Task> dbInstStageTaskList = null;
            dbInstStageTaskList = TaskFactory.getInstance().getTaskList(VerificationType.PREREQ_DB_CONFIG, this.getValidNodeList(), (ParamPreReq)this.m_param, this);
            this.addToCurrentTaskSet(dbInstStageTaskList.toArray(new Task[0]));
        }
    }

    @Override
    public void generateReport() {
    }
}

