/*
 * Decompiled with CFR 0.152.
 */
package oracle.ops.verification.framework.engine.stage;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import oracle.cluster.deployment.ClusterwareInfo;
import oracle.cluster.install.InstallException;
import oracle.cluster.verification.InvalidPathException;
import oracle.cluster.verification.ParamPreReq;
import oracle.cluster.verification.ParamPreReqCRSInst;
import oracle.cluster.verification.PreReqNotSupportedException;
import oracle.cluster.verification.SeverityType;
import oracle.cluster.verification.VerificationAPIConstants;
import oracle.cluster.verification.util.VerificationType;
import oracle.ops.mgmt.cluster.Version;
import oracle.ops.mgmt.database.ConfigurationException;
import oracle.ops.mgmt.trace.Trace;
import oracle.ops.verification.framework.VerificationConstants;
import oracle.ops.verification.framework.engine.Result;
import oracle.ops.verification.framework.engine.component.BaselineComponent;
import oracle.ops.verification.framework.engine.component.ComponentInitException;
import oracle.ops.verification.framework.engine.factory.context.GlobalVerificationContext;
import oracle.ops.verification.framework.engine.stage.Stage;
import oracle.ops.verification.framework.engine.stage.StageInitException;
import oracle.ops.verification.framework.engine.task.Task;
import oracle.ops.verification.framework.engine.task.TaskFactory;
import oracle.ops.verification.framework.engine.task.TaskFactoryException;
import oracle.ops.verification.framework.engine.task.TaskOraclePatch;
import oracle.ops.verification.framework.report.ReportUtil;
import oracle.ops.verification.framework.util.Assert;
import oracle.ops.verification.framework.util.CVUVariableConstants;
import oracle.ops.verification.framework.util.CVUVariables;
import oracle.ops.verification.framework.util.NodelistNotFoundException;
import oracle.ops.verification.framework.util.VerificationLogData;
import oracle.ops.verification.framework.util.VerificationUtil;

public class ClusterSvcSetupStage
extends Stage {
    private String[] m_OCRlocation;
    private String[] m_VdiskLocation;
    private String m_existingCRSHomeLocation;
    private Version m_existingCRSHomeVersion;
    private List<String> m_nodesWithCRSRunning = new ArrayList<String>();
    private boolean m_isRollingUpgrade = false;
    private String m_osdba;
    private String m_oraInv;
    private String m_asmoper;
    private String m_asmgrp;
    private ParamPreReqCRSInst m_param;
    GlobalVerificationContext m_globalVerificationCtx;
    private String[] m_asmDev;
    private boolean m_ASMCheck;
    private boolean m_localNodeCRSRunning = false;
    private String m_release;

    @Override
    public void init() throws StageInitException {
        super.init();
        Result result = null;
        Trace.out((String)"Inside ClusterSvcSetupStage:init()...");
        this.m_globalVerificationCtx = GlobalVerificationContext.getInstance();
        if (this.m_verificationMode == 1) {
            String destVersion;
            this.m_OCRlocation = this.m_paramMgr.getMultiPartArgVal(CVUVariables.getValue(CVUVariableConstants.OCR_LOCATIONS));
            Trace.out((String)("==== ParamManager reports OCR storage locations as " + VerificationUtil.strArr2List(this.m_OCRlocation)));
            this.m_VdiskLocation = this.m_paramMgr.getMultiPartArgVal(CVUVariables.getValue(CVUVariableConstants.VOTING_LOCATIONS));
            Trace.out((String)("==== ParamManager reports Voting Disk locations as " + VerificationUtil.strArr2List(this.m_VdiskLocation)));
            if (this.m_paramMgr.checkArgUpgrade()) {
                String srcCRSHome = CVUVariables.getValue(CVUVariableConstants.oracle_install_crs_configuredCRSHome);
                String crsHomeVar = CVUVariableConstants.CONFIGURED_CRS_HOME.toString();
                CVUVariables.setForceLookUpForVariable(crsHomeVar, true);
                this.m_existingCRSHomeLocation = VerificationUtil.getCRSHome();
                CVUVariables.setForceLookUpForVariable(crsHomeVar, false);
                if (VerificationUtil.isStringGood(srcCRSHome) && VerificationUtil.isStringGood(this.m_existingCRSHomeLocation)) {
                    try {
                        String srcCRSHomePath = new File(srcCRSHome).getCanonicalPath();
                        String existingCRSHomePath = new File(this.m_existingCRSHomeLocation).getCanonicalPath();
                        if (!VerificationUtil.isPlatformWindows() && !srcCRSHomePath.equals(existingCRSHomePath) || VerificationUtil.isPlatformWindows() && !srcCRSHomePath.equalsIgnoreCase(existingCRSHomePath)) {
                            throw new StageInitException(s_gMsgBundle.getMessage("8000", true, (Object[])new String[]{srcCRSHome}));
                        }
                    }
                    catch (IOException ioe) {
                        Trace.out((String)("IOException " + ioe.getMessage()));
                        throw new StageInitException(ioe.getMessage());
                    }
                }
            } else {
                this.m_existingCRSHomeLocation = CVUVariables.getValue(CVUVariableConstants.CRS_HOME);
                if (!VerificationUtil.isStringGood(this.m_existingCRSHomeLocation)) {
                    this.m_existingCRSHomeLocation = VerificationUtil.getCRSHome();
                    CVUVariables.setValue(CVUVariableConstants.CRS_HOME, this.m_existingCRSHomeLocation);
                }
            }
            Trace.out((String)("==== ParamManager reports CRS Home location as: " + this.m_existingCRSHomeLocation));
            this.m_osdba = CVUVariables.getValue(CVUVariableConstants.DBA_GROUP);
            Trace.out((String)("==== ParamManager reports OSDBA as: " + this.m_osdba));
            this.m_asmoper = CVUVariables.getValue(CVUVariableConstants.ASM_OPER_GROUP);
            Trace.out((String)("==== ParamManager reports ASMOPER group as: " + this.m_asmoper));
            this.m_asmgrp = CVUVariables.getValue(CVUVariableConstants.ASM_GROUP);
            Trace.out((String)("==== ParamManager reports ASMADMIN group as: " + this.m_asmgrp));
            this.m_oraInv = CVUVariables.getValue(CVUVariableConstants.INSTALL_GROUP);
            Trace.out((String)("==== ParamManager reports ORAINV as: " + this.m_oraInv));
            this.m_asmDev = this.m_paramMgr.getMultiPartArgVal(CVUVariables.getValue(CVUVariableConstants.ASM_DISKGROUP_DISKS));
            Trace.out((String)("==== ParamManager reports ASM_DEVICES as: " + this.m_asmDev));
            this.m_ASMCheck = this.m_paramMgr.checkASM();
            Trace.out((String)("==== ParamManager reports Check-ASM as " + this.m_ASMCheck));
            this.m_isRollingUpgrade = this.m_paramMgr.checkArgRolling();
            if (this.m_paramMgr.checkArgUpgrade()) {
                Trace.out((String)"setting install option to upgrade");
                CVUVariables.setValue(CVUVariableConstants.INSTALL_OPTION, VerificationAPIConstants.VAR_VAL_UPGRADE);
                this.initUpgradeData();
                String dest_ver = CVUVariables.getValue(CVUVariableConstants.DEST_VERSION);
                String destHome = CVUVariables.getValue(CVUVariableConstants.CRS_HOME);
                if (VerificationUtil.isStringGood(destHome) && VerificationUtil.isStringGood(this.m_existingCRSHomeLocation) && new File(new File(destHome).getAbsolutePath()).compareTo(new File(new File(this.m_existingCRSHomeLocation).getAbsolutePath())) == 0) {
                    Trace.out((String)("dest_crshome[" + destHome + "] and " + "existing_crshome[" + this.m_existingCRSHomeLocation + "] are same"));
                    throw new StageInitException(s_gMsgBundle.getMessage("11903", true, (Object[])new String[]{destHome, this.m_existingCRSHomeLocation}));
                }
                destVersion = new Version();
                if (VerificationUtil.isStringGood(dest_ver)) {
                    try {
                        destVersion = Version.getVersion((String)dest_ver);
                    }
                    catch (ConfigurationException e) {
                        throw new StageInitException(e.getMessage());
                    }
                }
                this.checkSetUpForUpgrade((Version)destVersion);
            }
            this.m_param = new ParamPreReqCRSInst();
            if (this.m_paramMgr.checkArgUpgrade()) {
                String[] versionTokens;
                String currVersion = null;
                String crsHomeV = CVUVariables.getValue(CVUVariableConstants.oracle_install_crs_configuredCRSHome);
                destVersion = CVUVariables.getValue(CVUVariableConstants.DEST_VERSION);
                if (destVersion != null) {
                    for (String strHost : this.m_nodeList) {
                        currVersion = VerificationUtil.getCRSActiveVersion(true);
                        if (VerificationUtil.compareVersions(destVersion, currVersion, ".") >= 0) continue;
                        throw new StageInitException(s_gMsgBundle.getMessage("0601", true, (Object[])new String[]{currVersion}));
                    }
                }
                this.m_oraInv = VerificationUtil.getOraInventoryGroup();
                this.m_release = "12.2";
                if (destVersion != null && (versionTokens = destVersion.split("\\.")).length > 1) {
                    this.m_release = versionTokens[0] + "." + versionTokens[1];
                }
                if (this.m_oraInv == null) {
                    result = new Result(VerificationUtil.getLocalNode());
                    this.m_oraInv = VerificationUtil.getDefaultOraInvGroup(result);
                    if (this.m_oraInv == null) {
                        Trace.out((int)5, (String)"ClusterSvcSetupStage: %s", (Object[])new Object[]{result.traceResultInfo()});
                        ReportUtil.processAlert(VerificationUtil.LSEP + ReportUtil.ERROR + VerificationUtil.LSEP + s_gMsgBundle.getMessage("10467", true));
                    }
                }
            } else {
                if (this.m_oraInv == null) {
                    result = new Result(VerificationUtil.getLocalNode());
                    this.m_oraInv = VerificationUtil.getDefaultOraInvGroup(result);
                    if (this.m_oraInv == null) {
                        Trace.out((int)5, (String)"ClusterSvcSetupStage: %s", (Object[])new Object[]{result.traceResultInfo()});
                        ReportUtil.processAlert(VerificationUtil.LSEP + ReportUtil.ERROR + VerificationUtil.LSEP + s_gMsgBundle.getMessage("10467", true));
                    }
                }
                this.m_release = VerificationUtil.getRequestedRelease();
                if ("10gR1".equalsIgnoreCase(this.m_release)) {
                    this.m_release = "10.1";
                } else if ("10gR2".equalsIgnoreCase(this.m_release)) {
                    this.m_release = "10.2";
                } else if ("11gR1".equalsIgnoreCase(this.m_release)) {
                    this.m_release = "11.1";
                } else if ("11gR2".equalsIgnoreCase(this.m_release)) {
                    this.m_release = "11.2";
                }
                if (this.m_asmDev == null && this.m_ASMCheck) {
                    String version = this.m_release;
                    if (version == null) {
                        version = "12.2.0.1.0";
                    }
                    this.m_asmDev = VerificationUtil.getDefaultDiscoveryDevice(version);
                }
            }
            this.m_param.setORAINVgroup(this.m_oraInv);
            if (this.m_OCRlocation != null) {
                CVUVariables.setValue(CVUVariableConstants.OCR_LOCATIONS, VerificationUtil.strArr2List(this.m_OCRlocation));
            }
            if (this.m_VdiskLocation != null) {
                CVUVariables.setValue(CVUVariableConstants.VOTING_LOCATIONS, VerificationUtil.strArr2List(this.m_VdiskLocation));
            }
            this.m_param.setASMDevice(this.m_asmDev);
            if (this.m_ASMCheck) {
                this.m_param.setASMCheck(this.m_ASMCheck);
            }
            this.m_param.setRelease(this.m_release);
            if (Boolean.parseBoolean(CVUVariables.getValue(CVUVariableConstants.SW_ONLY_FLAG))) {
                CVUVariables.setValue(CVUVariableConstants.INSTALL_OPTION, VerificationAPIConstants.VAR_VAL_CRS_SOFT_ONLY);
            }
        }
    }

    ClusterSvcSetupStage(int verificationMode) throws StageInitException {
        super(verificationMode);
        this.init();
    }

    private void initUpgradeData() throws StageInitException {
        Trace.out((String)"Initializing the update related data");
        if (!VerificationUtil.isStringGood(this.m_existingCRSHomeLocation)) {
            this.m_existingCRSHomeLocation = CVUVariables.getValue(CVUVariableConstants.oracle_install_crs_configuredCRSHome);
        }
        if (VerificationUtil.isStringGood(this.m_existingCRSHomeLocation)) {
            try {
                Assert.assertPath(this.m_existingCRSHomeLocation);
            }
            catch (InvalidPathException e) {
                Trace.out((String)("Caught InvalidPathException : Invalid CRS home path for " + this.m_existingCRSHomeLocation));
                throw new StageInitException(e.getMessage());
            }
        } else {
            String localNode = VerificationUtil.getLocalNode();
            Result crsHomeResult = new Result(localNode);
            this.m_existingCRSHomeLocation = VerificationUtil.getCRSHome(localNode, crsHomeResult);
            if (!VerificationUtil.isStringGood(this.m_existingCRSHomeLocation)) {
                Trace.out((String)"Failed to retrieved the existing source CRS home location");
                String errMsg = s_msgBundle.getMessage("5301", true);
                throw new StageInitException(errMsg);
            }
            CVUVariables.setValue(CVUVariableConstants.oracle_install_crs_configuredCRSHome, this.m_existingCRSHomeLocation);
        }
        Trace.out((String)("Source CRS home for upgrade is " + this.m_existingCRSHomeLocation));
        ClusterwareInfo clustInfo = new ClusterwareInfo();
        try {
            this.m_existingCRSHomeVersion = VerificationUtil.getCRSActiveVersionObj();
            this.m_localNodeCRSRunning = clustInfo.isCRSRunning(this.m_existingCRSHomeLocation, this.m_existingCRSHomeVersion);
            Trace.out((int)5, (String)"local node CRS running=%b", (Object[])new Object[]{this.m_localNodeCRSRunning});
        }
        catch (InstallException e) {
            Trace.out((int)5, (String)"IGNORED: %s: %s", (Object[])new Object[]{((Object)((Object)e)).getClass(), e.getMessage()});
        }
        for (String node : this.m_nodeList) {
            Result nodeResult = new Result(node);
            String nodeCRSHome = VerificationUtil.getCRSHome(node, nodeResult);
            try {
                if (!clustInfo.isCRSRunning(nodeCRSHome, node, this.m_existingCRSHomeVersion)) continue;
                this.m_nodesWithCRSRunning.add(node);
            }
            catch (InstallException ie) {
                Trace.out((String)("Caught InstallException : for node " + node + ", Ignoring " + ie.getMessage()));
            }
        }
    }

    private void checkSetUpForUpgrade(Version destVersion) throws StageInitException {
        if (Version.isPre12c((Version)destVersion)) {
            if (this.m_isRollingUpgrade && !this.m_localNodeCRSRunning) {
                throw new StageInitException(s_gMsgBundle.getMessage("0710", true));
            }
            if (this.m_localNodeCRSRunning) {
                CVUVariables.setValue(CVUVariableConstants.ISROLLING, "TRUE");
                this.m_isRollingUpgrade = true;
            } else {
                if (this.m_nodesWithCRSRunning.size() > 0) {
                    throw new StageInitException(s_gMsgBundle.getMessage("0713", true, (Object[])new String[]{VerificationUtil.strCollection2String(this.m_nodesWithCRSRunning)}));
                }
                ReportUtil.printWarning(s_gMsgBundle.getMessage("0714", true) + LSEP);
            }
        } else {
            if (!this.m_localNodeCRSRunning) {
                throw new StageInitException(s_gMsgBundle.getMessage("0712", true));
            }
            if (this.m_nodesWithCRSRunning.size() > 1) {
                CVUVariables.setValue(CVUVariableConstants.ISROLLING, "TRUE");
                this.m_isRollingUpgrade = true;
            }
            this.discoverNodeListForRollingUpgrade();
        }
        Trace.out((String)("The upgrade is requested with following data \n Source CRS home " + this.m_existingCRSHomeLocation + "\n The Active version is " + (null != this.m_existingCRSHomeVersion ? this.m_existingCRSHomeVersion.toString() : null) + "\n The destination version for upgrade is " + (null != destVersion ? destVersion.toString() : null) + "\n The local node CRS running status is " + this.m_localNodeCRSRunning + "\n The rolling upgrade flag is set to " + this.m_isRollingUpgrade + "\n The nodes with CRS currently up is (" + this.m_nodesWithCRSRunning.size() + ") : " + VerificationUtil.strList2List(this.m_nodesWithCRSRunning) + "\n The checks will be performed on (" + VerificationUtil.strArr2List(this.m_nodeList)));
        VerificationLogData.log("The upgrade is requested with following data \n Source CRS home " + this.m_existingCRSHomeLocation + "\n The Active version is " + (null != this.m_existingCRSHomeVersion ? this.m_existingCRSHomeVersion.toString() : null) + "\n The destination version for upgrade is " + (null != destVersion ? destVersion.toString() : null) + "\n The local node CRS running status is " + this.m_localNodeCRSRunning + "\n The rolling upgrade flag is set to " + this.m_isRollingUpgrade + "\n The nodes with CRS currently up is (" + this.m_nodesWithCRSRunning.size() + ") : " + VerificationUtil.strList2List(this.m_nodesWithCRSRunning) + "\n The checks will be performed on (" + VerificationUtil.strArr2List(this.m_nodeList) + ")");
    }

    private void discoverNodeListForRollingUpgrade() throws StageInitException {
        try {
            this.m_nodeList = VerificationUtil.getStaticNodelist();
            VerificationUtil.setLocalNodeOperation(false);
        }
        catch (NodelistNotFoundException e) {
            this.m_resultSet.addResult(this.m_nodeList, 2);
            ReportUtil.sureprintln(VerificationConstants.LSEP + ReportUtil.ERROR);
            String msg = e.getMessage() + ". " + s_gMsgBundle.getMessage("0711", false);
            throw new StageInitException(msg);
        }
    }

    @Override
    protected boolean checkSetup() {
        super.checkSetup();
        String[] validNodesPreCRSchk = this.getValidNodeList();
        if (validNodesPreCRSchk == null || validNodesPreCRSchk.length == 0) {
            return false;
        }
        if (this.m_verificationMode == 1) {
            Trace.out((String)"==== Skipping CRS home check. n/a for pre check");
            return validNodesPreCRSchk.length == this.getNodeList().length;
        }
        String[] nodesWithCRSinstall = VerificationUtil.getNodesWithCRSInstall(validNodesPreCRSchk, this.m_resultSet);
        this.setValidNodeList(nodesWithCRSinstall);
        if (nodesWithCRSinstall == null) {
            return false;
        }
        return nodesWithCRSinstall.length == this.getNodeList().length;
    }

    @Override
    protected void setTaskList() throws TaskFactoryException, PreReqNotSupportedException {
        if (this.m_verificationMode == 1) {
            List<Task> crsInstStageTaskList = null;
            crsInstStageTaskList = TaskFactory.getInstance().getTaskList(VerificationType.PREREQ_CRS_INST, this.getValidNodeList(), (ParamPreReq)this.m_param, this);
            if (!this.m_paramMgr.checkArgPatchonly()) {
                this.addToCurrentTaskSet(crsInstStageTaskList.toArray(new Task[0]));
            } else {
                String destinationHome = CVUVariables.getValue(CVUVariableConstants.CRS_HOME);
                ArrayList<Task> patchOnlyTasks = new ArrayList<Task>();
                for (Task task : crsInstStageTaskList) {
                    if (!(task instanceof TaskOraclePatch) || !destinationHome.equals(((TaskOraclePatch)task).getHome()) || !SeverityType.CRITICAL.equals((Object)task.getSeverity()) && !SeverityType.FATAL.equals((Object)task.getSeverity())) continue;
                    patchOnlyTasks.add(task);
                }
                this.addToCurrentTaskSet(patchOnlyTasks.toArray(new Task[0]));
            }
        } else {
            boolean isOTN = VerificationUtil.isOTN();
            String crsActiveVersion = VerificationUtil.getCRSActiveVersion();
            String clusterType = VerificationUtil.getClusterType();
            if ((!isOTN || isOTN && VerificationUtil.isVersionPost(crsActiveVersion, "12.2")) && !clusterType.equalsIgnoreCase("flex")) {
                throw new TaskFactoryException(s_gMsgBundle.getMessage("13204", true, (Object[])new String[]{clusterType}));
            }
            List<Task> crsInstStageTaskList = null;
            crsInstStageTaskList = TaskFactory.getInstance().getTaskList(VerificationType.POSTREQ_CRS_INST, this.getValidNodeList(), null, this);
            this.addToCurrentTaskSet(crsInstStageTaskList.toArray(new Task[0]));
        }
    }

    @Override
    public void generateReport() {
    }

    @Override
    protected void postVerify() {
        String collect = CVUVariables.getValue(CVUVariableConstants.BASELINE_COLLECT);
        if (!VerificationUtil.isStringGood(collect)) {
            return;
        }
        BaselineComponent comp = null;
        try {
            comp = new BaselineComponent(VerificationType.COMPONENT_BASELINE, this.getValidNodeList(), true);
            comp.verify();
        }
        catch (ComponentInitException e) {
            Trace.out((int)5, (String)"IGNORED Exception %s : %s", (Object[])new Object[]{((Object)((Object)e)).getClass(), e.getMessage()});
        }
    }
}

