/*
 * Decompiled with CFR 0.152.
 */
package oracle.ops.verification.framework.engine.factory.data;

import java.util.regex.Pattern;
import oracle.cluster.verification.ResultValuesUnavailableException;
import oracle.cluster.verification.pluggable.ReferenceInfo;
import oracle.ops.mgmt.trace.Trace;
import oracle.ops.verification.framework.engine.Result;
import oracle.ops.verification.framework.engine.ResultSet;
import oracle.ops.verification.framework.engine.factory.data.DataComparator;
import oracle.ops.verification.framework.engine.factory.data.DataComparatorType;
import oracle.ops.verification.framework.engine.factory.data.ExecutableInfo;
import oracle.ops.verification.framework.engine.factory.data.ResultAnalyzerException;
import oracle.ops.verification.framework.util.InvalidRangeManipulationException;
import oracle.ops.verification.framework.util.RangeOfValue;
import oracle.ops.verification.framework.util.RangeOperator;
import oracle.ops.verification.framework.util.RangeType;

public class StdDataComparator
extends DataComparator {
    private ReferenceInfo m_referenceInfo = null;
    private ExecutableInfo m_comparatorExecutable = null;

    public StdDataComparator(ReferenceInfo referenceInfo) {
        this.m_referenceInfo = referenceInfo;
    }

    private RangeOperator getDataComparatorType() {
        switch (this.m_referenceInfo.getDataComparatorType()) {
            case EQ: {
                return RangeOperator.EQ;
            }
            case GE: {
                return RangeOperator.GE;
            }
            case LE: {
                return RangeOperator.LE;
            }
            case GT: {
                return RangeOperator.GT;
            }
            case LT: {
                return RangeOperator.LT;
            }
            case NE: {
                return RangeOperator.NE;
            }
            case RE: {
                return RangeOperator.RE;
            }
        }
        return null;
    }

    public ExecutableInfo getExecutableInfo() {
        return this.m_comparatorExecutable;
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public ResultSet analyzeResult(ResultSet vfnResult) throws ResultAnalyzerException {
        rsltSet = new ResultSet();
        ht = vfnResult.getResultTable();
        e = ht.keys();
        while (e.hasMoreElements()) {
            block26: {
                node = (String)e.nextElement();
                result = (Result)ht.get(node);
                tempRes = new Result(node);
                success = false;
                if (result.getStatus() != 1) break block26;
                expectedRange = null;
                expected = null;
                if (this.m_referenceInfo.getDataComparatorType() == DataComparatorType.RANGE) {
                    expectedRange = (RangeOfValue)this.m_referenceInfo.getRefDataVal();
                } else {
                    expected = ((String)this.m_referenceInfo.getRefDataVal()).trim();
                }
                try {
                    collected = result.getActualValue().trim();
                }
                catch (ResultValuesUnavailableException rvue) {
                    rsltSet.addResult(node, 2);
                    Trace.out((String)StdDataComparator.s_msgBundle.getMessage("0011", false));
                    continue;
                }
                Trace.out((String)("expected=" + expected));
                Trace.out((String)("expectedRange=" + expectedRange));
                Trace.out((String)("collected=" + collected));
                Trace.out((String)("Datatype =" + (Object)this.m_referenceInfo.getDataType()));
                tempRes.setStatus(1);
                tempRes.setActualValue(collected);
                if (expected != null) {
                    tempRes.setExpectedValue(expected);
                } else {
                    tempRes.setExpectedValue(expectedRange.toString());
                }
                tempRes.setHasResultValues(true);
                obj = collected;
                rov = null;
                switch (1.$SwitchMap$oracle$ops$verification$framework$engine$factory$data$DataType[this.m_referenceInfo.getDataType().ordinal()]) {
                    case 1: {
                        Trace.out((String)"Handling String datatype");
                        if (this.m_referenceInfo.getDataComparatorType() == DataComparatorType.EQ_NO_CASE) {
                            obj = obj.toLowerCase();
                            expected = expected.toLowerCase();
                            this.m_referenceInfo.setDataComparatorType(DataComparatorType.EQ);
                        }
                        try {
                            ro = this.getDataComparatorType();
                            rov = new RangeOfValue(RangeType.STRING);
                            if (ro == null) {
                                Trace.out((String)"The given operator is not supported.");
                                tempRes.setStatus(2);
                                tempRes.addErrorInfo(StdDataComparator.s_msgBundle.getMessage("0004", false));
                                rsltSet.addResult(node, tempRes);
                                break;
                            }
                            rov.include(ro, expected);
                            if (!rov.contains(obj)) {
                                tempRes.setStatus(3);
                                tempRes.addErrorInfo(StdDataComparator.s_msgBundle.getMessage("0017", false, (Object[])new String[]{rov.toString(), obj.toString()}));
                            }
                        }
                        catch (InvalidRangeManipulationException irme) {
                            rsltSet.addResult(node, 2);
                            break;
                        }
                        rsltSet.addResult(node, tempRes);
                        break;
                    }
                    case 2: {
                        if (expectedRange == null) ** GOTO lbl76
                        try {
                            if (!expectedRange.contains(obj)) {
                                tempRes.setStatus(3);
                                tempRes.addErrorInfo(StdDataComparator.s_msgBundle.getMessage("0017", false, (Object[])new String[]{expectedRange.toString(), obj.toString()}));
                            }
                        }
                        catch (InvalidRangeManipulationException irme) {
                            rsltSet.addResult(node, 2);
                            break;
                        }
                        rsltSet.addResult(node, tempRes);
                        break;
lbl76:
                        // 1 sources

                        if (collected.lastIndexOf("-") > 0 || collected.lastIndexOf("+") > 0 || expected.lastIndexOf("-") > 0 || expected.lastIndexOf("+") > 0) {
                            Trace.out((String)"String is not Numeric.");
                            rsltSet.addResult(node, 2);
                            break;
                        }
                        tempCollected = collected.replaceFirst("[\\+\\-]", "0").replaceFirst("\\.", "0");
                        tempExpected = expected.replaceFirst("[\\+\\-]", "0").replaceFirst("\\.", "0");
                        p = Pattern.compile("\\D");
                        mc = p.matcher(tempCollected);
                        me = p.matcher(tempExpected);
                        if (mc.matches() || me.matches()) {
                            Trace.out((String)"String is not Numeric");
                            tempRes.setStatus(2);
                            tempRes.addErrorInfo(StdDataComparator.s_msgBundle.getMessage("0005", false));
                            rsltSet.addResult(node, tempRes);
                            break;
                        }
                        try {
                            rov = new RangeOfValue(collected.indexOf(".") > 0 || expected.indexOf(".") > 0 ? RangeType.FLOAT : RangeType.INTEGER);
                            ro = this.getDataComparatorType();
                            if (ro == null) {
                                Trace.out((String)"Unable to get appropriate Operator");
                                tempRes.setStatus(2);
                                tempRes.addErrorInfo(StdDataComparator.s_msgBundle.getMessage("0004", false));
                                rsltSet.addResult(node, tempRes);
                                break;
                            }
                            rov.include(ro, expected);
                            if (!rov.contains(obj)) {
                                tempRes.setStatus(3);
                                tempRes.addErrorInfo(StdDataComparator.s_msgBundle.getMessage("0017", false));
                            }
                        }
                        catch (InvalidRangeManipulationException irme) {
                            tempRes.setStatus(2);
                            rsltSet.addResult(node, tempRes);
                            break;
                        }
                        rsltSet.addResult(node, tempRes);
                        break;
                    }
                    case 3: 
                    case 4: {
                        rsltSet.addResult(node, 2);
                    }
                }
                continue;
            }
            Trace.out((String)("The status of execution result for node '" + node + "'+ is :" + Result.resultStatusString(result.getStatus()) + ";Hence skipped."));
            rsltSet.addResult(node, 2);
        }
        return rsltSet;
    }
}

