/*
 * Decompiled with CFR 0.152.
 */
package oracle.ops.verification.framework.engine.factory.data;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import oracle.ops.mgmt.trace.Trace;
import oracle.ops.verification.framework.engine.ResultSet;
import oracle.ops.verification.framework.engine.factory.data.NodeApplicabilityFilter;
import oracle.ops.verification.framework.util.VerificationUtil;

public class NodeApplicability {
    public static List<String> resolve(String nodeConstraintsStr, String[] nodeList) {
        ArrayList<String> applicableNodes = new ArrayList<String>();
        List<NodeApplicabilityFilter> allNodeApplicabilityFilters = NodeApplicability.parseNodeApplicabilityFilters(nodeConstraintsStr, false);
        List<NodeApplicabilityFilter> negations = NodeApplicability.parseNodeApplicabilityFilters(nodeConstraintsStr, true);
        Trace.out((String)("Resolving node applicability constraint [" + nodeConstraintsStr + "]"));
        HashSet<Object> includeNodes = new HashSet<Object>();
        HashSet<Object> excludeNodes = new HashSet<Object>();
        for (NodeApplicabilityFilter nodeApplicabilityFilter : allNodeApplicabilityFilters) {
            List<Object> nodesOfType = new ArrayList();
            switch (nodeApplicabilityFilter) {
                case hub: {
                    String[] hubNodes = VerificationUtil.filterHubNodeList(nodeList);
                    if (hubNodes == null || hubNodes.length <= 0) break;
                    nodesOfType.addAll(Arrays.asList(hubNodes));
                    break;
                }
                case leaf: {
                    String[] leafNodes = VerificationUtil.filterLeafNodeList(nodeList);
                    if (leafNodes == null || leafNodes.length <= 0) break;
                    nodesOfType.addAll(Arrays.asList(leafNodes));
                    break;
                }
                case lxc: {
                    if (!VerificationUtil.isPlatformLinux()) break;
                    ResultSet cotainerResultSet = new ResultSet();
                    nodesOfType = VerificationUtil.filterLinuxContainerNodes(nodeList, cotainerResultSet);
                    if (cotainerResultSet.allSuccess()) break;
                    Trace.out((String)cotainerResultSet.getAllErrorsStr());
                    break;
                }
                case zone: {
                    ResultSet resultSet = new ResultSet();
                    if (!VerificationUtil.isPlatformSolaris() || !VerificationUtil.isSolarisGlobalZone(nodeList, resultSet) && !VerificationUtil.isSolarisKernelZone(nodeList, resultSet)) break;
                    nodesOfType = Arrays.asList(nodeList);
                    if (resultSet.allSuccess()) break;
                    Trace.out((String)resultSet.getAllErrorsStr());
                    break;
                }
                default: {
                    nodesOfType = Arrays.asList(nodeList);
                }
            }
            if (negations.contains((Object)nodeApplicabilityFilter)) {
                excludeNodes.addAll(nodesOfType);
                continue;
            }
            includeNodes.addAll(nodesOfType);
        }
        if (includeNodes.isEmpty()) {
            includeNodes.addAll(Arrays.asList(nodeList));
        }
        Trace.out((String)("Include nodes are " + includeNodes));
        Trace.out((String)("Exclude nodes are " + excludeNodes));
        for (String string : includeNodes) {
            if (excludeNodes.contains(string)) continue;
            applicableNodes.add(string);
        }
        Trace.out((String)("Applicable Nodes are " + applicableNodes));
        return applicableNodes;
    }

    private static List<NodeApplicabilityFilter> parseNodeApplicabilityFilters(String nodeConstraintsStr, boolean onlyNegations) {
        String[] nodeApplicabilityFiltersArray;
        ArrayList<NodeApplicabilityFilter> nodeApplicabilityFilters = new ArrayList<NodeApplicabilityFilter>();
        if (VerificationUtil.isStringGood(nodeConstraintsStr) && (nodeApplicabilityFiltersArray = VerificationUtil.string2strArr(nodeConstraintsStr)) != null && nodeApplicabilityFiltersArray.length > 0) {
            for (String nodeApplicabilityFilterStr : nodeApplicabilityFiltersArray) {
                NodeApplicabilityFilter nodeApplicabilityFilter = null;
                nodeApplicabilityFilterStr = nodeApplicabilityFilterStr.trim().toLowerCase();
                try {
                    if (nodeApplicabilityFilterStr.startsWith("!")) {
                        nodeApplicabilityFilter = NodeApplicabilityFilter.valueOf(nodeApplicabilityFilterStr.substring(1));
                        nodeApplicabilityFilters.add(nodeApplicabilityFilter);
                        continue;
                    }
                    nodeApplicabilityFilter = NodeApplicabilityFilter.valueOf(nodeApplicabilityFilterStr);
                    if (onlyNegations) continue;
                    nodeApplicabilityFilters.add(nodeApplicabilityFilter);
                }
                catch (IllegalArgumentException iae) {
                    VerificationUtil.traceAndLogWarning("IGNORING - IllegalArgumentException: Incorrect filter ( " + nodeApplicabilityFilterStr + ") used for the Node applicability attribute");
                }
            }
        }
        return nodeApplicabilityFilters;
    }
}

