/*
 * Decompiled with CFR 0.152.
 */
package oracle.ops.verification.framework.engine.factory.data;

import java.util.ArrayList;
import java.util.List;
import oracle.ops.mgmt.trace.Trace;
import oracle.ops.verification.framework.engine.ResultKeyType;
import oracle.ops.verification.framework.engine.factory.data.DataComparator;
import oracle.ops.verification.framework.engine.factory.data.ExecutableArgument;
import oracle.ops.verification.framework.engine.factory.data.ExecutableResultType;
import oracle.ops.verification.framework.engine.factory.data.ExecutableType;
import oracle.ops.verification.framework.engine.factory.data.InstanceType;
import oracle.ops.verification.framework.util.VerificationUtil;

public class ExecutableInfo {
    private String m_executableName;
    private String m_executablePath;
    private ExecutableType m_executableType;
    private InstanceType m_instanceType;
    private List<ExecutableArgument> m_executableArgs;
    private ExecutableResultType m_executableResultType;
    private ResultKeyType m_execInfoKeyType = ResultKeyType.NODE;
    private DataComparator m_dataComparator;
    private boolean m_localNodeCheck;
    private boolean m_rootPrivReq;

    public ExecutableInfo(String execName, ExecutableType execType, ExecutableResultType execResType) {
        this(execName, execType, execResType, null);
    }

    public ExecutableInfo(String execName, ExecutableType execType, ExecutableResultType execResType, DataComparator dataComparator) {
        this.m_executableName = execName;
        this.m_executableArgs = new ArrayList<ExecutableArgument>();
        this.m_executableType = execType;
        this.m_executableResultType = execResType;
        this.m_dataComparator = dataComparator;
    }

    public String getExecutableNameWithPath() {
        if (this.m_executablePath == null || this.m_executablePath.length() < 1) {
            return VerificationUtil.getCVUSubDirPath() + this.m_executableName;
        }
        return this.m_executablePath + System.getProperty("file.separator") + this.m_executableName;
    }

    public String getExecutableName() {
        return this.m_executableName;
    }

    public List<ExecutableArgument> getExecutableArgs() {
        return this.m_executableArgs;
    }

    public void setExecutableArgs(List<ExecutableArgument> executableArgs) {
        this.m_executableArgs = executableArgs;
    }

    public void replaceExecArgument(ExecutableArgument eArg) {
        ExecutableArgument execArg = null;
        for (int i = 0; i < this.m_executableArgs.size(); ++i) {
            execArg = this.m_executableArgs.get(i);
            if (!execArg.getArgName().equalsIgnoreCase(eArg.getArgName())) continue;
            this.m_executableArgs.set(i, eArg);
        }
    }

    public void addExecArgument(int inx, ExecutableArgument eArg) {
        this.m_executableArgs.add(inx, eArg);
    }

    public void addExecArgument(ExecutableArgument eArg) {
        this.m_executableArgs.add(eArg);
    }

    public ExecutableResultType getResultType() {
        return this.m_executableResultType;
    }

    public ExecutableType getExecutableType() {
        return this.m_executableType;
    }

    public DataComparator getDataComparator() {
        return this.m_dataComparator;
    }

    public boolean getLocalNodeCheck() {
        return this.m_localNodeCheck;
    }

    public InstanceType getInstanceType() {
        return this.m_instanceType;
    }

    public boolean isRootPrivRequired() {
        return this.m_rootPrivReq;
    }

    public void setExecutableName(String name) {
        this.m_executableName = name;
    }

    public void setExecutablePath(String path) {
        this.m_executablePath = path;
    }

    public void setExecutableType(ExecutableType type) {
        this.m_executableType = type;
    }

    public void setExecutableResultType(ExecutableResultType type) {
        this.m_executableResultType = type;
    }

    public void setDataComparator(DataComparator dataComparator) {
        this.m_dataComparator = dataComparator;
    }

    public void setLocalNodeCheck(boolean isLocal) {
        this.m_localNodeCheck = isLocal;
    }

    public void setInstanceType(InstanceType insType) {
        this.m_instanceType = insType;
    }

    public void setRootPrivRequired(boolean rootPriv) {
        this.m_rootPrivReq = rootPriv;
    }

    public void setExecInfoKeyType(String keyType) {
        if (keyType == null) {
            Trace.out((String)"keyType string is null");
            return;
        }
        ResultKeyType execInfoKeyType = ResultKeyType.getResultKeyType(keyType);
        this.setExecInfoKeyType(execInfoKeyType);
    }

    public void setExecInfoKeyType(ResultKeyType keyType) {
        if (keyType == null) {
            Trace.out((String)"keyType is null");
            return;
        }
        this.m_execInfoKeyType = keyType;
        Trace.out((String)("m_execInfoKeyType: '" + this.m_execInfoKeyType.getResultKeyStr() + "'"));
    }

    public ResultKeyType getExecInfoKeyType() {
        return this.m_execInfoKeyType;
    }

    public Object clone() {
        ExecutableInfo task = new ExecutableInfo(this.m_executableName, this.m_executableType, this.m_executableResultType, this.m_dataComparator);
        task.m_executablePath = this.m_executablePath;
        task.m_localNodeCheck = this.m_localNodeCheck;
        task.m_rootPrivReq = this.m_rootPrivReq;
        task.m_executableArgs = this.m_executableArgs;
        task.m_instanceType = this.m_instanceType;
        return task;
    }
}

