/*
 * Decompiled with CFR 0.152.
 */
package oracle.ops.verification.framework.engine.factory.data;

import oracle.ops.verification.framework.engine.factory.data.ArgType;
import oracle.ops.verification.framework.engine.factory.data.DataType;
import oracle.ops.verification.framework.util.CVUVariables;
import oracle.ops.verification.framework.util.VerificationUtil;

public class ExecutableArgument {
    private String m_argName;
    private ArgType m_argType;
    private DataType m_argDataType;
    private String m_argVal;
    private String m_argDefaultVal = null;

    public ExecutableArgument(String argName, ArgType argType, DataType argDataType, String argVal, String argDefaultVal) {
        this.m_argName = argName;
        this.m_argType = argType;
        this.m_argDataType = argDataType;
        this.m_argVal = argVal;
        this.m_argDefaultVal = argDefaultVal;
    }

    public ExecutableArgument(String argName, ArgType argType, DataType argDataType, String argVal) {
        this(argName, argType, argDataType, argVal, null);
    }

    public String getArgName() {
        return this.m_argName;
    }

    public String getArgVal(boolean resolve) {
        String returnVal = this.m_argVal;
        if (resolve && this.m_argType == ArgType.DERIVED) {
            returnVal = CVUVariables.getValue(this.m_argVal);
        }
        if (!VerificationUtil.isStringGood(returnVal)) {
            returnVal = VerificationUtil.isStringGood(this.m_argDefaultVal) ? this.m_argDefaultVal : "";
        }
        return returnVal;
    }

    public ArgType getArgType() {
        return this.m_argType;
    }

    public DataType getArgDataType() {
        return this.m_argDataType;
    }

    public void setArgVal(String argVal) {
        this.m_argVal = argVal;
    }

    public String getArgDefaultValue() {
        return this.m_argDefaultVal;
    }
}

