/*
 * Decompiled with CFR 0.152.
 */
package oracle.ops.verification.framework.engine.component;

import java.util.List;
import oracle.cluster.verification.ParamPreReq;
import oracle.cluster.verification.ParamPreReqCRSInst;
import oracle.cluster.verification.ParamPreReqDBInst;
import oracle.cluster.verification.ParamPreReqHAConfig;
import oracle.cluster.verification.SubtasksNotCompleteException;
import oracle.cluster.verification.SubtasksUnavailableException;
import oracle.cluster.verification.VerificationException;
import oracle.cluster.verification.VerificationResultSet;
import oracle.cluster.verification.VerificationTask;
import oracle.cluster.verification.util.VerificationType;
import oracle.ops.mgmt.trace.Trace;
import oracle.ops.verification.framework.engine.ErrorDescription;
import oracle.ops.verification.framework.engine.Result;
import oracle.ops.verification.framework.engine.ResultSet;
import oracle.ops.verification.framework.engine.component.Component;
import oracle.ops.verification.framework.engine.component.ComponentInitException;
import oracle.ops.verification.framework.engine.task.Task;
import oracle.ops.verification.framework.engine.task.TaskFactory;
import oracle.ops.verification.framework.engine.task.TaskFactoryException;
import oracle.ops.verification.framework.report.ReportUtil;
import oracle.ops.verification.framework.util.CVUVariableConstants;
import oracle.ops.verification.framework.util.CVUVariables;
import oracle.ops.verification.framework.util.RootAutomationNotConfiguredException;
import oracle.ops.verification.framework.util.RootAutomationUtility;
import oracle.ops.verification.framework.util.VerificationUtil;

public class SystemComponent
extends Component {
    private String m_operation;
    private boolean m_toCheckUserEquiv = false;
    private String m_product;
    private String m_release;
    private String m_osdba;
    private String m_osoper;
    private String m_asmoper;
    private String m_oraInv;
    VerificationType m_preReqVerificationType = null;
    private ParamPreReq m_paramPreReq = null;

    SystemComponent(VerificationType verificationType) throws ComponentInitException {
        super(verificationType);
        this.init();
    }

    @Override
    public void init() throws ComponentInitException {
        super.init();
        this.m_release = CVUVariables.getValue(CVUVariableConstants.RELEASE);
        this.m_operation = this.m_paramMgr.getAdminPrivOperation();
        this.m_osdba = CVUVariables.getValue(CVUVariableConstants.DBA_GROUP);
        this.m_osoper = CVUVariables.getValue(CVUVariableConstants.OPER_GROUP);
        this.m_asmoper = CVUVariables.getValue(CVUVariableConstants.ASM_OPER_GROUP);
        this.m_oraInv = CVUVariables.getValue(CVUVariableConstants.INSTALL_GROUP);
        switch (this.m_verificationType) {
            case COMPONENT_SYSTEM_REQUIREMENTS: {
                this.m_product = this.getProduct();
                if (this.m_product == null) {
                    this.m_product = CVUVariables.getValue(CVUVariableConstants.PRODUCT);
                }
                if ("10gR1".equalsIgnoreCase(this.m_release)) {
                    this.m_release = "10.1";
                } else if ("10gR2".equalsIgnoreCase(this.m_release)) {
                    this.m_release = "10.2";
                } else if ("11gR1".equalsIgnoreCase(this.m_release)) {
                    this.m_release = "11.1";
                } else if ("11gR2".equalsIgnoreCase(this.m_release)) {
                    this.m_release = "11.2";
                }
                if ("crs".equals(this.m_product)) {
                    this.m_paramPreReq = new ParamPreReqCRSInst();
                    this.m_preReqVerificationType = VerificationType.SYSREQ_CRS;
                    ((ParamPreReqCRSInst)this.m_paramPreReq).setRelease(this.m_release);
                    if (this.m_osdba == null) {
                        this.m_osdba = VerificationUtil.getDefaultDbaGroup();
                    }
                    if (this.m_oraInv == null) {
                        Result result = new Result(VerificationUtil.getLocalNode());
                        this.m_oraInv = VerificationUtil.getDefaultOraInvGroup(result);
                        if (this.m_oraInv == null) {
                            Trace.out((int)5, (String)"%s", (Object[])new Object[]{result.traceResultInfo()});
                            ReportUtil.processAlert(VerificationUtil.LSEP + ReportUtil.ERROR + VerificationUtil.LSEP + s_prvgMsgBundle.getMessage("10467", true));
                        }
                    }
                    if (this.m_osdba != null) {
                        ((ParamPreReqCRSInst)this.m_paramPreReq).setOSDBAgroup(this.m_osdba);
                    }
                    if (this.m_oraInv != null) {
                        ((ParamPreReqCRSInst)this.m_paramPreReq).setORAINVgroup(this.m_oraInv);
                    }
                    if (this.m_asmoper == null) break;
                    ((ParamPreReqCRSInst)this.m_paramPreReq).setASMOPERgroup(this.m_asmoper);
                    break;
                }
                if ("database".equals(this.m_product)) {
                    this.m_paramPreReq = new ParamPreReqDBInst();
                    this.m_preReqVerificationType = VerificationType.SYSREQ_DB;
                    ((ParamPreReqDBInst)this.m_paramPreReq).setRelease(this.m_release);
                    if (!VerificationUtil.isHealthCheckMode() && this.m_osdba == null) {
                        this.m_osdba = VerificationUtil.getDefaultDbaGroup();
                    }
                    if (this.m_oraInv == null) {
                        this.m_oraInv = VerificationUtil.getOraInventoryGroup();
                    }
                    if (this.m_osdba != null) {
                        ((ParamPreReqDBInst)this.m_paramPreReq).setOSDBAgroup(this.m_osdba);
                    }
                    if (this.m_oraInv != null) {
                        ((ParamPreReqDBInst)this.m_paramPreReq).setOraInv(this.m_oraInv);
                    }
                    if (this.m_osoper == null) break;
                    ((ParamPreReqDBInst)this.m_paramPreReq).setOSOPERgroup(this.m_osoper);
                    break;
                }
                if (!"ha".equals(this.m_product)) break;
                this.m_paramPreReq = new ParamPreReqHAConfig();
                this.m_preReqVerificationType = VerificationType.SYSREQ_SI_HA;
                if (this.m_osdba == null) {
                    this.m_osdba = VerificationUtil.getDefaultDbaGroup();
                }
                if (this.m_oraInv == null) {
                    Result result = new Result(VerificationUtil.getLocalNode());
                    this.m_oraInv = VerificationUtil.getDefaultOraInvGroup(result);
                    if (this.m_oraInv == null) {
                        Trace.out((int)5, (String)"%s", (Object[])new Object[]{result.traceResultInfo()});
                        ReportUtil.processAlert(VerificationUtil.LSEP + ReportUtil.ERROR + VerificationUtil.LSEP + s_prvgMsgBundle.getMessage("10467", true));
                    }
                }
                if (this.m_osdba != null) {
                    ((ParamPreReqHAConfig)this.m_paramPreReq).setOSDBA(this.m_osdba);
                }
                if (this.m_oraInv != null) {
                    ((ParamPreReqHAConfig)this.m_paramPreReq).setOraInv(this.m_oraInv);
                }
                if (this.m_asmoper == null) break;
                ((ParamPreReqHAConfig)this.m_paramPreReq).setASMOPERgroup(this.m_asmoper);
                break;
            }
            case COMPONENT_ADMIN_PRIVILEGES: {
                this.m_operation = this.m_paramMgr.getAdminPrivOperation();
                this.m_toCheckUserEquiv = true;
            }
        }
    }

    @Override
    public boolean verify() {
        boolean retval = this.checkSetup();
        String[] validNodeArr = this.getValidNodeList();
        if (null == validNodeArr) {
            return false;
        }
        switch (this.m_verificationType) {
            case COMPONENT_SYSTEM_REQUIREMENTS: {
                try {
                    List<Task> taskList = TaskFactory.getInstance().getTaskList(this.m_preReqVerificationType, validNodeArr, this.m_paramPreReq);
                    for (Task task : taskList) {
                        if (task.hasSubtasks()) {
                            List<VerificationTask> subTaskList = task.getSubtasks();
                            for (VerificationTask subTask : subTaskList) {
                                this.m_taskReportList.add((Task)subTask);
                                VerificationResultSet vrset = subTask.verify();
                                retval &= ((ResultSet)vrset).allSuccess();
                                if (Trace.isLevelEnabled((int)1)) {
                                    Trace.out((String)("\n>>>> SystemComponent:: Upload SubTask=" + subTask.getElementName() + "results >>>>>\n"));
                                }
                                this.m_resultSet.uploadResultSet((ResultSet)vrset);
                            }
                            continue;
                        }
                        this.m_taskReportList.add(task);
                        retval &= task.perform();
                        if (Trace.isLevelEnabled((int)1)) {
                            Trace.out((String)("\n>>>> SystemComponent:: Upload Task=" + task.getElementName() + "results >>>>>\n"));
                        }
                        this.m_resultSet.uploadResultSet(task.getResultSet());
                    }
                }
                catch (TaskFactoryException e) {
                    Trace.out((Exception)e);
                    this.m_resultSet.addResult(validNodeArr, 2);
                    this.m_resultSet.addErrorDescription(validNodeArr, new ErrorDescription(e.getCompleteMessage()));
                    String stopMessage = e.getCompleteMessage() + LSEP + s_msgBundle.getMessage("0007", false) + LSEP;
                    ReportUtil.printError(stopMessage);
                    ReportUtil.reportPrint(stopMessage);
                    return false;
                }
                catch (SubtasksUnavailableException e) {
                    Trace.out((Exception)e);
                    this.m_resultSet.addResult(validNodeArr, 2);
                    this.m_resultSet.addErrorDescription(validNodeArr, new ErrorDescription(e.getMessage()));
                    String stopMessage = e.getMessage() + LSEP + s_msgBundle.getMessage("0007", false) + LSEP;
                    ReportUtil.printError(stopMessage);
                    ReportUtil.reportPrint(stopMessage);
                    return false;
                }
                catch (SubtasksNotCompleteException e) {
                    Trace.out((Exception)e);
                    this.m_resultSet.addResult(validNodeArr, 2);
                    this.m_resultSet.addErrorDescription(validNodeArr, new ErrorDescription(e.getMessage()));
                    String stopMessage = e.getMessage() + LSEP + s_msgBundle.getMessage("0007", false) + LSEP;
                    ReportUtil.printError(stopMessage);
                    ReportUtil.reportPrint(stopMessage);
                    return false;
                }
                catch (VerificationException e) {
                    Trace.out((Exception)e);
                    this.m_resultSet.addResult(validNodeArr, 2);
                    this.m_resultSet.addErrorDescription(validNodeArr, new ErrorDescription(e.getMessage()));
                    String stopMessage = e.getMessage() + LSEP + s_msgBundle.getMessage("0007", false) + LSEP;
                    ReportUtil.printError(stopMessage);
                    ReportUtil.reportPrint(stopMessage);
                    return false;
                }
                return retval;
            }
            case COMPONENT_ADMIN_PRIVILEGES: {
                if (!this.m_operation.equalsIgnoreCase("user_equiv") && RootAutomationUtility.isRootExecutionConfigured()) {
                    try {
                        if (!RootAutomationUtility.validateRootPrivileges(validNodeArr)) {
                            this.m_resultSet.addResult(validNodeArr, 3);
                            return false;
                        }
                    }
                    catch (RootAutomationNotConfiguredException rance) {
                        Trace.out((String)"Contradictory status of root automation configuration");
                        this.m_resultSet.addResult(validNodeArr, 2);
                        return false;
                    }
                }
                return super.verifyComponent();
            }
        }
        Trace.out((String)"ERROR: Invalid Verification Type!");
        return false;
    }

    public String getProduct() {
        return this.m_product;
    }

    public void setProduct(String product) {
        this.m_product = product;
    }

    @Override
    public String getComponentName() {
        return "SYS";
    }

    @Override
    public String getComponentDisplayName() {
        return s_msgBundle.getMessage("9968", false);
    }
}

