/*
 * Decompiled with CFR 0.152.
 */
package oracle.ops.verification.framework.engine.component;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Set;
import oracle.cluster.verification.util.VerificationType;
import oracle.ops.mgmt.trace.Trace;
import oracle.ops.verification.framework.engine.component.Component;
import oracle.ops.verification.framework.engine.component.ComponentInitException;
import oracle.ops.verification.framework.storage.StorageUtil;
import oracle.ops.verification.framework.util.CVUVariableConstants;
import oracle.ops.verification.framework.util.CVUVariables;
import oracle.ops.verification.framework.util.VerificationUtil;

public class StorageComponent
extends Component {
    StorageComponent(VerificationType verificationType) throws ComponentInitException {
        super(verificationType);
        this.init();
    }

    @Override
    public void init() throws ComponentInitException {
        super.init();
        switch (this.m_verificationType) {
            case COMPONENT_SPACE_AVAILABILITY: {
                break;
            }
            case COMPONENT_SHARED_STORAGE_ACCESS: {
                String deviceString;
                String reqRelease = CVUVariables.getValue(CVUVariableConstants.RELEASE);
                if (reqRelease == null) {
                    reqRelease = "12.2";
                }
                if ((deviceString = CVUVariables.getValue(CVUVariableConstants.ASM_DISK_DISCOVERY_STRING)) == null && (this.m_paramMgr.checkASM() || this.m_paramMgr.checkFlex())) {
                    deviceString = VerificationUtil.strArr2List(VerificationUtil.getDefaultDiscoveryDevice(reqRelease));
                    CVUVariables.setValue(CVUVariableConstants.ASM_DISK_DISCOVERY_STRING, deviceString);
                }
                if (deviceString == null) break;
                String autoNodeListStr = CVUVariables.getValue(CVUVariableConstants.AUTO_LIST);
                String hubNodeListStr = CVUVariables.getValue(CVUVariableConstants.HUB_LIST);
                String[] autoNodeList = null;
                String[] hubNodeList = null;
                if (VerificationUtil.isStringGood(autoNodeListStr)) {
                    autoNodeList = autoNodeListStr.split(",");
                }
                if (VerificationUtil.isStringGood(hubNodeListStr)) {
                    hubNodeList = hubNodeListStr.split(",");
                }
                if (autoNodeList == null && hubNodeList == null) break;
                ArrayList<String> hubAutoNodeList = new ArrayList<String>();
                if (autoNodeList != null) {
                    hubAutoNodeList.addAll(Arrays.asList(autoNodeList));
                }
                if (hubNodeList != null) {
                    hubAutoNodeList.addAll(Arrays.asList(hubNodeList));
                }
                Set<String> asmDeviceList = StorageUtil.expandDevicePaths(hubAutoNodeList.toArray(new String[0]), deviceString.split(","));
                CVUVariables.setValue(CVUVariableConstants.ASM_DISKGROUP_DISKS, VerificationUtil.strCollection2String(asmDeviceList));
            }
        }
    }

    @Override
    public boolean verify() {
        this.checkSetup();
        if (null == this.getValidNodeList()) {
            return false;
        }
        switch (this.m_verificationType) {
            case COMPONENT_SPACE_AVAILABILITY: 
            case COMPONENT_SHARED_STORAGE_ACCESS: {
                return super.verifyComponent();
            }
        }
        Trace.out((String)"ERROR: Invalid Verification Type!");
        return false;
    }

    @Override
    public String getComponentName() {
        return "STORAGE";
    }

    @Override
    public String getComponentDisplayName() {
        return s_msgBundle.getMessage("9967", false);
    }
}

