/*
 * Decompiled with CFR 0.152.
 */
package oracle.ops.verification.framework.engine.component;

import java.io.File;
import oracle.cluster.verification.InvalidPathException;
import oracle.cluster.verification.util.VerificationType;
import oracle.cluster.verification.util.XmlFilePathException;
import oracle.ops.mgmt.nls.MessageBundle;
import oracle.ops.mgmt.nls.MessageBundleList;
import oracle.ops.mgmt.trace.Trace;
import oracle.ops.verification.framework.engine.ErrorDescription;
import oracle.ops.verification.framework.engine.component.Component;
import oracle.ops.verification.framework.engine.component.ComponentInitException;
import oracle.ops.verification.framework.util.Assert;
import oracle.ops.verification.framework.util.CVUVariableConstants;
import oracle.ops.verification.framework.util.CVUVariables;
import oracle.ops.verification.framework.util.VerificationUtil;

public class SoftwareComponent
extends Component {
    SoftwareComponent(VerificationType verificationType) throws ComponentInitException {
        super(verificationType);
        this.init();
    }

    @Override
    public void init() throws ComponentInitException {
        super.init();
    }

    @Override
    public boolean verify() {
        this.checkSetup();
        Object errDesc = null;
        String[] validNodeArr = this.getValidNodeList();
        if (null == validNodeArr) {
            return false;
        }
        if (!this.checkCRSConfiguration(validNodeArr)) {
            return false;
        }
        String release = null;
        String oracleHome = CVUVariables.getValue(CVUVariableConstants.ORACLE_HOME);
        Trace.out((String)("==== ParamManager reports Oracle Home as: " + oracleHome));
        if (oracleHome != null) {
            try {
                Assert.assertDir(oracleHome);
            }
            catch (InvalidPathException ipe) {
                Trace.out((Exception)ipe);
                String errMsg = s_msgBundle.getMessage("0006", true, (Object[])new String[]{oracleHome}) + LSEP + ipe.getMessage();
                ErrorDescription erD = new ErrorDescription(errMsg);
                this.m_resultSet.addErrorDescription(erD);
                this.m_resultSet.addResult(this.m_nodeList, 2);
                return false;
            }
            release = CVUVariables.getValue(CVUVariableConstants.RELEASE);
            if ("10gR1".equalsIgnoreCase(release)) {
                release = "10.1";
            } else if ("10gR2".equalsIgnoreCase(release)) {
                release = "10.2";
            } else if ("11gR1".equalsIgnoreCase(release)) {
                release = "11.1";
            } else if ("11gR2".equalsIgnoreCase(release)) {
                release = "11.2";
            }
        } else {
            String home = null;
            boolean haConfigured = VerificationUtil.isHAConfigured();
            if (haConfigured) {
                home = VerificationUtil.getHAHome();
                if (home == null) {
                    Trace.out((String)"Cannot get HA Home");
                    String errMsg = s_msgBundle.getMessage("5307", true);
                    ErrorDescription erD = new ErrorDescription(errMsg);
                    this.m_resultSet.addErrorDescription(erD);
                    this.m_resultSet.addResult(this.m_nodeList, 2);
                    return false;
                }
            } else {
                home = VerificationUtil.getCRSHome();
                if (home == null) {
                    Trace.out((String)"Cannot get CRS Home");
                    String errMsg = s_msgBundle.getMessage("5301", true);
                    ErrorDescription erD = new ErrorDescription(errMsg);
                    this.m_resultSet.addErrorDescription(erD);
                    this.m_resultSet.addResult(this.m_nodeList, 2);
                    return false;
                }
            }
            try {
                Assert.assertDir(home);
            }
            catch (InvalidPathException ipe) {
                Trace.out((Exception)ipe);
                String errMsg = s_msgBundle.getMessage(haConfigured ? "5307" : "5301", true) + LSEP + ipe.getMessage();
                ErrorDescription erD = new ErrorDescription(errMsg);
                this.m_resultSet.addErrorDescription(erD);
                this.m_resultSet.addResult(this.m_nodeList, 2);
                return false;
            }
            Trace.out((String)"init: Validation for comp software");
            if (haConfigured) {
                File cfgFile;
                MessageBundle theMB = MessageBundle.getMessageBundle((MessageBundleList.FacilityList)MessageBundleList.FacilityList.Prvg);
                String cfgFilePath = null;
                try {
                    cfgFilePath = VerificationUtil.getCompSoftwareConfigXmlPath();
                }
                catch (XmlFilePathException x) {
                    Trace.out((String)"Cannot get software confil xml path");
                    ErrorDescription erD = new ErrorDescription(x.getMessage());
                    this.m_resultSet.addErrorDescription(erD);
                    this.m_resultSet.addResult(this.m_nodeList, 2);
                    return false;
                }
                if (cfgFilePath != null && !(cfgFile = new File(cfgFilePath)).exists()) {
                    String errMsg = s_msgBundle.getMessage("5740", true);
                    ErrorDescription erD = new ErrorDescription(errMsg);
                    this.m_resultSet.addErrorDescription(erD);
                    this.m_resultSet.addResult(this.m_nodeList, 2);
                    return false;
                }
            }
            String activeVersion = null;
            activeVersion = haConfigured ? VerificationUtil.getSIHAReleaseVersion() : VerificationUtil.getCRSActiveVersion();
            if (activeVersion == null) {
                release = "12.2";
            } else if (activeVersion.startsWith("12.1") || activeVersion.startsWith("12.0")) {
                release = "12.1";
            } else if (activeVersion.startsWith("11.2")) {
                release = "11.2";
            } else if (activeVersion.startsWith("11.1") || activeVersion.startsWith("11.0")) {
                release = "11.1";
            } else if (activeVersion.startsWith("10.2")) {
                release = "10.2";
            } else if (activeVersion.startsWith("10.1") || activeVersion.startsWith("10.0")) {
                release = "10.1";
            }
        }
        if (VerificationUtil.isStringGood(release)) {
            CVUVariables.setValue(CVUVariableConstants.RELEASE, release);
        }
        switch (this.m_verificationType) {
            case COMPONENT_SOFTWARE: {
                return super.verifyComponent();
            }
        }
        Trace.out((String)"ERROR: Invalid Verification Type!");
        return false;
    }

    @Override
    public String getComponentName() {
        return "SOFTWARE";
    }

    @Override
    public String getComponentDisplayName() {
        return s_msgBundle.getMessage("9966", false);
    }
}

