/*
 * Decompiled with CFR 0.152.
 */
package oracle.ops.verification.framework.engine.component;

import oracle.cluster.verification.NodeRoleCapability;
import oracle.cluster.verification.nodemgr.NodeManager;
import oracle.cluster.verification.nodemgr.NodeManagerException;
import oracle.cluster.verification.util.VerificationType;
import oracle.ops.mgmt.trace.Trace;
import oracle.ops.verification.framework.engine.component.Component;
import oracle.ops.verification.framework.engine.component.ComponentInitException;
import oracle.ops.verification.framework.engine.factory.context.GlobalVerificationContext;
import oracle.ops.verification.framework.report.ReportUtil;
import oracle.ops.verification.framework.util.VerificationUtil;

public class ScanComponent
extends Component {
    ScanComponent(VerificationType verificationType) throws ComponentInitException {
        super(verificationType);
        this.init();
    }

    @Override
    public void init() throws ComponentInitException {
        super.init(false);
        String localNode = VerificationUtil.getLocalNode();
        this.m_nodeList = new String[]{localNode};
        NodeManager nm = this.initNodeManager();
        try {
            this.m_nodeList = nm.getNodes(NodeRoleCapability.ALL);
        }
        catch (NodeManagerException ex) {
            Trace.out((String)("NodeManagerException occured. message: " + ex.getMessage()));
            Trace.out((Exception)ex);
            throw new ComponentInitException(ex.getMessage());
        }
        VerificationUtil.setNodelist(this.m_nodeList);
        GlobalVerificationContext globalCtx = GlobalVerificationContext.getInstance();
        if (globalCtx.isApplicationCluster()) {
            VerificationUtil.traceAndLog("Application Cluster environment");
            String msg = null;
            msg = s_prvgMsgBundle.getMessage("13210", true);
            ReportUtil.quietprintln(msg);
            throw new ComponentInitException(msg);
        }
    }

    @Override
    protected boolean checkSetup() {
        if (Trace.isLevelEnabled((int)2)) {
            Trace.out((String)"ENTRY");
        }
        super.checkSetup();
        if (this.getValidNodeList() == null) {
            return false;
        }
        if (Trace.isLevelEnabled((int)2)) {
            Trace.out((String)"EXIT");
        }
        return true;
    }

    @Override
    public boolean verify() {
        if (Trace.isLevelEnabled((int)2)) {
            Trace.out((String)"ENTRY");
        }
        if (!this.checkSetup()) {
            return false;
        }
        if (null == this.getValidNodeList()) {
            return false;
        }
        switch (this.m_verificationType) {
            case COMPONENT_SCAN: {
                return super.verifyComponent();
            }
        }
        Trace.out((String)"ERROR: Invalid Verification Type!");
        return false;
    }

    @Override
    public String getComponentName() {
        return "SCAN";
    }

    @Override
    public String getComponentDisplayName() {
        return s_msgBundle.getMessage("9965", false);
    }
}

