/*
 * Decompiled with CFR 0.152.
 */
package oracle.ops.verification.framework.engine.component;

import oracle.cluster.verification.util.VerificationType;
import oracle.ops.mgmt.trace.Trace;
import oracle.ops.verification.framework.engine.component.Component;
import oracle.ops.verification.framework.engine.component.ComponentInitException;
import oracle.ops.verification.framework.util.RootAutomationNotConfiguredException;
import oracle.ops.verification.framework.util.RootAutomationUtility;

public class OCRComponent
extends Component {
    OCRComponent(VerificationType verificationType) throws ComponentInitException {
        super(verificationType);
        this.init();
    }

    @Override
    public void init() throws ComponentInitException {
        super.init();
    }

    @Override
    public boolean verify() {
        this.checkSetup();
        String[] validNodeArr = this.getValidNodeList();
        if (null == validNodeArr) {
            return false;
        }
        if (RootAutomationUtility.isRootExecutionConfigured()) {
            try {
                if (!RootAutomationUtility.validateRootPrivileges(validNodeArr)) {
                    this.m_resultSet.addResult(validNodeArr, 3);
                    return false;
                }
            }
            catch (RootAutomationNotConfiguredException rance) {
                Trace.out((String)"Contradictory status of root automation configuration");
                this.m_resultSet.addResult(validNodeArr, 2);
                return false;
            }
        }
        switch (this.m_verificationType) {
            case COMPONENT_OCR_INTEGRITY: {
                return super.verifyComponent();
            }
        }
        Trace.out((String)"ERROR: Invalid Verification Type!");
        return false;
    }

    @Override
    public String getComponentName() {
        return "OCR";
    }

    @Override
    public String getComponentDisplayName() {
        return s_msgBundle.getMessage("9962", false);
    }
}

