/*
 * Decompiled with CFR 0.152.
 */
package oracle.ops.verification.framework.engine.component;

import oracle.cluster.verification.util.VerificationType;
import oracle.ops.mgmt.trace.Trace;
import oracle.ops.verification.framework.engine.component.Component;
import oracle.ops.verification.framework.engine.component.ComponentInitException;
import oracle.ops.verification.framework.engine.factory.context.GlobalVerificationContext;
import oracle.ops.verification.framework.report.ReportUtil;
import oracle.ops.verification.framework.util.VerificationUtil;

public class NodeAppComponent
extends Component {
    NodeAppComponent(VerificationType verificationType) throws ComponentInitException {
        super(verificationType);
        this.init();
    }

    @Override
    public void init() throws ComponentInitException {
        super.init();
        GlobalVerificationContext globalCtx = GlobalVerificationContext.getInstance();
        if (globalCtx.isApplicationCluster()) {
            VerificationUtil.traceAndLog("Application Cluster environment");
            String msg = null;
            msg = s_prvgMsgBundle.getMessage("13211", true);
            ReportUtil.quietprintln(msg);
            throw new ComponentInitException(msg);
        }
    }

    @Override
    public boolean verify() {
        this.checkSetup();
        if (null == this.getValidNodeList()) {
            return false;
        }
        switch (this.m_verificationType) {
            case COMPONENT_NODEAPP_EXISTENCE: {
                return super.verifyComponent();
            }
        }
        Trace.out((String)"ERROR: Invalid Verification Type!");
        return false;
    }

    @Override
    public String getComponentName() {
        return "NODE_APP";
    }

    @Override
    public String getComponentDisplayName() {
        return s_msgBundle.getMessage("9960", false);
    }
}

