/*
 * Decompiled with CFR 0.152.
 */
package oracle.ops.verification.framework.engine.component;

import java.io.File;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Hashtable;
import java.util.List;
import java.util.Vector;
import java.util.regex.Pattern;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;
import oracle.cluster.cvu.CVU;
import oracle.cluster.cvu.CVUFactory;
import oracle.cluster.deployment.ClusterwareInfo;
import oracle.cluster.install.InstallException;
import oracle.cluster.sql.DBConnectionException;
import oracle.cluster.sql.SQLFactory;
import oracle.cluster.util.ConsoleUtil;
import oracle.cluster.util.ConsoleUtilException;
import oracle.cluster.util.NotExistsException;
import oracle.cluster.util.SRVMContext;
import oracle.cluster.util.SRVMContextException;
import oracle.cluster.verification.CollectionResult;
import oracle.cluster.verification.CollectionValueUnavailableException;
import oracle.cluster.verification.InvalidPathException;
import oracle.cluster.verification.NodeResultStatus;
import oracle.cluster.verification.ParamPreReq;
import oracle.cluster.verification.ParamPreReqAppCluster;
import oracle.cluster.verification.ParamPreReqCRSInst;
import oracle.cluster.verification.ParamPreReqDBConfig;
import oracle.cluster.verification.ParamPreReqUSMConfig;
import oracle.cluster.verification.PreReqNotSupportedException;
import oracle.cluster.verification.SeverityType;
import oracle.cluster.verification.SubtasksNotCompleteException;
import oracle.cluster.verification.SubtasksUnavailableException;
import oracle.cluster.verification.VerificationError;
import oracle.cluster.verification.VerificationException;
import oracle.cluster.verification.VerificationTask;
import oracle.cluster.verification.asm.ASMConnectInfo;
import oracle.cluster.verification.common.CVUException;
import oracle.cluster.verification.database.DatabaseConnectInfo;
import oracle.cluster.verification.nodemgr.NodeManager;
import oracle.cluster.verification.util.DBUtils;
import oracle.cluster.verification.util.DBUtilsException;
import oracle.cluster.verification.util.DatabaseInfo;
import oracle.cluster.verification.util.VerificationType;
import oracle.cluster.verification.util.XmlFilePathException;
import oracle.jdbc.driver.OracleConnection;
import oracle.ops.mgmt.cluster.ClusterCmd;
import oracle.ops.mgmt.cluster.ClusterException;
import oracle.ops.mgmt.cluster.Version;
import oracle.ops.mgmt.nativesystem.NativeSystem;
import oracle.ops.mgmt.nativesystem.SystemFactory;
import oracle.ops.mgmt.trace.Trace;
import oracle.ops.verification.framework.VerificationConstants;
import oracle.ops.verification.framework.engine.ErrorDescription;
import oracle.ops.verification.framework.engine.Result;
import oracle.ops.verification.framework.engine.ResultSet;
import oracle.ops.verification.framework.engine.component.Component;
import oracle.ops.verification.framework.engine.component.ComponentInitException;
import oracle.ops.verification.framework.engine.component.FreeSpaceComponent;
import oracle.ops.verification.framework.engine.component.UpdateCVUAttribute;
import oracle.ops.verification.framework.engine.factory.context.VerificationTaskContext;
import oracle.ops.verification.framework.engine.task.Target;
import oracle.ops.verification.framework.engine.task.Task;
import oracle.ops.verification.framework.engine.task.TaskCTSSIntegrity;
import oracle.ops.verification.framework.engine.task.TaskFactory;
import oracle.ops.verification.framework.engine.task.TaskFactoryException;
import oracle.ops.verification.framework.engine.task.TaskSoftwareDistribution;
import oracle.ops.verification.framework.global.GlobalExecution;
import oracle.ops.verification.framework.param.CLSyntax;
import oracle.ops.verification.framework.report.ReportToolException;
import oracle.ops.verification.framework.report.ReportUtil;
import oracle.ops.verification.framework.report.ReportUtilConstants;
import oracle.ops.verification.framework.report.htmlreport.HtmlBrowserException;
import oracle.ops.verification.framework.report.htmlreport.HtmlConstants;
import oracle.ops.verification.framework.report.htmlreport.HtmlReportToolException;
import oracle.ops.verification.framework.report.xmlreport.XmlReportTool;
import oracle.ops.verification.framework.report.xmlreport.XmlReportToolException;
import oracle.ops.verification.framework.util.ASMDiskGroupsUtil;
import oracle.ops.verification.framework.util.ASMDiskGroupsUtilException;
import oracle.ops.verification.framework.util.Assert;
import oracle.ops.verification.framework.util.CVUHelperUtil;
import oracle.ops.verification.framework.util.CVUVariableConstants;
import oracle.ops.verification.framework.util.CVUVariables;
import oracle.ops.verification.framework.util.ClusterwareUtil;
import oracle.ops.verification.framework.util.HeavyWeightVerificationUtil;
import oracle.ops.verification.framework.util.NodelistNotFoundException;
import oracle.ops.verification.framework.util.VerificationUtil;

public class HealthCheckComponent
extends Component {
    private String[] m_validNodeArr = null;
    DBUtils m_dbUtils = null;
    private boolean m_isSpaceAlert = false;
    private String[] m_spaceAlertMsgArr = null;
    private static final String DB_CREDENTIAL_OERR = "ORA-01017";
    private static final int DB_PASSWORD_ATTMPTS = 3;
    private List<String> databaseHomeSoftwareVerifiedList = new ArrayList<String>();
    private boolean m_asmRunning = false;
    private String m_asmNotRunningMsg = null;
    private boolean m_isApplicationCluster = false;
    private NodeManager m_nodeManager = null;
    private ReportUtilConstants.BasicClusterWareDetails m_details = null;

    HealthCheckComponent(VerificationType verificationType) throws ComponentInitException {
        super(verificationType);
        this.init();
    }

    @Override
    public void init() throws ComponentInitException {
        Trace.out((String)"==== Skipping nodelist initialization.");
        CVUVariables.setValue(CVUVariableConstants.MODE_HEALTH_CHECK, "TRUE");
        super.init(false);
    }

    @Override
    public boolean verify() {
        boolean retval = true;
        String localNode = VerificationUtil.getLocalNode();
        if (!this.checkCRSConfiguration(new String[]{localNode})) {
            return false;
        }
        try {
            this.m_nodeList = VerificationUtil.getStaticNodelist();
            Trace.out((String)("==== nodelist for component is : " + VerificationUtil.strArr2List(this.m_nodeList)));
            CVUVariables.getValue(CVUVariableConstants.HEALTH_CHECK_REPORT_NAME);
        }
        catch (NodelistNotFoundException e) {
            Trace.out((String)("==== " + e.getMessage()));
            ErrorDescription errDesc = new ErrorDescription(e.getMessage());
            this.m_resultSet.addResult(localNode, 2);
            this.m_resultSet.addErrorDescription(localNode, errDesc);
            return false;
        }
        VerificationUtil.adjustTraceSize(this.m_nodeList.length);
        ClusterwareInfo clustInfo = new ClusterwareInfo();
        try {
            this.m_isApplicationCluster = clustInfo.isApplicationCluster();
        }
        catch (InstallException e) {
            Trace.out((String)"couldn't determine if it is an application cluster");
        }
        try {
            this.m_nodeManager = this.initNodeManager();
        }
        catch (ComponentInitException e) {
            Trace.out((String)("==== " + e.getMessage()));
            ErrorDescription errDesc = new ErrorDescription(e.getMessage());
            this.m_resultSet.addResult(this.m_nodeList, 2);
            this.m_resultSet.addErrorDescription(this.m_nodeList, errDesc);
            return false;
        }
        if (this.m_nodeList.length > 1) {
            VerificationUtil.setLocalNodeOperation(false);
        }
        try {
            if (VerificationUtil.isCVUResource()) {
                SRVMContext ctx = SRVMContext.getInstance();
                ctx.init(true);
                CVUVariables.setValue(CVUVariableConstants.MODE_CVU_RESOURCE, "true");
            } else {
                CVUVariables.setValue(CVUVariableConstants.MODE_HEALTH_CHECK, "true");
            }
        }
        catch (SRVMContextException e) {
            Trace.out((String)("exception occurred when initialzing adr:" + e.getMessage()));
            String errMsg = s_prvgMsgBundle.getMessage("1650", true) + LSEP + e.getMessage();
            ErrorDescription errDesc = new ErrorDescription(errMsg);
            this.m_resultSet.addResult(this.m_nodeList, 2);
            this.m_resultSet.addErrorDescription(this.m_nodeList, errDesc);
            ReportUtil.sureprintln(errMsg);
            return false;
        }
        retval = this.checkSetup();
        this.m_validNodeArr = this.getValidNodeList();
        if (null == this.m_validNodeArr) {
            return false;
        }
        switch (this.m_verificationType) {
            case COMPONENT_HEALTH_CHECK: {
                List<Task> taskList = null;
                try {
                    taskList = TaskFactory.getInstance().getTaskList(this.m_verificationType, this.m_validNodeArr, false);
                }
                catch (PreReqNotSupportedException e) {
                    Trace.out((Exception)e);
                    this.m_resultSet.addResult(this.m_validNodeArr, 2);
                    this.m_resultSet.addErrorDescription(this.m_validNodeArr, new ErrorDescription(e.getMessage()));
                    this.printError(e.getMessage() + LSEP + s_msgBundle.getMessage("0007", false) + LSEP);
                    return false;
                }
                catch (TaskFactoryException e) {
                    Trace.out((Exception)e);
                    this.m_resultSet.addResult(this.m_validNodeArr, 2);
                    this.m_resultSet.addErrorDescription(this.m_validNodeArr, new ErrorDescription(e.getCompleteMessage()));
                    this.printError(e.getCompleteMessage() + LSEP + s_msgBundle.getMessage("0007", false) + LSEP);
                    return false;
                }
                ReportUtil.setBaselineHealthcheck(true);
                ReportUtil.setOldFormat(true);
                retval &= this.verifyInternal(taskList);
                ReportUtil.setBaselineHealthcheck(false);
                ReportUtil.setOldFormat(false);
                if (VerificationUtil.isCVUResource()) {
                    retval &= this.writeErrorToGlobalAlertLog();
                }
                return retval;
            }
        }
        if (Trace.isTraceEnabled()) {
            Trace.out((String)"ERROR: Invalid Verification Type!");
        }
        return false;
    }

    private boolean verifyInternal(List<Task> taskList) {
        XmlReportTool xmlReportTool;
        String errorMsg;
        boolean retval;
        block68: {
            retval = true;
            errorMsg = null;
            xmlReportTool = null;
            this.m_details = new ReportUtilConstants.BasicClusterWareDetails();
            retval = this.performDiscovery();
            if (!retval) {
                ReportUtil.quietprintln(LSEP + s_msgBundle.getMessage("0007", false) + LSEP);
            }
            CVUVariables.setValue(CVUVariableConstants.SRC_CRS_HOME_VERSION, this.m_details.getClusterwareVersion());
            boolean saveReport = this.m_paramMgr.checkArgSave();
            String saveDirectory = CVUVariables.getValue(CVUVariableConstants.SAVE_DIR);
            if (VerificationUtil.isStringGood(saveDirectory)) {
                try {
                    Assert.assertWritableDir(saveDirectory);
                }
                catch (InvalidPathException ipe) {
                    Trace.out((Exception)ipe);
                    this.m_resultSet.addResult(this.m_validNodeArr, 2);
                    this.m_resultSet.addErrorDescription(this.m_validNodeArr, new ErrorDescription(ipe.getMessage()));
                    this.printError(ipe.getMessage() + LSEP + s_msgBundle.getMessage("0007", false) + LSEP);
                    return false;
                }
            }
            if (VerificationUtil.isCVUResource()) {
                saveReport = true;
                if (!VerificationUtil.isStringGood(saveDirectory)) {
                    try {
                        saveDirectory = ReportUtilConstants.getCvuBaselineXmlReportDefaultDirPathForCVUResource();
                    }
                    catch (ClusterException e) {
                        Trace.out((String)("Save directory for CVU resource could not be retrieved or created: " + e.getMessage()));
                        saveDirectory = null;
                    }
                }
            }
            try {
                xmlReportTool = new XmlReportTool();
                xmlReportTool.startDocument(saveDirectory, "cvucheckreport");
                xmlReportTool.addHeader(this.m_details);
                String product = CVUVariables.getValue(CVUVariableConstants.HEALTH_CHECK_COLLECT);
                for (Task t : taskList) {
                    if (t.isTypeTarget()) {
                        Target target = (Target)t;
                        target.setClearCache(false);
                        VerificationType vfyType = target.getTargetType();
                        Trace.out((String)("Performing target " + (Object)((Object)target.getTargetType())));
                        String version = this.m_details.getClusterwareVersion();
                        String[] versionComponents = version.split(Pattern.quote("."));
                        String majorNumber = versionComponents[0];
                        String minorNumber = "0".equals(versionComponents[1]) ? "1" : versionComponents[1];
                        String release = majorNumber + "." + minorNumber;
                        block6 : switch (vfyType) {
                            case PREREQ_CRS_INST: 
                            case PREREQ_APPLICATION_CLUSTER_INST: 
                            case BESTPRACTICE_PRE_CRS_INST: {
                                if (product != null && !CLSyntax.STR_CLUSTER.equals(product)) break;
                                ParamPreReq m_paramPreReq = new ParamPreReqCRSInst();
                                ((ParamPreReqCRSInst)m_paramPreReq).setORAINVgroup(VerificationUtil.getOraInventoryGroup());
                                ((ParamPreReqCRSInst)m_paramPreReq).setRelease(release);
                                switch (vfyType) {
                                    case PREREQ_CRS_INST: 
                                    case PREREQ_APPLICATION_CLUSTER_INST: {
                                        if (this.m_paramMgr.checkArgBestPractice()) break;
                                        switch (vfyType) {
                                            case PREREQ_CRS_INST: {
                                                if (!this.m_isApplicationCluster) {
                                                    retval &= this.verifyOSMandatoryChecks(target, version, (ParamPreReqCRSInst)m_paramPreReq, xmlReportTool);
                                                    break block6;
                                                }
                                                Trace.out((String)"Not performing OS mandatory checks for CRS install as this is an application cluster environment");
                                                break block6;
                                            }
                                            case PREREQ_APPLICATION_CLUSTER_INST: {
                                                if (this.m_isApplicationCluster) {
                                                    retval &= this.verifyOSMandatoryChecks(target, version, (ParamPreReqCRSInst)m_paramPreReq, xmlReportTool);
                                                    break block6;
                                                }
                                                Trace.out((String)"Skipping OS mandatory checks for application cluster as this is NOT an application cluster environment");
                                            }
                                        }
                                        break block6;
                                    }
                                    case BESTPRACTICE_PRE_CRS_INST: {
                                        if (this.m_paramMgr.checkArgMandatory()) break;
                                        retval &= this.verifyOSBestPractice(target, version, (ParamPreReqCRSInst)m_paramPreReq, xmlReportTool);
                                    }
                                }
                                break;
                            }
                            case POSTREQ_CRS_INST: 
                            case POSTREQ_SI_HA_CONFIG: 
                            case POSTREQ_APPLICATION_CLUSTER_INST: 
                            case BESTPRACTICE_POSTREQ_CRS_INST: 
                            case BESTPRACTICE_POSTREQ_SI_HA_CONFIG: {
                                if (!retval || product != null && !CLSyntax.STR_CLUSTER.equals(product)) break;
                                ParamPreReq m_paramPreReq = new ParamPreReqCRSInst();
                                ((ParamPreReqCRSInst)m_paramPreReq).setORAINVgroup(VerificationUtil.getOraInventoryGroup());
                                ((ParamPreReqCRSInst)m_paramPreReq).setRelease(release);
                                switch (vfyType) {
                                    case POSTREQ_CRS_INST: 
                                    case POSTREQ_SI_HA_CONFIG: 
                                    case POSTREQ_APPLICATION_CLUSTER_INST: {
                                        if (this.m_paramMgr.checkArgBestPractice()) break;
                                        this.checkIfNodeRolesSet();
                                        switch (vfyType) {
                                            case POSTREQ_CRS_INST: 
                                            case POSTREQ_SI_HA_CONFIG: {
                                                if (!this.m_isApplicationCluster) {
                                                    retval &= this.verifyClusterwareMandatoryChecks(target, version, (ParamPreReqCRSInst)m_paramPreReq, xmlReportTool);
                                                    break block6;
                                                }
                                                Trace.out((String)"Not performing the clusterware mandatory checks for CRS/HA post config as this is an application cluster environment");
                                                break block6;
                                            }
                                            case POSTREQ_APPLICATION_CLUSTER_INST: {
                                                if (this.m_isApplicationCluster) {
                                                    ParamPreReqAppCluster appClusterParamPreReq = new ParamPreReqAppCluster();
                                                    retval &= this.verifyApplicationClusterChecks(target, version, appClusterParamPreReq, xmlReportTool);
                                                    break block6;
                                                }
                                                Trace.out((String)"Not performing the clusterware mandatory checks for post application cluster config as this is NOT an application cluster environment");
                                            }
                                        }
                                        break block6;
                                    }
                                    case BESTPRACTICE_POSTREQ_CRS_INST: 
                                    case BESTPRACTICE_POSTREQ_SI_HA_CONFIG: {
                                        if (this.m_paramMgr.checkArgMandatory()) break;
                                        retval &= this.verifyClusterwareBestPractice(target, version, (ParamPreReqCRSInst)m_paramPreReq, xmlReportTool);
                                    }
                                }
                                break;
                            }
                            case COMPONENT_ASM_INTEGRITY: 
                            case BESTPRACTICE_ASM: {
                                if (!retval || CLSyntax.STR_DATABASE.equals(product)) break;
                                ParamPreReq m_paramPreReq = new ParamPreReqUSMConfig();
                                ((ParamPreReqUSMConfig)m_paramPreReq).setRelease(release);
                                switch (vfyType) {
                                    case COMPONENT_ASM_INTEGRITY: {
                                        if (this.m_paramMgr.checkArgBestPractice()) break;
                                        this.checkIfNodeRolesSet();
                                        retval &= this.verifyASMMandatoryChecks(target, (ParamPreReqUSMConfig)m_paramPreReq, xmlReportTool);
                                        break block6;
                                    }
                                    case BESTPRACTICE_ASM: {
                                        if (this.m_paramMgr.checkArgMandatory()) break;
                                        if (this.m_asmRunning) {
                                            retval &= this.verifyASMBestPractice(target, (ParamPreReqUSMConfig)m_paramPreReq, xmlReportTool);
                                            break block6;
                                        }
                                        if (!CLSyntax.STR_ASM.equals(product) || CVUHelperUtil.isASMFar()) break;
                                        String errMsg = LSEP + s_prvgMsgBundle.getMessage("12993", true);
                                        if (VerificationUtil.isStringGood(this.m_asmNotRunningMsg)) {
                                            errMsg = errMsg + LSEP + this.m_asmNotRunningMsg;
                                        }
                                        ReportUtil.quietprintln(errMsg);
                                    }
                                }
                                break;
                            }
                            case COMPONENT_FREE_SPACE: {
                                retval &= this.verifyCRSHomeFreeSpace(target);
                                break;
                            }
                            case BESTPRACTICE_POSTREQ_DB_CONFIG: 
                            case POSTREQ_DB_CONFIG: {
                                if ((!retval || this.m_isApplicationCluster || product != null && !CLSyntax.STR_DATABASE.equals(product)) && !VerificationUtil.isCVUResource()) break;
                                Vector<ReportUtilConstants.DatabaseDetails> databaseList = this.m_details.getDatabases();
                                Vector<ReportUtilConstants.DatabaseDetails> failedDatabase = new Vector<ReportUtilConstants.DatabaseDetails>();
                                boolean databaseResult = true;
                                block48: for (ReportUtilConstants.DatabaseDetails databaseDtails : databaseList) {
                                    if (!this.updateDatabaseConnectionInfo(databaseDtails)) continue;
                                    switch (target.getTargetType()) {
                                        case BESTPRACTICE_POSTREQ_DB_CONFIG: {
                                            if (this.m_paramMgr.checkArgMandatory()) break;
                                            databaseResult = this.verifyDatabaseChecks(target, databaseDtails, xmlReportTool);
                                            break;
                                        }
                                        case POSTREQ_DB_CONFIG: {
                                            if (this.m_paramMgr.checkArgBestPractice()) break;
                                            databaseResult = this.verifyDatabaseChecks(target, databaseDtails, xmlReportTool);
                                            break;
                                        }
                                        default: {
                                            continue block48;
                                        }
                                    }
                                    if (!databaseResult) {
                                        failedDatabase.add(databaseDtails);
                                    }
                                    retval &= databaseResult;
                                }
                                this.m_details.getDatabases().removeAll(failedDatabase);
                            }
                        }
                        continue;
                    }
                    Trace.out((String)"This is not a target, but a task. Performing it.");
                    ArrayList<Task> tList = new ArrayList<Task>();
                    tList.add(t);
                    retval &= this.verifyTaskList(tList);
                }
                xmlReportTool.endDocument();
                boolean displayHTML = this.m_paramMgr.checkArgHTML();
                if (displayHTML && !VerificationUtil.isDisplayEnabled()) {
                    displayHTML = false;
                    if (!saveReport) {
                        String msg = s_prvgMsgBundle.getMessage("0221", true);
                        this.printError(msg);
                        ReportUtil.quietblankln();
                        saveReport = true;
                    }
                }
                if (this.m_paramMgr.checkArgHTML()) {
                    try {
                        xmlReportTool.xmlToHtml(s_prvgMsgBundle.getMessage("0211", false), s_prvgMsgBundle.getMessage("0212", false), this.m_paramMgr.checkArgDeviations(), HtmlConstants.Colors.WhiteSmoke, ReportUtilConstants.ReportContext.BEST_PRACTICE, displayHTML, VerificationUtil.getConfiguredValue("CV_DEFAULT_BROWSER_LOCATION", true), saveReport, saveDirectory);
                    }
                    catch (HtmlBrowserException e) {
                        if (saveReport) break block68;
                        try {
                            displayHTML = false;
                            xmlReportTool.xmlToHtml(s_prvgMsgBundle.getMessage("0211", false), s_prvgMsgBundle.getMessage("0212", false), this.m_paramMgr.checkArgDeviations(), HtmlConstants.Colors.WhiteSmoke, ReportUtilConstants.ReportContext.BEST_PRACTICE, displayHTML, VerificationUtil.getConfiguredValue("CV_DEFAULT_BROWSER_LOCATION", true), saveReport, saveDirectory);
                            break block68;
                        }
                        catch (HtmlBrowserException e1) {
                            Trace.out((String)("Ignored Exception:" + e1.getClass() + ":" + errorMsg));
                        }
                    }
                    break block68;
                }
                xmlReportTool.xmlToText(ReportUtilConstants.ReportContext.BEST_PRACTICE, this.m_paramMgr.checkArgDeviations(), saveReport, saveDirectory, !this.m_paramMgr.checkArgHTML());
            }
            catch (XmlReportToolException e) {
                errorMsg = e.getMessage();
                Trace.out((String)("Caught Exception:" + e.getClass() + ":" + errorMsg));
                retval = false;
            }
            catch (ParserConfigurationException e) {
                errorMsg = e.getMessage();
                Trace.out((String)("Caught Exception:" + e.getClass() + ":" + errorMsg));
                retval = false;
            }
            catch (HtmlReportToolException e) {
                errorMsg = e.getMessage();
                Trace.out((String)("Caught Exception:" + e.getClass() + ":" + errorMsg));
                retval = false;
            }
            catch (XmlFilePathException e) {
                errorMsg = e.getMessage();
                Trace.out((String)("Caught Exception:" + e.getClass() + ":" + errorMsg));
                retval = false;
            }
            catch (ReportToolException e) {
                errorMsg = e.getMessage();
                Trace.out((String)("Caught Exception:" + e.getClass() + ":" + errorMsg));
                retval = false;
            }
        }
        if (VerificationUtil.isCVUResource()) {
            try {
                ArrayList<String> m_nodeListWithoutLocalNode = new ArrayList<String>();
                m_nodeListWithoutLocalNode.addAll(Arrays.asList(this.m_nodeList));
                m_nodeListWithoutLocalNode.remove(VerificationUtil.getLocalNode());
                if (m_nodeListWithoutLocalNode.size() > 0) {
                    String removeDir = ReportUtilConstants.getCvuBaselineXmlReportDefaultDirPathForCVUResource();
                    Trace.out((String)("trimming files in " + removeDir + " directory"));
                    NativeSystem nativeSystem = new SystemFactory().CreateSystem();
                    String cmd = nativeSystem.isUnixSystem() ? VerificationUtil.getCVUSubDirPath() + "remove_cvuresource_baseline.sh " + removeDir : VerificationUtil.getCVUSubDirPath() + "remove_cvuresource_baseline.bat " + removeDir;
                    Trace.out((String)(" command to be run " + cmd));
                    GlobalExecution globalExec = new GlobalExecution();
                    boolean rslt = false;
                    ResultSet usrInfoRsltSet = new ResultSet();
                    rslt = globalExec.runExe(m_nodeListWithoutLocalNode.toArray(new String[0]), cmd, usrInfoRsltSet, false);
                    usrInfoRsltSet.traceResultSet("Results from deleting baseline xml files");
                    String xmlFilePath = xmlReportTool.getXMLFilePath();
                    new ClusterCmd().copyFileToNodes(xmlFilePath, m_nodeListWithoutLocalNode.toArray(new String[0]));
                }
            }
            catch (ClusterException e) {
                this.printWarning(s_prvgMsgBundle.getMessage("11644", true, (Object[])new String[]{e.getMessage()}) + LSEP);
            }
        } else {
            Trace.out((int)5, (String)"Deleting xml file %s after comp healthcheck report has been generated", (Object[])new Object[]{xmlReportTool.getXMLFilePath()});
            new File(xmlReportTool.getXMLFilePath()).delete();
        }
        if (!retval && VerificationUtil.isStringGood(errorMsg)) {
            this.reportFailure(errorMsg + LSEP + s_msgBundle.getMessage("0007", false) + LSEP);
        }
        return retval;
    }

    private boolean verifyTaskList(List<Task> taskList) {
        boolean retval = true;
        ArrayList<Task> taskListToVerify = new ArrayList<Task>();
        try {
            for (Task task : taskList) {
                if (task.hasSubtasks()) {
                    List<VerificationTask> subTaskList = task.getSubtasks();
                    for (VerificationTask st : subTaskList) {
                        taskListToVerify.add((Task)st);
                    }
                    continue;
                }
                taskListToVerify.add(task);
            }
            taskList.clear();
            taskList.addAll(taskListToVerify);
            for (Task task : taskList) {
                task.verify();
                this.m_taskReportList.add(task);
                Trace.out((String)("\n>>>> Upload Task=" + task.getElementName() + "results >>>>>\n"));
                this.m_resultSet.uploadResultSet(task.getResultSet());
                this.printTaskSummary(task);
            }
            ReportUtil.quietblankln();
        }
        catch (SubtasksUnavailableException e) {
            Trace.out((Exception)e);
            this.m_resultSet.addResult(this.m_validNodeArr, 2);
            this.m_resultSet.addErrorDescription(this.m_validNodeArr, new ErrorDescription(e.getMessage()));
            this.printError(e.getMessage());
            return false;
        }
        catch (SubtasksNotCompleteException e) {
            Trace.out((Exception)e);
            this.m_resultSet.addResult(this.m_validNodeArr, 2);
            this.m_resultSet.addErrorDescription(this.m_validNodeArr, new ErrorDescription(e.getMessage()));
            this.printError(e.getMessage());
            return false;
        }
        catch (VerificationException e) {
            Trace.out((Exception)e);
            this.m_resultSet.addResult(this.m_validNodeArr, 2);
            this.m_resultSet.addErrorDescription(this.m_validNodeArr, new ErrorDescription(e.getMessage()));
            this.printError(e.getMessage());
            return false;
        }
        return retval;
    }

    private void printTaskSummary(Task task) {
        boolean isTaskCritical;
        if (this.m_paramMgr.checkArgDeviations() && task.getResultSet().allSuccess() && !task.getResultSet().anyWarning()) {
            return;
        }
        String msg = s_prvgMsgBundle.getMessage("0207", false, (Object[])new String[]{task.getElementName()});
        String overAllStatus = task.getResultSet().getOverallStatus().name();
        String overAllStatusText = null;
        boolean isTaskMandatory = !task.isBestPractice();
        boolean showFailuresOnly = this.m_paramMgr.checkArgDeviations();
        boolean bl = isTaskCritical = SeverityType.CRITICAL.equals((Object)task.getSeverity()) || SeverityType.FATAL.equals((Object)task.getSeverity());
        overAllStatusText = VerificationUtil.isStringGood(overAllStatus) && overAllStatus.toLowerCase().contains("success") ? (isTaskMandatory ? s_prveMsgBundle.getMessage("10030", false) : s_prveMsgBundle.getMessage("10034", false)) : (VerificationUtil.isStringGood(overAllStatus) && overAllStatus.toLowerCase().contains("warning") ? (isTaskMandatory ? s_prveMsgBundle.getMessage("10032", false) : s_prveMsgBundle.getMessage("10035", false)) : (VerificationUtil.isStringGood(overAllStatus) && overAllStatus.toLowerCase().contains("failed") ? (isTaskCritical ? s_prveMsgBundle.getMessage("10031", false) : (isTaskMandatory && !isTaskCritical ? s_prveMsgBundle.getMessage("10032", false) : (overAllStatus.toLowerCase().contains("verification") ? s_prveMsgBundle.getMessage("10035", false) : s_prveMsgBundle.getMessage("10069", false)))) : s_prveMsgBundle.getMessage("10033", false)));
        ReportUtil.quietprintln(msg + overAllStatusText.toLowerCase());
    }

    private boolean performDiscovery() {
        String gridHome = null;
        boolean retval = true;
        String clusterwareVersion = null;
        Version clusterwareVersionObject = null;
        this.m_details.setOsPlatform(VerificationUtil.getOperatingSystemName());
        String param = CVUVariables.getValue(CVUVariableConstants.HEALTH_CHECK_COLLECT);
        String localNode = VerificationUtil.getLocalNode();
        boolean haConfigured = VerificationUtil.isHAConfigured();
        if (haConfigured) {
            gridHome = VerificationUtil.getHAHome();
            clusterwareVersion = VerificationUtil.getSIHAReleaseVersion();
            clusterwareVersionObject = VerificationUtil.getSIHAReleaseVersionObj();
        } else {
            gridHome = VerificationUtil.getCRSHome();
            clusterwareVersion = VerificationUtil.getCRSSoftwareVersion(localNode);
            clusterwareVersionObject = VerificationUtil.getCRSSoftwareVersionObj();
        }
        if (gridHome == null) {
            String cause = s_msgBundle.getMessage("5301", false);
            ReportUtil.quietprintln(VerificationConstants.LSEP + ReportUtil.ERROR + VerificationConstants.LSEP + cause);
            ReportUtil.quietprintln(LSEP + s_msgBundle.getMessage("0007", false) + LSEP);
            return false;
        }
        if (clusterwareVersion == null) {
            String cause = s_msgBundle.getMessage("5434", true);
            ReportUtil.quietprintln(VerificationConstants.LSEP + ReportUtil.ERROR + VerificationConstants.LSEP + cause);
            ReportUtil.quietprintln(LSEP + s_msgBundle.getMessage("0007", false) + LSEP);
            return false;
        }
        this.m_dbUtils = new DBUtils(clusterwareVersionObject);
        Result result = new Result(localNode);
        String crsUser = VerificationUtil.getCRSUser(result, haConfigured);
        if (crsUser != null) {
            this.m_details.setCrsUserName(crsUser);
        }
        ClusterwareInfo clusterwareInfo = new ClusterwareInfo();
        this.m_details.setClusterwareVersion(clusterwareVersion);
        this.m_details.setCrsHome(gridHome);
        CollectionResult<String> oracleBaseCR = ClusterwareUtil.getOracleBase(localNode, gridHome);
        if (oracleBaseCR.getNodeResultStatus() == NodeResultStatus.SUCCESSFUL) {
            try {
                this.m_details.setOracleBase(oracleBaseCR.getCollectedValue());
            }
            catch (CollectionValueUnavailableException e) {
                Trace.out((Exception)e);
            }
        }
        if (!haConfigured) {
            try {
                String clusterName = clusterwareInfo.getClusterName(gridHome, clusterwareVersionObject);
                if (clusterName != null) {
                    this.m_details.setClusterName(clusterName);
                }
            }
            catch (InstallException e) {
                Trace.out((Exception)((Object)e));
                this.m_resultSet.addResult(this.m_validNodeArr, 2);
                String errMsg = e.getMessage();
                this.m_resultSet.addErrorDescription(new ErrorDescription(errMsg));
            }
        }
        try {
            if (param == null || CLSyntax.STR_DATABASE.equals(param)) {
                String dbName = CVUVariables.getValue(CVUVariableConstants.HEALTH_CHECK_DB);
                if (dbName != null) {
                    this.performDatabaseDiscovery(dbName);
                } else {
                    String[] dbNameList;
                    for (String dbNameStr : dbNameList = this.m_dbUtils.getDatabases()) {
                        this.performDatabaseDiscovery(dbNameStr);
                    }
                }
            }
        }
        catch (DBUtilsException e) {
            Trace.out((Exception)e);
            this.printError(e.getMessage());
            this.printError(LSEP + s_prvgMsgBundle.getMessage("0213", true) + LSEP);
        }
        if (!(CVUHelperUtil.isASMFar() || param != null && CLSyntax.STR_DATABASE.equals(param))) {
            ArrayList<String> runningNodeList;
            block22: {
                runningNodeList = new ArrayList<String>();
                ArrayList<String> failedNodeList = new ArrayList<String>();
                ASMDiskGroupsUtil asmdg = new ASMDiskGroupsUtil();
                try {
                    Trace.out((String)"checking if asm is running");
                    asmdg.checkASMRunning(this.m_nodeList, runningNodeList, failedNodeList);
                }
                catch (ASMDiskGroupsUtilException e) {
                    Trace.out((String)("ASMDG exception while checking for asm " + e.getMessage()));
                    if (param == null || !CLSyntax.STR_ASM.equals(param)) break block22;
                    Object[] args = new String[]{VerificationUtil.strArr2List(this.m_nodeList)};
                    this.m_asmNotRunningMsg = s_prvgMsgBundle.getMessage("1008", true, args) + LSEP + e.getMessage() + LSEP;
                }
            }
            if (runningNodeList.size() >= 1) {
                this.m_asmRunning = true;
            }
        }
        return retval;
    }

    private boolean performDatabaseDiscovery(String dbName) {
        try {
            DatabaseInfo database = this.m_dbUtils.getDatabaseInfo(dbName);
            String dbHome = database.getHome();
            Version dbVersion = database.getVersion();
            this.m_details.addDatabaseDetails(dbName, dbHome, dbVersion.toString());
        }
        catch (DBUtilsException e) {
            Trace.out((Exception)e);
            this.m_resultSet.addResult(this.m_validNodeArr, 2);
            String msg = e.getMessage();
            if (VerificationUtil.isStringGood(msg)) {
                this.m_resultSet.addErrorDescription(this.m_validNodeArr, new ErrorDescription(msg));
                this.printError(msg + LSEP);
            }
            return false;
        }
        return true;
    }

    private boolean verifyCRSHomeFreeSpace(Target target) {
        boolean retval = false;
        try {
            Trace.out((String)"checking free space of crshome file system");
            String msg = s_prvgMsgBundle.getMessage("11107", false, (Object[])new String[]{this.m_details.getCrsHome()});
            FreeSpaceComponent freespaceComp = new FreeSpaceComponent(this.m_verificationType);
            retval = freespaceComp.verify();
            ResultSet freeSpaceRS = freespaceComp.getResultSet();
            String overAllStatusText = null;
            if (freeSpaceRS.allSuccess()) {
                overAllStatusText = s_prveMsgBundle.getMessage("10030", false);
                this.m_isSpaceAlert = false;
                String succMsg = s_prvgMsgBundle.getMessage("11108", false, (Object[])new String[]{this.m_details.getCrsHome()});
                Trace.out((String)succMsg);
                if (!this.m_paramMgr.checkArgDeviations()) {
                    ReportUtil.quietprintln(msg + "..." + overAllStatusText.toLowerCase());
                }
            } else {
                overAllStatusText = s_prveMsgBundle.getMessage("10031", false);
                this.m_isSpaceAlert = true;
                List<String> errList = this.getErrorMsgList(freeSpaceRS);
                this.m_spaceAlertMsgArr = errList.toArray(new String[0]);
                ReportUtil.quietprintln(msg + "..." + overAllStatusText.toLowerCase());
            }
            if (this.m_isSpaceAlert) {
                ReportUtil.quietprintln(VerificationUtil.strArr2List(this.m_spaceAlertMsgArr));
            }
            if (!VerificationUtil.isCVUResource()) {
                this.m_resultSet.uploadResultSet(freeSpaceRS);
            }
        }
        catch (ComponentInitException e) {
            Trace.out((String)("couldn't perform crs home free space check " + e.getMessage()));
            ErrorDescription errDesc = new ErrorDescription(e.getMessage());
            this.m_resultSet.addResult(this.m_validNodeArr, 2);
            this.m_resultSet.addErrorDescription(errDesc);
        }
        return retval;
    }

    private boolean verifyClusterwareMandatoryChecks(Target target, String version, ParamPreReqCRSInst m_paramPreReq, XmlReportTool xmlReportTool) {
        boolean retval = true;
        try {
            String contextMsg = s_prvgMsgBundle.getMessage("0216", false);
            ReportUtil.quietblankln();
            ReportUtil.quietprintln(contextMsg);
            ReportUtil.quietblankln();
            List<Task> taskList = target.getTaskList(this.m_validNodeArr, m_paramPreReq);
            if (taskList.size() <= 0) {
                ReportUtil.quietprintln(s_prveMsgBundle.getMessage("3133", false, (Object[])new String[]{version}));
            } else {
                for (Task taskItem : taskList) {
                    if (!taskItem.getDefaultTaskID().equals(new TaskCTSSIntegrity(new VerificationTaskContext(this.m_validNodeArr)).getDefaultTaskID())) continue;
                    if (this.m_details.getDatabaseCount() <= 0) break;
                    Trace.out((String)"add slewing option to CTSSIntegrity task.");
                    ((TaskCTSSIntegrity)taskItem).setEnableDBChecks();
                    break;
                }
                if (!(retval &= this.verifyTaskList(taskList))) {
                    this.printError(LSEP + s_msgBundle.getMessage("0007", false) + LSEP);
                    return false;
                }
            }
            xmlReportTool.addTarget(target.getTargetType(), taskList, (String)null, (String)null, (String)null);
        }
        catch (TaskFactoryException e) {
            Trace.out((Exception)e);
            this.m_resultSet.addResult(this.m_validNodeArr, 2);
            this.m_resultSet.addErrorDescription(this.m_validNodeArr, new ErrorDescription(e.getCompleteMessage()));
            this.printError(e.getCompleteMessage() + LSEP + s_msgBundle.getMessage("0007", false) + LSEP);
            return false;
        }
        catch (VerificationException e) {
            Trace.out((Exception)e);
            this.m_resultSet.addResult(this.m_validNodeArr, 2);
            String msg = e.getMessage();
            if (VerificationUtil.isStringGood(msg)) {
                this.m_resultSet.addErrorDescription(this.m_validNodeArr, new ErrorDescription(msg));
                this.printError(msg + LSEP);
            }
            this.printError(s_msgBundle.getMessage("0007", false) + LSEP);
            return false;
        }
        catch (TransformerException e) {
            Trace.out((Exception)e);
            this.m_resultSet.addResult(this.m_validNodeArr, 2);
            String msg = e.getMessage();
            if (VerificationUtil.isStringGood(msg)) {
                this.m_resultSet.addErrorDescription(this.m_validNodeArr, new ErrorDescription(msg));
                this.printError(msg + LSEP);
            }
            this.printError(s_msgBundle.getMessage("0007", false) + LSEP);
            return false;
        }
        catch (XmlReportToolException e) {
            Trace.out((Exception)e);
            this.m_resultSet.addResult(this.m_validNodeArr, 2);
            String msg = e.getMessage();
            if (VerificationUtil.isStringGood(msg)) {
                this.m_resultSet.addErrorDescription(this.m_validNodeArr, new ErrorDescription(msg));
                this.printError(msg + LSEP);
            }
            this.printError(s_msgBundle.getMessage("0007", false) + LSEP);
            return false;
        }
        return retval;
    }

    private boolean verifyClusterwareBestPractice(Target target, String version, ParamPreReqCRSInst m_paramPreReq, XmlReportTool xmlReportTool) {
        boolean retval = true;
        if (this.m_isApplicationCluster) {
            ReportUtil.quietprintln(s_prveMsgBundle.getMessage("3158", false, (Object[])new String[]{version}));
            return retval;
        }
        m_paramPreReq.setORAINVgroup(VerificationUtil.getOraInventoryGroup());
        String[] versionComponents = version.split(Pattern.quote("."));
        String majorNumber = versionComponents[0];
        String minorNumber = "0".equals(versionComponents[1]) ? "1" : versionComponents[1];
        String release = majorNumber + "." + minorNumber;
        m_paramPreReq.setRelease(release);
        try {
            String contextMsg = s_prvgMsgBundle.getMessage("0209", false);
            ReportUtil.quietblankln();
            ReportUtil.quietprintln(contextMsg);
            ReportUtil.quietblankln();
            List<Task> taskList = target.getTaskList(this.m_validNodeArr, m_paramPreReq);
            if (taskList.size() <= 0) {
                ReportUtil.quietprintln(s_prveMsgBundle.getMessage("3134", false, (Object[])new String[]{version}));
            } else if (!(retval &= this.verifyTaskList(taskList))) {
                this.printError(LSEP + s_msgBundle.getMessage("0007", false) + LSEP);
                return false;
            }
            xmlReportTool.addTarget(target.getTargetType(), taskList, (String)null, (String)null, (String)null);
        }
        catch (TaskFactoryException e) {
            Trace.out((Exception)e);
            this.m_resultSet.addResult(this.m_validNodeArr, 2);
            this.m_resultSet.addErrorDescription(this.m_validNodeArr, new ErrorDescription(e.getCompleteMessage()));
            this.printError(e.getCompleteMessage() + LSEP + s_msgBundle.getMessage("0007", false) + LSEP);
            return false;
        }
        catch (VerificationException e) {
            Trace.out((Exception)e);
            this.m_resultSet.addResult(this.m_validNodeArr, 2);
            String msg = e.getMessage();
            if (VerificationUtil.isStringGood(msg)) {
                this.m_resultSet.addErrorDescription(this.m_validNodeArr, new ErrorDescription(msg));
                this.printError(msg + LSEP);
            }
            this.printError(s_msgBundle.getMessage("0007", false) + LSEP);
            return false;
        }
        catch (TransformerException e) {
            Trace.out((Exception)e);
            this.m_resultSet.addResult(this.m_validNodeArr, 2);
            String msg = e.getMessage();
            if (VerificationUtil.isStringGood(msg)) {
                this.m_resultSet.addErrorDescription(this.m_validNodeArr, new ErrorDescription(msg));
                this.printError(msg + LSEP);
            }
            this.printError(s_msgBundle.getMessage("0007", false) + LSEP);
            return false;
        }
        catch (XmlReportToolException e) {
            Trace.out((Exception)e);
            this.m_resultSet.addResult(this.m_validNodeArr, 2);
            String msg = e.getMessage();
            if (VerificationUtil.isStringGood(msg)) {
                this.m_resultSet.addErrorDescription(this.m_validNodeArr, new ErrorDescription(msg));
                this.printError(msg + LSEP);
            }
            this.printError(s_msgBundle.getMessage("0007", false) + LSEP);
            return false;
        }
        return retval;
    }

    private boolean updateDatabaseConnectionInfo(ReportUtilConstants.DatabaseDetails databaseDtails) {
        String database = databaseDtails.getDatabaseName();
        if (DatabaseConnectInfo.getDBConnectInfo(database) != null) {
            return true;
        }
        String userName = "DBSNMP";
        String password = null;
        String portStr = null;
        int port = 1521;
        String dbConnectDescr = null;
        ResultSet locrs = new ResultSet();
        String dbHome = databaseDtails.getDatabaseHome();
        String dbVersion = databaseDtails.getDatabaseVersion();
        try {
            boolean bPortReq = this.m_dbUtils.isPortRequiredForConnect(database);
            DatabaseConnectInfo dbConnInfo = null;
            if (VerificationUtil.isOTN()) {
                ConsoleUtil consoleUtil = new ConsoleUtil();
                if (bPortReq) {
                    String portPrompt = s_prvgMsgBundle.getMessage("11152", false, (Object[])new String[]{database});
                    portStr = consoleUtil.read(portPrompt);
                    try {
                        if (portStr == null || portStr.length() == 0) {
                            port = 1521;
                        }
                        port = Integer.parseInt(portStr);
                    }
                    catch (NumberFormatException e) {
                        Trace.out((String)("Invalid port. " + portStr + e.getMessage()));
                        Trace.out((String)"using dafault port 1521");
                        port = 1521;
                    }
                    dbConnectDescr = this.m_dbUtils.getConnectDescriptor(database, port);
                } else {
                    dbConnectDescr = this.m_dbUtils.getConnectDescriptor(database);
                }
                String userNamePrompt = s_prvgMsgBundle.getMessage("11151", false, (Object[])new String[]{database, userName});
                userName = consoleUtil.read(userNamePrompt);
                if (userName == null || userName.length() == 0) {
                    userName = "DBSNMP";
                }
                String passwordPrompt = s_prvgMsgBundle.getMessage("11150", false, (Object[])new String[]{userName, database});
                for (int nPasswdAtmts = 0; nPasswdAtmts < 3; ++nPasswdAtmts) {
                    try {
                        password = new String(consoleUtil.readPassword(passwordPrompt));
                        this.testCreds(dbConnectDescr, userName, password);
                        break;
                    }
                    catch (DBConnectionException e) {
                        String errMsg = e.getMessage();
                        Trace.out((String)("got DBConnectionException. mesg: " + errMsg));
                        if (!errMsg.contains(DB_CREDENTIAL_OERR)) {
                            throw e;
                        }
                        passwordPrompt = s_prvgMsgBundle.getMessage("11153", false, (Object[])new String[]{userName, database});
                        continue;
                    }
                }
            } else {
                password = HeavyWeightVerificationUtil.getDBPassword(database, userName, locrs);
                if (locrs.getResult(database).getStatus() == 3) {
                    return false;
                }
            }
            if (bPortReq) {
                dbConnectDescr = this.m_dbUtils.getConnectDescriptor(databaseDtails.getDatabaseName(), port);
                dbConnInfo = new DatabaseConnectInfo(database, userName, password, port);
            } else {
                dbConnectDescr = this.m_dbUtils.getConnectDescriptor(database);
                dbConnInfo = new DatabaseConnectInfo(database, userName, password);
            }
            this.testCreds(dbConnectDescr, userName, password);
            DatabaseConnectInfo.addDBConnectInfo(dbConnInfo);
        }
        catch (ConsoleUtilException e) {
            this.m_resultSet.addResult(this.m_validNodeArr, 2);
            String msg = e.getMessage();
            if (VerificationUtil.isStringGood(msg)) {
                this.m_resultSet.addErrorDescription(this.m_validNodeArr, new ErrorDescription(msg));
                this.printError(msg + LSEP);
            }
            return false;
        }
        catch (DBConnectionException e) {
            String msg = e.getMessage();
            if (msg.contains(DB_CREDENTIAL_OERR)) {
                this.m_resultSet.addResult(this.m_validNodeArr, 4);
                this.m_resultSet.addErrorDescription(this.m_validNodeArr, new ErrorDescription(msg));
                String errorMessage = s_prvgMsgBundle.getMessage("0219", true, (Object[])new String[]{databaseDtails.getDatabaseName(), userName});
                this.printWarning(errorMessage);
                return false;
            }
            this.m_resultSet.addResult(this.m_validNodeArr, 2);
            this.m_resultSet.addErrorDescription(this.m_validNodeArr, new ErrorDescription(msg));
            String errorMessage = s_prvgMsgBundle.getMessage("0222", true, (Object[])new String[]{databaseDtails.getDatabaseName(), userName});
            this.printError(errorMessage + LSEP + msg + LSEP);
            return false;
        }
        catch (DBUtilsException e) {
            this.m_resultSet.addResult(this.m_validNodeArr, 2);
            String msg = e.getMessage();
            if (VerificationUtil.isStringGood(msg)) {
                this.m_resultSet.addErrorDescription(this.m_validNodeArr, new ErrorDescription(msg));
                this.printError(msg + LSEP);
            }
            this.printError(s_msgBundle.getMessage("0007", false) + LSEP);
            return false;
        }
        catch (CVUException cvuEx) {
            this.m_resultSet.addResult(this.m_validNodeArr, 2);
            String msg = cvuEx.getMessage();
            Trace.out((String)("CVUException occured: msg" + msg));
            if (VerificationUtil.isStringGood(msg)) {
                this.m_resultSet.addErrorDescription(this.m_validNodeArr, new ErrorDescription(msg));
                this.printError(msg + LSEP);
            }
            this.printError(s_msgBundle.getMessage("0007", false) + LSEP);
            return false;
        }
        CVUVariables.setValue(CVUVariableConstants.ORACLE_HOME, dbHome);
        CVUVariables.setValue(CVUVariableConstants.SRC_RAC_HOME_VERSION, dbVersion);
        CVUVariables.setValue(CVUVariableConstants.DB_NAME, database);
        return true;
    }

    private boolean verifyDatabaseChecks(Target target, ReportUtilConstants.DatabaseDetails databaseDtails, XmlReportTool xmlReportTool) {
        String dbHome = databaseDtails.getDatabaseHome();
        String dbVersion = databaseDtails.getDatabaseVersion();
        ParamPreReqDBConfig m_paramPreReq = new ParamPreReqDBConfig(dbHome);
        m_paramPreReq.setOraInv(VerificationUtil.getOraInventoryGroup());
        String[] versionComponents = dbVersion.split(Pattern.quote("."));
        String majorNumber = versionComponents[0];
        String minorNumber = "0".equals(versionComponents[1]) ? "1" : versionComponents[1];
        String release = majorNumber + "." + minorNumber;
        m_paramPreReq.setRelease(release);
        boolean retval = true;
        switch (target.getTargetType()) {
            case BESTPRACTICE_POSTREQ_DB_CONFIG: {
                if (this.m_paramMgr.checkArgMandatory()) break;
                retval &= this.verifyDatabaseBestPractice(target, databaseDtails, m_paramPreReq, xmlReportTool);
                break;
            }
            case POSTREQ_DB_CONFIG: {
                if (this.m_paramMgr.checkArgBestPractice()) break;
                retval &= this.verifyDatabaseMandatoryChecks(target, databaseDtails, m_paramPreReq, xmlReportTool);
            }
        }
        return retval;
    }

    private boolean verifyDatabaseMandatoryChecks(Target target, ReportUtilConstants.DatabaseDetails databaseDtails, ParamPreReqDBConfig m_paramPreReq, XmlReportTool xmlReportTool) {
        boolean retval = true;
        try {
            String contextMsg = s_prvgMsgBundle.getMessage("0217", false, (Object[])new String[]{databaseDtails.getDatabaseName()});
            ReportUtil.quietblankln();
            ReportUtil.quietprintln(contextMsg);
            ReportUtil.quietblankln();
            List<Task> taskList = target.getTaskList(this.m_validNodeArr, m_paramPreReq);
            if (taskList.size() <= 0) {
                ReportUtil.quietprintln(s_prveMsgBundle.getMessage("3131", false));
            } else {
                for (Task taskItem : taskList) {
                    if (!(taskItem instanceof TaskSoftwareDistribution)) continue;
                    String home = ((TaskSoftwareDistribution)taskItem).getSoftwareComponentHome();
                    if (this.databaseHomeSoftwareVerifiedList.contains(home)) {
                        Trace.out((int)5, (String)"Home %s already verified, skipping software check", (Object[])new Object[]{home});
                        taskList.remove(taskItem);
                        break;
                    }
                    this.databaseHomeSoftwareVerifiedList.add(home);
                    break;
                }
                if (!(retval &= this.verifyTaskList(taskList))) {
                    this.printError(LSEP + s_msgBundle.getMessage("0007", false) + LSEP);
                    return false;
                }
            }
            xmlReportTool.addTarget(target.getTargetType(), taskList, (String)null, databaseDtails.getDatabaseName(), databaseDtails.getDatabaseHome());
        }
        catch (TaskFactoryException e) {
            Trace.out((Exception)e);
            this.m_resultSet.addResult(this.m_validNodeArr, 2);
            this.m_resultSet.addErrorDescription(this.m_validNodeArr, new ErrorDescription(e.getCompleteMessage()));
            this.printError(e.getCompleteMessage() + LSEP);
            return false;
        }
        catch (VerificationException e) {
            Trace.out((Exception)e);
            this.m_resultSet.addResult(this.m_validNodeArr, 2);
            String msg = e.getMessage();
            if (VerificationUtil.isStringGood(msg)) {
                this.m_resultSet.addErrorDescription(this.m_validNodeArr, new ErrorDescription(msg));
                this.printError(msg + LSEP);
            }
            return false;
        }
        catch (TransformerException e) {
            Trace.out((Exception)e);
            this.m_resultSet.addResult(this.m_validNodeArr, 2);
            String msg = e.getMessage();
            if (VerificationUtil.isStringGood(msg)) {
                this.m_resultSet.addErrorDescription(this.m_validNodeArr, new ErrorDescription(msg));
                this.printError(msg + LSEP);
            }
            return false;
        }
        catch (XmlReportToolException e) {
            Trace.out((Exception)e);
            this.m_resultSet.addResult(this.m_validNodeArr, 2);
            String msg = e.getMessage();
            if (VerificationUtil.isStringGood(msg)) {
                this.m_resultSet.addErrorDescription(this.m_validNodeArr, new ErrorDescription(msg));
                this.printError(msg + LSEP);
            }
            return false;
        }
        return retval;
    }

    private boolean verifyDatabaseBestPractice(Target target, ReportUtilConstants.DatabaseDetails databaseDtails, ParamPreReqDBConfig m_paramPreReq, XmlReportTool xmlReportTool) {
        boolean retval = true;
        try {
            String contextMsg = s_prvgMsgBundle.getMessage("0210", false, (Object[])new String[]{databaseDtails.getDatabaseName()});
            ReportUtil.quietblankln();
            ReportUtil.quietprintln(contextMsg);
            ReportUtil.quietblankln();
            List<Task> taskList = target.getTaskList(this.m_validNodeArr, m_paramPreReq);
            if (taskList.size() <= 0) {
                ReportUtil.quietprintln(s_prveMsgBundle.getMessage("3132", false));
            } else if (!(retval &= this.verifyTaskList(taskList))) {
                this.printError(LSEP + s_msgBundle.getMessage("0007", false) + LSEP);
                return false;
            }
            xmlReportTool.addTarget(target.getTargetType(), taskList, (String)null, databaseDtails.getDatabaseName(), databaseDtails.getDatabaseHome());
        }
        catch (TaskFactoryException e) {
            Trace.out((Exception)e);
            this.m_resultSet.addResult(this.m_validNodeArr, 2);
            this.m_resultSet.addErrorDescription(this.m_validNodeArr, new ErrorDescription(e.getCompleteMessage()));
            this.printError(e.getCompleteMessage() + LSEP);
            return false;
        }
        catch (VerificationException e) {
            Trace.out((Exception)e);
            this.m_resultSet.addResult(this.m_validNodeArr, 2);
            String msg = e.getMessage();
            if (VerificationUtil.isStringGood(msg)) {
                this.m_resultSet.addErrorDescription(this.m_validNodeArr, new ErrorDescription(msg));
                this.printError(msg + LSEP);
            }
            return false;
        }
        catch (TransformerException e) {
            Trace.out((Exception)e);
            this.m_resultSet.addResult(this.m_validNodeArr, 2);
            String msg = e.getMessage();
            if (VerificationUtil.isStringGood(msg)) {
                this.m_resultSet.addErrorDescription(this.m_validNodeArr, new ErrorDescription(msg));
                this.printError(msg + LSEP);
            }
            return false;
        }
        catch (XmlReportToolException e) {
            Trace.out((Exception)e);
            this.m_resultSet.addResult(this.m_validNodeArr, 2);
            String msg = e.getMessage();
            if (VerificationUtil.isStringGood(msg)) {
                this.m_resultSet.addErrorDescription(this.m_validNodeArr, new ErrorDescription(msg));
                this.printError(msg + LSEP);
            }
            return false;
        }
        return retval;
    }

    private boolean verifyOSMandatoryChecks(Target target, String version, ParamPreReqCRSInst m_paramPreReq, XmlReportTool xmlReportTool) {
        boolean retval = true;
        try {
            String contextMsg = s_prvgMsgBundle.getMessage("0215", false);
            ReportUtil.quietblankln();
            ReportUtil.quietprintln(contextMsg);
            ReportUtil.quietblankln();
            List<Task> taskList = target.getTaskList(this.m_validNodeArr, m_paramPreReq);
            if (taskList.size() <= 0) {
                ReportUtil.quietprintln(s_prveMsgBundle.getMessage("3135", false, (Object[])new String[]{version}));
            } else {
                for (Task taskItem : taskList) {
                    String taskName = taskItem.getClass().getName();
                    if (!taskName.contains("TaskNodeConnectivity")) continue;
                    Trace.out((String)"Removing 'TaskNodeConnectivity' from task list.");
                    taskList.remove(taskItem);
                    break;
                }
                if (!(retval &= this.verifyTaskList(taskList))) {
                    this.printError(LSEP + s_msgBundle.getMessage("0007", false) + LSEP);
                    return false;
                }
            }
            xmlReportTool.addTarget(target.getTargetType(), taskList, (String)null, (String)null, (String)null);
        }
        catch (TaskFactoryException e) {
            Trace.out((Exception)e);
            this.m_resultSet.addResult(this.m_validNodeArr, 2);
            this.m_resultSet.addErrorDescription(this.m_validNodeArr, new ErrorDescription(e.getCompleteMessage()));
            this.printError(e.getCompleteMessage() + LSEP + s_msgBundle.getMessage("0007", false) + LSEP);
            return false;
        }
        catch (VerificationException e) {
            Trace.out((Exception)e);
            this.m_resultSet.addResult(this.m_validNodeArr, 2);
            String msg = e.getMessage();
            if (VerificationUtil.isStringGood(msg)) {
                this.m_resultSet.addErrorDescription(this.m_validNodeArr, new ErrorDescription(msg));
                this.printError(msg + LSEP);
            }
            this.printError(s_msgBundle.getMessage("0007", false) + LSEP);
            return false;
        }
        catch (TransformerException e) {
            Trace.out((Exception)e);
            this.m_resultSet.addResult(this.m_validNodeArr, 2);
            String msg = e.getMessage();
            if (VerificationUtil.isStringGood(msg)) {
                this.m_resultSet.addErrorDescription(this.m_validNodeArr, new ErrorDescription(msg));
                this.printError(msg + LSEP);
            }
            this.printError(s_msgBundle.getMessage("0007", false) + LSEP);
            return false;
        }
        catch (XmlReportToolException e) {
            Trace.out((Exception)e);
            this.m_resultSet.addResult(this.m_validNodeArr, 2);
            String msg = e.getMessage();
            if (VerificationUtil.isStringGood(msg)) {
                this.m_resultSet.addErrorDescription(this.m_validNodeArr, new ErrorDescription(msg));
                this.printError(msg + LSEP);
            }
            this.printError(s_msgBundle.getMessage("0007", false) + LSEP);
            return false;
        }
        return retval;
    }

    private boolean verifyOSBestPractice(Target target, String version, ParamPreReqCRSInst m_paramPreReq, XmlReportTool xmlReportTool) {
        boolean retval = true;
        if (this.m_isApplicationCluster) {
            ReportUtil.quietprintln(s_prveMsgBundle.getMessage("3159", false, (Object[])new String[]{version}));
            return retval;
        }
        try {
            String contextMsg = s_prvgMsgBundle.getMessage("0208", false);
            ReportUtil.quietblankln();
            ReportUtil.quietprintln(contextMsg);
            ReportUtil.quietblankln();
            List<Task> taskList = target.getTaskList(this.m_validNodeArr, m_paramPreReq);
            if (taskList.size() <= 0) {
                ReportUtil.quietprintln(s_prveMsgBundle.getMessage("3136", false, (Object[])new String[]{version}));
            } else if (!(retval &= this.verifyTaskList(taskList))) {
                this.printError(LSEP + s_msgBundle.getMessage("0007", false) + LSEP);
                return false;
            }
            xmlReportTool.addTarget(target.getTargetType(), taskList, (String)null, (String)null, (String)null);
        }
        catch (TaskFactoryException e) {
            Trace.out((Exception)e);
            this.m_resultSet.addResult(this.m_validNodeArr, 2);
            this.m_resultSet.addErrorDescription(this.m_validNodeArr, new ErrorDescription(e.getCompleteMessage()));
            this.printError(e.getCompleteMessage() + LSEP + s_msgBundle.getMessage("0007", false) + LSEP);
            return false;
        }
        catch (VerificationException e) {
            Trace.out((Exception)e);
            this.m_resultSet.addResult(this.m_validNodeArr, 2);
            String msg = e.getMessage();
            if (VerificationUtil.isStringGood(msg)) {
                this.m_resultSet.addErrorDescription(this.m_validNodeArr, new ErrorDescription(msg));
                this.printError(msg + LSEP);
            }
            this.printError(s_msgBundle.getMessage("0007", false) + LSEP);
            return false;
        }
        catch (TransformerException e) {
            Trace.out((Exception)e);
            this.m_resultSet.addResult(this.m_validNodeArr, 2);
            String msg = e.getMessage();
            if (VerificationUtil.isStringGood(msg)) {
                this.m_resultSet.addErrorDescription(this.m_validNodeArr, new ErrorDescription(msg));
                this.printError(msg + LSEP);
            }
            this.printError(s_msgBundle.getMessage("0007", false) + LSEP);
            return false;
        }
        catch (XmlReportToolException e) {
            Trace.out((Exception)e);
            this.m_resultSet.addResult(this.m_validNodeArr, 2);
            String msg = e.getMessage();
            if (VerificationUtil.isStringGood(msg)) {
                this.m_resultSet.addErrorDescription(this.m_validNodeArr, new ErrorDescription(msg));
                this.printError(msg + LSEP);
            }
            this.printError(s_msgBundle.getMessage("0007", false) + LSEP);
            return false;
        }
        return retval;
    }

    private boolean verifyASMMandatoryChecks(Target target, ParamPreReqUSMConfig m_paramPreReq, XmlReportTool xmlReportTool) {
        boolean retval = true;
        try {
            ReportUtil.quietblankln();
            ReportUtil.quietprintln(s_prvgMsgBundle.getMessage("0228", false));
            ReportUtil.quietblankln();
            List<Task> taskList = target.getTaskList(this.m_validNodeArr, m_paramPreReq);
            if (taskList.size() <= 0) {
                ReportUtil.quietprintln(s_prveMsgBundle.getMessage("3137", false));
            } else if (!(retval &= this.verifyTaskList(taskList))) {
                this.printError(LSEP + s_msgBundle.getMessage("0007", false) + LSEP);
                return false;
            }
            xmlReportTool.addTarget(target.getTargetType(), taskList, (String)null, (String)null, (String)null);
        }
        catch (TaskFactoryException e) {
            Trace.out((Exception)e);
            this.m_resultSet.addResult(this.m_validNodeArr, 2);
            this.m_resultSet.addErrorDescription(new ErrorDescription(e.getCompleteMessage()));
            this.printError(e.getCompleteMessage() + LSEP);
            return false;
        }
        catch (VerificationException e) {
            Trace.out((Exception)e);
            this.m_resultSet.addResult(this.m_validNodeArr, 2);
            String msg = e.getMessage();
            this.m_resultSet.addErrorDescription(new ErrorDescription(msg));
            this.printError(msg + LSEP);
            return false;
        }
        catch (TransformerException e) {
            Trace.out((Exception)e);
            this.m_resultSet.addResult(this.m_validNodeArr, 2);
            String msg = e.getMessage();
            this.m_resultSet.addErrorDescription(new ErrorDescription(msg));
            this.printError(msg + LSEP);
            return false;
        }
        catch (XmlReportToolException e) {
            Trace.out((Exception)e);
            this.m_resultSet.addResult(this.m_validNodeArr, 2);
            String msg = e.getMessage();
            this.m_resultSet.addErrorDescription(new ErrorDescription(msg));
            this.printError(msg + LSEP);
            return false;
        }
        return retval;
    }

    private boolean verifyASMBestPractice(Target target, ParamPreReqUSMConfig m_paramPreReq, XmlReportTool xmlReportTool) {
        boolean retval = true;
        try {
            ReportUtil.quietblankln();
            ReportUtil.quietprintln(s_prvgMsgBundle.getMessage("0229", false));
            ReportUtil.quietblankln();
            Result asmConResult = new Result(VerificationUtil.getLocalNode());
            String connectString = CVUHelperUtil.getASMConnectDescriptor(asmConResult);
            if (connectString == null) {
                VerificationUtil.traceAndLog("failed to get ASM connection information");
                String errorMessage = s_prvgMsgBundle.getMessage("12948", true);
                errorMessage = errorMessage + LSEP + asmConResult.getErrorInfoString() + LSEP;
                this.printError(errorMessage);
                this.m_resultSet.addResult(this.m_validNodeArr, 2);
                this.m_resultSet.addErrorDescription(new ErrorDescription(errorMessage));
                return false;
            }
            ASMConnectInfo.setASMConnectInfo(new ASMConnectInfo(connectString));
            List<Task> taskList = target.getTaskList(this.m_validNodeArr, m_paramPreReq);
            if (taskList.size() <= 0) {
                ReportUtil.quietprintln(s_prveMsgBundle.getMessage("3138", false));
            } else if (!(retval &= this.verifyTaskList(taskList))) {
                this.printError(LSEP + s_msgBundle.getMessage("0007", false) + LSEP);
                return false;
            }
            xmlReportTool.addTarget(target.getTargetType(), taskList, (String)null, (String)null, (String)null);
        }
        catch (TaskFactoryException e) {
            Trace.out((String)e.getMessage());
            this.m_resultSet.addResult(this.m_validNodeArr, 2);
            this.m_resultSet.addErrorDescription(new ErrorDescription(e.getCompleteMessage()));
            this.printError(e.getCompleteMessage() + LSEP);
            return false;
        }
        catch (VerificationException e) {
            Trace.out((String)e.getMessage());
            this.m_resultSet.addResult(this.m_validNodeArr, 2);
            String msg = e.getMessage();
            this.m_resultSet.addErrorDescription(new ErrorDescription(msg));
            this.printError(msg + LSEP);
            return false;
        }
        catch (TransformerException e) {
            Trace.out((String)e.getMessage());
            this.m_resultSet.addResult(this.m_validNodeArr, 2);
            String msg = e.getMessage();
            this.m_resultSet.addErrorDescription(new ErrorDescription(msg));
            this.printError(msg + LSEP);
            return false;
        }
        catch (XmlReportToolException e) {
            Trace.out((String)e.getMessage());
            this.m_resultSet.addResult(this.m_validNodeArr, 2);
            String msg = e.getMessage();
            this.m_resultSet.addErrorDescription(new ErrorDescription(msg));
            this.printError(msg + LSEP);
            return false;
        }
        return retval;
    }

    private boolean verifyApplicationClusterChecks(Target target, String version, ParamPreReqAppCluster appClusterParamPreReq, XmlReportTool xmlReportTool) {
        boolean retval = true;
        try {
            String contextMsg = s_prvgMsgBundle.getMessage("0230", false);
            ReportUtil.quietblankln();
            ReportUtil.quietprintln(contextMsg);
            ReportUtil.quietblankln();
            List<Task> taskList = target.getTaskList(this.m_validNodeArr, appClusterParamPreReq);
            if (taskList.size() <= 0) {
                ReportUtil.quietprintln(s_prveMsgBundle.getMessage("10201", false, (Object[])new String[]{version}));
            } else if (!(retval &= this.verifyTaskList(taskList))) {
                this.printError(LSEP + s_msgBundle.getMessage("0007", false) + LSEP);
                return false;
            }
            xmlReportTool.addTarget(target.getTargetType(), taskList, (String)null, (String)null, (String)null);
        }
        catch (TaskFactoryException e) {
            Trace.out((Exception)e);
            this.m_resultSet.addResult(this.m_validNodeArr, 2);
            this.m_resultSet.addErrorDescription(this.m_validNodeArr, new ErrorDescription(e.getCompleteMessage()));
            this.printError(e.getCompleteMessage() + LSEP + s_msgBundle.getMessage("0007", false) + LSEP);
            return false;
        }
        catch (VerificationException e) {
            Trace.out((Exception)e);
            this.m_resultSet.addResult(this.m_validNodeArr, 2);
            String msg = e.getMessage();
            if (VerificationUtil.isStringGood(msg)) {
                this.m_resultSet.addErrorDescription(this.m_validNodeArr, new ErrorDescription(msg));
                this.printError(msg + LSEP);
            }
            this.printError(s_msgBundle.getMessage("0007", false) + LSEP);
            return false;
        }
        catch (TransformerException e) {
            Trace.out((Exception)e);
            this.m_resultSet.addResult(this.m_validNodeArr, 2);
            String msg = e.getMessage();
            if (VerificationUtil.isStringGood(msg)) {
                this.m_resultSet.addErrorDescription(this.m_validNodeArr, new ErrorDescription(msg));
                this.printError(msg + LSEP);
            }
            this.printError(s_msgBundle.getMessage("0007", false) + LSEP);
            return false;
        }
        catch (XmlReportToolException e) {
            Trace.out((Exception)e);
            this.m_resultSet.addResult(this.m_validNodeArr, 2);
            String msg = e.getMessage();
            if (VerificationUtil.isStringGood(msg)) {
                this.m_resultSet.addErrorDescription(this.m_validNodeArr, new ErrorDescription(msg));
                this.printError(msg + LSEP);
            }
            this.printError(s_msgBundle.getMessage("0007", false) + LSEP);
            return false;
        }
        return retval;
    }

    private void reportFailure(String message) {
        this.printError(message);
    }

    private void printError(String message) {
        ReportUtil.quietprintln(VerificationConstants.LSEP + ReportUtil.ERROR + VerificationConstants.LSEP + message);
    }

    private void printWarning(String message) {
        ReportUtil.quietprintln(VerificationConstants.LSEP + ReportUtil.WARNING + VerificationConstants.LSEP + message);
    }

    private void testCreds(String dbName, String dbUser, String dbPwd) throws DBConnectionException {
        OracleConnection oracleConnection = SQLFactory.getDBConnection((String)dbName, (String)dbUser, (String)dbPwd);
        try {
            oracleConnection.close();
        }
        catch (SQLException sqlEx) {
            Trace.out((String)("SQLException while closing the connection. Mesg:" + sqlEx.getMessage()));
        }
    }

    private boolean writeErrorToGlobalAlertLog() {
        block14: {
            try {
                CVUFactory cvuFac = null;
                CVU cvu = null;
                String previousErrorHash = null;
                CVU.SpaceAlertState previousSpaceAlertState = null;
                List<String> errorMsgList = this.getErrorMsgList(this.m_resultSet);
                String[] currentErrorArray = errorMsgList.toArray(new String[0]);
                String currentError = VerificationUtil.strArr2List(currentErrorArray, ",");
                Trace.out((String)("current error =" + VerificationUtil.strArr2String(currentErrorArray, LSEP)));
                currentError = currentError.replace(LSEP, ",");
                String currentErrorHash = String.valueOf(currentError.hashCode());
                Trace.out((String)"Calling CVUFactory.getInstance()");
                cvuFac = CVUFactory.getInstance();
                cvu = cvuFac.getCVU();
                previousErrorHash = cvu.getCheckResults();
                previousSpaceAlertState = cvu.getSpaceAlertState();
                Trace.out((String)"got previous results and space alert state");
                if (!currentErrorHash.equalsIgnoreCase(previousErrorHash)) {
                    ReportUtil.printGlobalAlertLog(currentErrorArray);
                    Trace.out((String)"setting attribute in seperate thread");
                    try {
                        UpdateCVUAttribute chkRes = new UpdateCVUAttribute(cvu, currentErrorHash, UpdateCVUAttribute.UpdateAttributeType.CHECK_RESULT);
                        chkRes.start();
                        chkRes.join(30000L);
                        oracle.cluster.cvu.CVUException cve = chkRes.getCVUException();
                        if (cve != null) {
                            throw cve;
                        }
                    }
                    catch (InterruptedException e) {
                        Trace.out((String)"IE. shouldn't happen");
                    }
                    Trace.out((String)"done setting check result attribute");
                }
                boolean isUpdateSpaceAlert = false;
                CVU.SpaceAlertState spaceAlertState = CVU.SpaceAlertState.ON;
                if (this.m_isSpaceAlert) {
                    Trace.out((String)"write alert on clusterware home space");
                    ReportUtil.printGlobalAlertLog(this.m_spaceAlertMsgArr);
                    if (previousSpaceAlertState != CVU.SpaceAlertState.ON) {
                        isUpdateSpaceAlert = true;
                    }
                } else if (previousSpaceAlertState == CVU.SpaceAlertState.ON) {
                    Trace.out((String)"writing to alert log that space is fine");
                    ReportUtil.printGlobalAlertLog(this.m_spaceAlertMsgArr);
                    spaceAlertState = CVU.SpaceAlertState.OFF;
                    isUpdateSpaceAlert = true;
                }
                if (!isUpdateSpaceAlert) break block14;
                try {
                    UpdateCVUAttribute spaceAlrt = new UpdateCVUAttribute(cvu, spaceAlertState, UpdateCVUAttribute.UpdateAttributeType.SPACE_ALERT);
                    spaceAlrt.start();
                    spaceAlrt.join(30000L);
                    oracle.cluster.cvu.CVUException cve = spaceAlrt.getCVUException();
                    if (cve != null) {
                        throw cve;
                    }
                }
                catch (InterruptedException e) {
                    Trace.out((String)"IE. shouldn't happen");
                }
                Trace.out((String)"done setting space alert attribute");
            }
            catch (oracle.cluster.cvu.CVUException ce) {
                Trace.out((String)("CVU exception " + ce.getMessage()));
                Trace.out((String)("Nested exception: " + ((Exception)ce.getCause()).getMessage()));
                return false;
            }
            catch (NotExistsException ne) {
                Trace.out((String)("Notexists  exception " + ne.getMessage()));
                return false;
            }
        }
        return true;
    }

    private List<String> getErrorMsgList(ResultSet rs) {
        ArrayList<String> errorMsgList = new ArrayList<String>();
        List<VerificationError> globalErrors = rs.getErrors();
        for (VerificationError error : globalErrors) {
            String errMsg = error.getErrorMessage();
            Trace.out((String)("adding global error message: " + errMsg));
            errorMsgList.add(errMsg);
        }
        Hashtable resultTable = rs.getResultTable();
        for (Object node : resultTable.keySet()) {
            Result result = (Result)resultTable.get(node);
            for (VerificationError nodeErr : result.getErrors()) {
                String errMsg = nodeErr.getErrorMessage();
                Trace.out((String)("Adding node Error mesg : " + errMsg));
                errorMsgList.add(errMsg);
            }
        }
        return errorMsgList;
    }

    @Override
    public String getComponentName() {
        return "HEALTH_CHECK";
    }

    @Override
    public String getComponentDisplayName() {
        return s_prvgMsgBundle.getMessage("0206", false);
    }

    private void checkIfNodeRolesSet() {
        if (!this.m_nodeManager.nodeRolesDetermined()) {
            String warningMsg = s_prvgMsgBundle.getMessage("10466", true, (Object[])new String[]{VerificationUtil.strArr2List(this.m_validNodeArr)});
            if (VerificationUtil.isStringGood(this.m_crsctlCmdErrors)) {
                warningMsg = warningMsg + LSEP + this.m_crsctlCmdErrors;
            }
            this.printWarning(LSEP + warningMsg + LSEP);
            String localnode = VerificationUtil.getLocalNode();
            this.m_resultSet.addResult(localnode, 4);
            this.m_resultSet.addErrorDescription(localnode, new ErrorDescription(warningMsg));
        }
    }
}

