/*
 * Decompiled with CFR 0.152.
 */
package oracle.ops.verification.framework.engine.component;

import oracle.cluster.verification.util.VerificationType;
import oracle.ops.mgmt.nativesystem.NativeSystem;
import oracle.ops.mgmt.nativesystem.SystemFactory;
import oracle.ops.mgmt.trace.Trace;
import oracle.ops.verification.framework.engine.ErrorDescription;
import oracle.ops.verification.framework.engine.component.Component;
import oracle.ops.verification.framework.engine.component.ComponentInitException;
import oracle.ops.verification.framework.network.NetworkUtility;
import oracle.ops.verification.framework.report.ReportUtil;
import oracle.ops.verification.framework.util.CVUHelperUtil;
import oracle.ops.verification.framework.util.CVUVariableConstants;
import oracle.ops.verification.framework.util.CVUVariables;
import oracle.ops.verification.framework.util.NodelistNotFoundException;
import oracle.ops.verification.framework.util.VerificationUtil;

public class GNSComponent
extends Component {
    GNSComponent(VerificationType verificationType) throws ComponentInitException {
        super(verificationType);
        this.init();
    }

    @Override
    public void init() throws ComponentInitException {
        super.init();
        if (this.m_paramMgr.isGNSClientDataSpecified()) {
            CVUVariables.setValue(CVUVariableConstants.USE_SHARED_GNS, "TRUE");
        } else {
            CVUVariables.setValue(CVUVariableConstants.USE_SHARED_GNS, "FALSE");
        }
        if (this.m_paramMgr.isGNSDomainSpecified()) {
            CVUVariables.setValue(CVUVariableConstants.AUTO_CONFIGURE_CLUSTER_NODE_VIP, "TRUE");
        } else {
            CVUVariables.setValue(CVUVariableConstants.AUTO_CONFIGURE_CLUSTER_NODE_VIP, "FALSE");
        }
    }

    @Override
    public boolean verify() {
        String[] validNodeArr;
        boolean preCRSInst = false;
        preCRSInst = this.m_paramMgr.checkArgGnsPreCrsinst();
        if (!preCRSInst) {
            try {
                validNodeArr = VerificationUtil.getStaticNodelist();
            }
            catch (NodelistNotFoundException e) {
                this.m_resultSet.addResult(this.m_nodeList, 2);
                ReportUtil.printError(e.getMessage());
                return false;
            }
            Trace.out((String)"adding all cluster nodes to operation");
            this.setNodeList(validNodeArr);
            if (validNodeArr.length > 1) {
                VerificationUtil.setLocalNodeOperation(false);
            }
        }
        boolean retval = this.checkSetup();
        validNodeArr = this.getValidNodeList();
        if (null == validNodeArr) {
            return false;
        }
        if (!preCRSInst) {
            String currentUser = System.getProperty("user.name");
            NativeSystem nativeSystem = new SystemFactory().CreateSystem();
            String crsUser = CVUHelperUtil.getCRSUser();
            if (nativeSystem.isUnixSystem() && crsUser != null && !crsUser.equals(currentUser)) {
                String errMsg = s_msgBundle.getMessage("0056", true, (Object[])new String[]{currentUser});
                this.m_resultSet.addResult(validNodeArr, 2);
                ErrorDescription errDesc = new ErrorDescription(errMsg);
                this.m_resultSet.addErrorDescription(validNodeArr, errDesc);
                ReportUtil.sureprintln(errMsg);
                return false;
            }
        } else if (!NetworkUtility.validateNetworksArg(validNodeArr[0], this.m_paramMgr, this.m_resultSet)) {
            this.m_resultSet.addResult(validNodeArr, 2);
            return false;
        }
        return super.verifyComponent();
    }

    @Override
    public String getComponentName() {
        return "GNS";
    }

    @Override
    public String getComponentDisplayName() {
        return s_msgBundle.getMessage("9956", false);
    }
}

