/*
 * Decompiled with CFR 0.152.
 */
package oracle.ops.verification.framework.engine.component;

import oracle.cluster.verification.util.VerificationType;
import oracle.ops.mgmt.nativesystem.NativeSystem;
import oracle.ops.mgmt.nativesystem.SystemFactory;
import oracle.ops.mgmt.trace.Trace;
import oracle.ops.verification.framework.engine.ErrorDescription;
import oracle.ops.verification.framework.engine.component.Component;
import oracle.ops.verification.framework.engine.component.ComponentInitException;
import oracle.ops.verification.framework.report.ReportUtil;
import oracle.ops.verification.framework.util.RootAutomationNotConfiguredException;
import oracle.ops.verification.framework.util.RootAutomationUtility;

public class DNSComponent
extends Component {
    DNSComponent(VerificationType verificationType) throws ComponentInitException {
        super(verificationType);
        this.init();
    }

    @Override
    public void init() throws ComponentInitException {
        super.init();
    }

    @Override
    public boolean verify() {
        NativeSystem nativeSystem = new SystemFactory().CreateSystem();
        if (nativeSystem.isUnixSystem() && !Boolean.getBoolean("CV_ROOTUSERCHECK") && !RootAutomationUtility.isRootExecutionConfigured()) {
            String errMsg = s_msgBundle.getMessage("0055", true, (Object[])new String[]{System.getProperty("user.name")});
            this.m_resultSet.addResult(this.m_nodeList, 2);
            ErrorDescription errDesc = new ErrorDescription(errMsg);
            this.m_resultSet.addErrorDescription(this.m_nodeList, errDesc);
            ReportUtil.sureprintln(errMsg);
            return false;
        }
        this.checkSetup();
        String[] validNodeArr = this.getValidNodeList();
        if (null == validNodeArr) {
            return false;
        }
        if (RootAutomationUtility.isRootExecutionConfigured()) {
            try {
                if (!RootAutomationUtility.validateRootPrivileges(validNodeArr)) {
                    this.m_resultSet.addResult(validNodeArr, 3);
                    return false;
                }
            }
            catch (RootAutomationNotConfiguredException rance) {
                Trace.out((String)"Contradictory status of root automation configuration");
                this.m_resultSet.addResult(validNodeArr, 2);
                return false;
            }
        }
        DNSComponent dNSComponent = this;
        if (!dNSComponent.m_paramMgr.isRuncluvfy() && !this.checkCRSConfiguration(validNodeArr)) {
            return false;
        }
        switch (this.m_verificationType) {
            case COMPONENT_DNS_INTEGRITY: {
                return super.verifyComponent();
            }
        }
        Trace.out((String)"ERROR: Invalid Verification Type!");
        return false;
    }

    @Override
    public String getComponentName() {
        return "DNS";
    }

    @Override
    public String getComponentDisplayName() {
        return s_msgBundle.getMessage("9984", false);
    }
}

