/*
 * Decompiled with CFR 0.152.
 */
package oracle.ops.verification.framework.engine.component;

import oracle.cluster.verification.util.VerificationType;
import oracle.ops.mgmt.trace.Trace;
import oracle.ops.verification.framework.engine.component.Component;
import oracle.ops.verification.framework.engine.component.ComponentInitException;
import oracle.ops.verification.framework.network.NetworkUtility;
import oracle.ops.verification.framework.util.RootAutomationNotConfiguredException;
import oracle.ops.verification.framework.util.RootAutomationUtility;

public class DHCPComponent
extends Component {
    DHCPComponent(VerificationType verificationType) throws ComponentInitException {
        super(verificationType);
        this.init();
    }

    @Override
    public void init() throws ComponentInitException {
        super.init();
    }

    @Override
    public boolean verify() {
        String[] validNodeArr;
        block8: {
            this.checkSetup();
            validNodeArr = this.getValidNodeList();
            if (null == validNodeArr) {
                return false;
            }
            if (RootAutomationUtility.isRootExecutionConfigured()) {
                try {
                    if (!RootAutomationUtility.validateRootPrivileges(validNodeArr)) {
                        this.m_resultSet.addResult(validNodeArr, 3);
                        return false;
                    }
                    break block8;
                }
                catch (RootAutomationNotConfiguredException rance) {
                    Trace.out((String)"Contradictory status of root automation configuration");
                    this.m_resultSet.addResult(validNodeArr, 2);
                    return false;
                }
            }
            NetworkUtility.validateNetworksArg(validNodeArr[0], this.m_paramMgr, this.m_resultSet);
        }
        switch (this.m_verificationType) {
            case COMPONENT_DHCP_INTEGRITY: {
                return super.verifyComponent();
            }
        }
        Trace.out((String)"ERROR: Invalid Verification Type!");
        this.m_resultSet.addResult(validNodeArr, 2);
        return false;
    }

    @Override
    public String getComponentName() {
        return "DHCP";
    }

    @Override
    public String getComponentDisplayName() {
        return s_msgBundle.getMessage("9985", false);
    }
}

