/*
 * Decompiled with CFR 0.152.
 */
package oracle.ops.verification.framework.engine.component;

import oracle.cluster.verification.util.VerificationType;
import oracle.ops.verification.framework.VerificationConstants;
import oracle.ops.verification.framework.engine.component.ACFSComponent;
import oracle.ops.verification.framework.engine.component.ASMComponent;
import oracle.ops.verification.framework.engine.component.BaselineComponent;
import oracle.ops.verification.framework.engine.component.CFSComponent;
import oracle.ops.verification.framework.engine.component.CRSComponent;
import oracle.ops.verification.framework.engine.component.CTSSComponent;
import oracle.ops.verification.framework.engine.component.ClusterComponent;
import oracle.ops.verification.framework.engine.component.ClusterMgrComponent;
import oracle.ops.verification.framework.engine.component.Component;
import oracle.ops.verification.framework.engine.component.ComponentInitException;
import oracle.ops.verification.framework.engine.component.DHCPComponent;
import oracle.ops.verification.framework.engine.component.DNSComponent;
import oracle.ops.verification.framework.engine.component.FarmCheckComponent;
import oracle.ops.verification.framework.engine.component.FreeSpaceComponent;
import oracle.ops.verification.framework.engine.component.GNSComponent;
import oracle.ops.verification.framework.engine.component.GPNPComponent;
import oracle.ops.verification.framework.engine.component.HAComponent;
import oracle.ops.verification.framework.engine.component.HealthCheckComponent;
import oracle.ops.verification.framework.engine.component.HealthComponent;
import oracle.ops.verification.framework.engine.component.InvalidComponentException;
import oracle.ops.verification.framework.engine.component.NodeAppComponent;
import oracle.ops.verification.framework.engine.component.NodeReachComponent;
import oracle.ops.verification.framework.engine.component.OCRComponent;
import oracle.ops.verification.framework.engine.component.OHASDComponent;
import oracle.ops.verification.framework.engine.component.OLRComponent;
import oracle.ops.verification.framework.engine.component.ScanComponent;
import oracle.ops.verification.framework.engine.component.SoftwareComponent;
import oracle.ops.verification.framework.engine.component.StorageComponent;
import oracle.ops.verification.framework.engine.component.SystemComponent;
import oracle.ops.verification.framework.engine.component.VDiskComponent;

public class ComponentFactory
implements VerificationConstants {
    public static Component createComponent(String componentID) throws InvalidComponentException, ComponentInitException {
        if (componentID.equalsIgnoreCase("space")) {
            return new StorageComponent(VerificationType.COMPONENT_SPACE_AVAILABILITY);
        }
        if (componentID.equalsIgnoreCase("ssa")) {
            return new StorageComponent(VerificationType.COMPONENT_SHARED_STORAGE_ACCESS);
        }
        if (componentID.equalsIgnoreCase("sys")) {
            return new SystemComponent(VerificationType.COMPONENT_SYSTEM_REQUIREMENTS);
        }
        if (componentID.equalsIgnoreCase("admprv")) {
            return new SystemComponent(VerificationType.COMPONENT_ADMIN_PRIVILEGES);
        }
        if (componentID.equalsIgnoreCase("cfs")) {
            return new CFSComponent(VerificationType.COMPONENT_CFS_INTEGRITY);
        }
        if (componentID.equalsIgnoreCase("clumgr")) {
            return new ClusterMgrComponent(VerificationType.COMPONENT_CLUSTER_MGR_INTEGRITY);
        }
        if (componentID.equalsIgnoreCase("clu")) {
            return new ClusterComponent(VerificationType.COMPONENT_CLUSTER_INTEGRITY);
        }
        if (componentID.equalsIgnoreCase("nodecon")) {
            return new ClusterComponent(VerificationType.COMPONENT_NODE_CONNECTIVITY);
        }
        if (componentID.equalsIgnoreCase("nodereach")) {
            return new NodeReachComponent(VerificationType.COMPONENT_NODE_REACHABILITY);
        }
        if (componentID.equalsIgnoreCase("peer")) {
            return new ClusterComponent(VerificationType.COMPONENT_PEER_COMPATIBILITY);
        }
        if (componentID.equalsIgnoreCase("ocr")) {
            return new OCRComponent(VerificationType.COMPONENT_OCR_INTEGRITY);
        }
        if (componentID.equalsIgnoreCase("olr")) {
            return new OLRComponent(VerificationType.COMPONENT_OLR_INTEGRITY);
        }
        if (componentID.equalsIgnoreCase("ha")) {
            return new HAComponent(VerificationType.COMPONENT_HA_INTEGRITY);
        }
        if (componentID.equalsIgnoreCase("crs")) {
            return new CRSComponent(VerificationType.COMPONENT_CRS_INTEGRITY);
        }
        if (componentID.equalsIgnoreCase("nodeapp")) {
            return new NodeAppComponent(VerificationType.COMPONENT_NODEAPP_EXISTENCE);
        }
        if (componentID.equalsIgnoreCase("software")) {
            return new SoftwareComponent(VerificationType.COMPONENT_SOFTWARE);
        }
        if (componentID.equalsIgnoreCase("asm")) {
            return new ASMComponent(VerificationType.COMPONENT_ASM_INTEGRITY);
        }
        if (componentID.equalsIgnoreCase("acfs")) {
            return new ACFSComponent(VerificationType.COMPONENT_ACFS_INTEGRITY);
        }
        if (componentID.equalsIgnoreCase("gpnp")) {
            return new GPNPComponent(VerificationType.COMPONENT_GPNP_INTEGRITY);
        }
        if (componentID.equalsIgnoreCase("gns")) {
            return new GNSComponent(VerificationType.COMPONENT_GNS_INTEGRITY);
        }
        if (componentID.equalsIgnoreCase("scan")) {
            return new ScanComponent(VerificationType.COMPONENT_SCAN);
        }
        if (componentID.equalsIgnoreCase("ohasd")) {
            return new OHASDComponent(VerificationType.COMPONENT_OHASD_INTEGRITY);
        }
        if (componentID.equalsIgnoreCase("clocksync")) {
            return new CTSSComponent(VerificationType.COMPONENT_CTSS_INTEGRITY);
        }
        if (componentID.equalsIgnoreCase("vdisk")) {
            return new VDiskComponent(VerificationType.COMPONENT_VDISK_INTEGRITY);
        }
        if (componentID.equalsIgnoreCase("health")) {
            return new HealthComponent(VerificationType.COMPONENT_HEALTH);
        }
        if (componentID.equalsIgnoreCase("dns")) {
            return new DNSComponent(VerificationType.COMPONENT_DNS_INTEGRITY);
        }
        if (componentID.equalsIgnoreCase("dhcp")) {
            return new DHCPComponent(VerificationType.COMPONENT_DHCP_INTEGRITY);
        }
        if (componentID.equalsIgnoreCase("healthcheck")) {
            return new HealthCheckComponent(VerificationType.COMPONENT_HEALTH_CHECK);
        }
        if (componentID.equalsIgnoreCase("freespace")) {
            return new FreeSpaceComponent(VerificationType.COMPONENT_FREE_SPACE);
        }
        if (componentID.equalsIgnoreCase("baseline")) {
            return new BaselineComponent(VerificationType.COMPONENT_BASELINE);
        }
        if (componentID.equalsIgnoreCase("farmcheck")) {
            return new FarmCheckComponent(VerificationType.COMPONENT_FARM_CHECK);
        }
        throw new InvalidComponentException("Invalid Component Tag: " + componentID);
    }
}

