/*
 * Decompiled with CFR 0.152.
 */
package oracle.ops.verification.framework.engine.component;

import java.util.Set;
import java.util.Vector;
import oracle.cluster.verification.ParamPreReq;
import oracle.cluster.verification.ParamPreReqCRSInst;
import oracle.cluster.verification.VerificationException;
import oracle.cluster.verification.util.VerificationType;
import oracle.ops.mgmt.trace.Trace;
import oracle.ops.verification.framework.engine.Result;
import oracle.ops.verification.framework.engine.ResultSet;
import oracle.ops.verification.framework.engine.component.Component;
import oracle.ops.verification.framework.engine.component.ComponentInitException;
import oracle.ops.verification.framework.engine.factory.context.GlobalVerificationContext;
import oracle.ops.verification.framework.engine.task.TaskAnonymousProxy;
import oracle.ops.verification.framework.network.NetworkDataDiscovery;
import oracle.ops.verification.framework.network.NetworkInfo;
import oracle.ops.verification.framework.network.NetworkUtility;
import oracle.ops.verification.framework.report.ReportUtil;
import oracle.ops.verification.framework.util.CVUVariableConstants;
import oracle.ops.verification.framework.util.CVUVariables;
import oracle.ops.verification.framework.util.NodelistNotFoundException;
import oracle.ops.verification.framework.util.VerificationUtil;

public class ClusterComponent
extends Component {
    private String m_referenceNode;
    private boolean m_isRefNodeOk = true;
    private ParamPreReq m_paramPreReq = null;
    private String m_netArg = null;
    private String m_release;
    private String m_osdba;
    private String m_oraInv;

    ClusterComponent(VerificationType verificationType) throws ComponentInitException {
        super(verificationType);
        this.init();
    }

    @Override
    public void init() throws ComponentInitException {
        if (this.m_verificationType == VerificationType.COMPONENT_CLUSTER_INTEGRITY) {
            Trace.out((String)"==== Skipping nodelist initialization for cluster intg.");
            super.init(false);
        } else {
            super.init();
        }
        switch (this.m_verificationType) {
            case COMPONENT_CLUSTER_INTEGRITY: {
                String nodelistArg = CVUVariables.getValue(CVUVariableConstants.NODE_LIST);
                if (nodelistArg == null) {
                    try {
                        this.m_nodeList = VerificationUtil.getStaticNodelist();
                        Trace.out((String)("==== Using default nodelist for cluster integrity: " + VerificationUtil.strArr2List(this.m_nodeList)));
                    }
                    catch (NodelistNotFoundException e) {
                        Trace.out((String)("==== " + e.getMessage()));
                        throw new ComponentInitException(e.getMessage());
                    }
                }
                try {
                    this.m_nodeList = VerificationUtil.getNodelist();
                    Trace.out((String)("==== Nodelist for cluster integrity set to: " + VerificationUtil.strArr2List(this.m_nodeList)));
                }
                catch (NodelistNotFoundException e) {
                    throw new ComponentInitException(e.getMessage());
                }
                this.initNodeManager();
                VerificationUtil.adjustTraceSize(this.m_nodeList.length);
                break;
            }
            case COMPONENT_NODE_CONNECTIVITY: {
                if (CVUVariables.getValue(CVUVariableConstants.NETWORK_LIST) == null) break;
                this.m_netArg = CVUVariables.getValue(CVUVariableConstants.NETWORK_LIST);
                break;
            }
            case COMPONENT_PEER_COMPATIBILITY: {
                this.m_referenceNode = CVUVariables.getValue(CVUVariableConstants.REFERENCE_NODE);
                Trace.out((String)("==== ParamManager reports reference node as " + this.m_referenceNode));
                this.m_osdba = CVUVariables.getValue(CVUVariableConstants.DBA_GROUP);
                this.m_release = CVUVariables.getValue(CVUVariableConstants.RELEASE);
                if ("10gR1".equalsIgnoreCase(this.m_release)) {
                    this.m_release = "10.1";
                } else if ("10gR2".equalsIgnoreCase(this.m_release)) {
                    this.m_release = "10.2";
                } else if ("11gR1".equalsIgnoreCase(this.m_release)) {
                    this.m_release = "11.1";
                } else if ("11gR2".equalsIgnoreCase(this.m_release)) {
                    this.m_release = "11.2";
                }
                this.m_oraInv = CVUVariables.getValue(CVUVariableConstants.INSTALL_GROUP);
                this.m_paramPreReq = new ParamPreReqCRSInst();
                ((ParamPreReqCRSInst)this.m_paramPreReq).setRelease(this.m_release);
                if (this.m_osdba == null) {
                    this.m_osdba = VerificationUtil.getDefaultDbaGroup();
                }
                if (this.m_oraInv == null) {
                    Result result = new Result(VerificationUtil.getLocalNode());
                    this.m_oraInv = VerificationUtil.getDefaultOraInvGroup(result);
                    if (this.m_oraInv == null) {
                        Trace.out((int)5, (String)"ComponentInit: %s", (Object[])new Object[]{result.traceResultInfo()});
                        ReportUtil.processAlert(VerificationUtil.LSEP + ReportUtil.ERROR + VerificationUtil.LSEP + s_prvgMsgBundle.getMessage("10467", true));
                    }
                }
                if (this.m_osdba != null) {
                    ((ParamPreReqCRSInst)this.m_paramPreReq).setOSDBAgroup(this.m_osdba);
                }
                if (this.m_oraInv != null) {
                    ((ParamPreReqCRSInst)this.m_paramPreReq).setORAINVgroup(this.m_oraInv);
                }
                CVUVariables.setValue(CVUVariableConstants.DBA_GROUP, this.m_osdba);
                CVUVariables.setValue(CVUVariableConstants.INSTALL_GROUP, this.m_oraInv);
                break;
            }
            default: {
                Trace.out((String)("Invalid verification type during cluster " + (Object)((Object)this.m_verificationType)));
            }
        }
    }

    private boolean isRefNodeOk() {
        return this.m_isRefNodeOk;
    }

    @Override
    protected boolean checkSetup() {
        boolean succ = false;
        Object[] refNodeList = new String[]{this.m_referenceNode};
        Vector<String> succNodes = new Vector<String>();
        Vector<String> failNodes = new Vector<String>();
        ResultSet tmpResultSet = new ResultSet();
        if (null != this.m_referenceNode) {
            if (!VerificationUtil.isNodeReachable(this.m_referenceNode)) {
                ReportUtil.printError(s_msgBundle.getMessage("4605", false, refNodeList));
                this.getResultSet().addResult(this.getNodeList(), 2);
                this.m_isRefNodeOk = false;
                return false;
            }
            if (!VerificationUtil.isUserEquivalenceOnNode(this.m_referenceNode, false)) {
                ReportUtil.printError(s_msgBundle.getMessage("4606", false, refNodeList));
                this.getResultSet().addResult(this.getNodeList(), 2);
                this.m_isRefNodeOk = false;
                return false;
            }
            boolean destLocSucc = VerificationUtil.checkDestLoc((String[])refNodeList, tmpResultSet, succNodes, failNodes, true);
            if (!destLocSucc) {
                Trace.out((String)"ReferenceNode didn't pass setup checks: checkDestLoc");
                this.getResultSet().addResult(this.getNodeList(), 2);
                this.m_isRefNodeOk = false;
                return false;
            }
        }
        succ = this.m_isRefNodeOk && super.checkSetup();
        return succ;
    }

    @Override
    public boolean verify() {
        this.checkSetup();
        if (!this.isRefNodeOk()) {
            return false;
        }
        if (null == this.getValidNodeList()) {
            return false;
        }
        switch (this.m_verificationType) {
            case COMPONENT_CLUSTER_INTEGRITY: {
                return super.verifyComponent();
            }
            case COMPONENT_NODE_CONNECTIVITY: {
                if (this.m_netArg != null) {
                    ResultSet networkResultSet = new ResultSet();
                    Set<NetworkInfo> clusterNetworks = NetworkDataDiscovery.getClusterNetworksFromPMArgument(this.m_netArg, this.getValidNodeList()[0], networkResultSet);
                    if (!NetworkUtility.isNetworksSetGood(clusterNetworks)) {
                        Trace.out((String)"Could not fetch the network details successfully from PM argument during cluster component node connectivity checks");
                        NetworkUtility.reportResultSet(networkResultSet, this.m_resultSet, true);
                        TaskAnonymousProxy reportNetworkDiscoveryFail = new TaskAnonymousProxy(ReportUtil.getCompMsg("nodecon"), this.getValidNodeList(), null, networkResultSet);
                        this.m_taskReportList.add(reportNetworkDiscoveryFail);
                        Trace.out((String)"No interfaces found, report errors through proxy task.");
                        return false;
                    }
                }
                return super.verifyComponent();
            }
            case COMPONENT_PEER_COMPATIBILITY: {
                try {
                    GlobalVerificationContext.getInstance().setParamPrereq(this.m_paramPreReq, this.getVerificationType());
                }
                catch (VerificationException e) {
                    Trace.out((String)("Caught VerificationException while setting the param prereq. Error is :" + e.getMessage()));
                }
                return super.verifyComponent();
            }
        }
        Trace.out((String)"ERROR: Invalid Verification Type!");
        return false;
    }

    @Override
    public String getComponentName() {
        return "CLUSTER";
    }

    @Override
    public String getComponentDisplayName() {
        return s_msgBundle.getMessage("9952", false);
    }
}

