/*
 * Decompiled with CFR 0.152.
 */
package oracle.ops.verification.framework.engine.component;

import oracle.cluster.verification.util.VerificationType;
import oracle.ops.mgmt.trace.Trace;
import oracle.ops.verification.framework.engine.component.Component;
import oracle.ops.verification.framework.engine.component.ComponentInitException;
import oracle.ops.verification.framework.util.VerificationUtil;

public class ACFSComponent
extends Component {
    ACFSComponent(VerificationType verificationType) throws ComponentInitException {
        super(verificationType);
        this.init();
    }

    @Override
    public void init() throws ComponentInitException {
        super.init();
    }

    @Override
    public boolean verify() {
        Trace.out((String)"Commencing ACFS Integrity verify()...");
        this.checkSetup();
        String[] validNodeArr = this.getValidNodeList();
        if (null == validNodeArr) {
            return false;
        }
        if (!this.checkCRSConfiguration(validNodeArr)) {
            return false;
        }
        if (!VerificationUtil.isACFSSupported(true)) {
            VerificationUtil.traceAndLogError("ACFS is not supported in the current environment");
            this.m_resultSet.addResult(this.m_nodeList, 2);
            return false;
        }
        switch (this.m_verificationType) {
            case COMPONENT_ACFS_INTEGRITY: {
                return super.verifyComponent();
            }
        }
        Trace.out((String)"ERROR: Invalid Verification Type!");
        return false;
    }

    @Override
    public String getComponentName() {
        return "ACFS";
    }

    @Override
    public String getComponentDisplayName() {
        return s_msgBundle.getMessage("9969", false);
    }
}

