/*
 * Decompiled with CFR 0.152.
 */
package oracle.ops.verification.framework.engine;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.List;
import java.util.Set;
import java.util.Vector;
import oracle.cluster.verification.NodeResultsUnavailableException;
import oracle.cluster.verification.OverallStatus;
import oracle.cluster.verification.ResultValuesUnavailableException;
import oracle.cluster.verification.VerificationError;
import oracle.cluster.verification.VerificationMessage;
import oracle.cluster.verification.VerificationResult;
import oracle.cluster.verification.VerificationResultSet;
import oracle.ops.mgmt.nls.MessageBundle;
import oracle.ops.mgmt.trace.Trace;
import oracle.ops.verification.framework.engine.CollectionElement;
import oracle.ops.verification.framework.engine.ErrorDescription;
import oracle.ops.verification.framework.engine.Result;
import oracle.ops.verification.framework.engine.ResultKeyType;
import oracle.ops.verification.framework.report.ReportUtil;
import oracle.ops.verification.framework.util.VerificationLogData;
import oracle.ops.verification.framework.util.VerificationUtil;

public class ResultSet
implements VerificationResultSet {
    public static final int SUCCESSFUL = 1;
    public static final int OPERATION_FAILED = 2;
    public static final int VERIFICATION_FAILED = 3;
    public static final int WARNING = 4;
    public static final int UNKNOWN = 5;
    protected static MessageBundle s_msgBundle = VerificationUtil.getMessageBundle("Prvf");
    protected static MessageBundle s_gMsgBundle = VerificationUtil.getMessageBundle("Prvg");
    private int m_uploadedStatus = 5;
    protected Hashtable m_uploadedResultTable = new Hashtable();
    private int m_status = 5;
    protected Hashtable m_resultTable = new Hashtable();
    private boolean m_hasNodeResults = true;
    private List<VerificationError> m_uploadedErrorList = new ArrayList<VerificationError>();
    private int m_uploadedGlobalStatus = 5;
    private List<VerificationError> m_errorList = new ArrayList<VerificationError>();
    private int m_globalStatus = 5;
    private List<VerificationMessage> m_messageList = new ArrayList<VerificationMessage>();
    private List<VerificationMessage> m_uploadedMessageList = new ArrayList<VerificationMessage>();
    private List<CollectionElement> m_collectionList = new ArrayList<CollectionElement>();
    private List<CollectionElement> m_uploadedCollectionList = new ArrayList<CollectionElement>();
    private String m_summary;

    public ResultSet() {
    }

    public ResultSet(int status) {
        this.m_status = this.m_uploadedStatus = status;
    }

    public void settle() {
        Object obj;
        String key;
        Enumeration e;
        String errorMsg;
        HashSet<String> currentMsgSet = new HashSet<String>();
        ArrayList<VerificationError> tempErrList = new ArrayList<VerificationError>();
        for (VerificationError vErr : this.m_errorList) {
            errorMsg = vErr.getErrorMessage();
            if (!VerificationUtil.isStringGood(errorMsg) || currentMsgSet.contains(errorMsg = errorMsg.trim())) continue;
            currentMsgSet.add(errorMsg);
            tempErrList.add(vErr);
        }
        this.m_errorList.clear();
        this.m_errorList.addAll(tempErrList);
        tempErrList.clear();
        currentMsgSet.clear();
        for (VerificationError vErr : this.m_uploadedErrorList) {
            errorMsg = vErr.getErrorMessage();
            if (!VerificationUtil.isStringGood(errorMsg) || currentMsgSet.contains(errorMsg = errorMsg.trim())) continue;
            currentMsgSet.add(errorMsg);
            tempErrList.add(vErr);
        }
        this.m_uploadedErrorList.clear();
        this.m_uploadedErrorList.addAll(tempErrList);
        if (!this.m_resultTable.isEmpty()) {
            e = this.m_resultTable.keys();
            while (e.hasMoreElements()) {
                key = (String)e.nextElement();
                obj = this.m_resultTable.get(key);
                if (!(obj instanceof Result)) continue;
                ((Result)obj).settle();
            }
        }
        if (!this.m_uploadedResultTable.isEmpty()) {
            e = this.m_uploadedResultTable.keys();
            while (e.hasMoreElements()) {
                key = (String)e.nextElement();
                obj = this.m_uploadedResultTable.get(key);
                if (!(obj instanceof Result)) continue;
                ((Result)obj).settle();
            }
        }
        this.setStatus();
        this.setUploadedStatus();
    }

    public int getStatus() {
        return this.getStatusConditionally(this.m_status, this.m_uploadedStatus);
    }

    public void setStatus(int status) {
        this.m_globalStatus = status;
        this.m_uploadedGlobalStatus = status;
        this.setStatus();
        this.setUploadedStatus();
    }

    public int getGlobalStatus() {
        return this.getStatusConditionally(this.m_globalStatus, this.m_uploadedGlobalStatus);
    }

    private int internalGetResultSetStatus(Hashtable resultTable, int altStatus) {
        boolean anySuccess = false;
        boolean anyVerificationFailure = false;
        boolean anyOperationFailure = false;
        boolean anyWarning = false;
        int returnStatus = 5;
        if (resultTable.size() == 0) {
            return 5;
        }
        Enumeration rt = resultTable.keys();
        while (rt.hasMoreElements()) {
            String node = (String)rt.nextElement();
            int status = ((Result)resultTable.get(node)).getStatus();
            if (status == 1) {
                anySuccess = true;
                continue;
            }
            if (status == 4) {
                anyWarning = true;
                continue;
            }
            if (status == 3) {
                anyVerificationFailure = true;
                continue;
            }
            if (status != 2) continue;
            anyOperationFailure = true;
        }
        if (altStatus == 1) {
            anySuccess = true;
        } else if (altStatus == 4) {
            anyWarning = true;
        } else if (altStatus == 3) {
            anyVerificationFailure = true;
        } else if (altStatus == 2) {
            anyOperationFailure = true;
        }
        returnStatus = anyOperationFailure ? 2 : (anyVerificationFailure ? 3 : (!anyWarning ? 1 : 4));
        return returnStatus;
    }

    public void setStatus() {
        if (this.m_resultTable.size() == 0) {
            Trace.out((String)("m_resultTable has size of zero, setting m_status to: " + ResultSet.resultsetStatusString(this.m_globalStatus) + "\n"));
            this.m_status = this.m_globalStatus;
        } else {
            this.m_status = this.internalGetResultSetStatus(this.m_resultTable, this.m_globalStatus);
        }
        this.setUploadedStatus();
    }

    public void setUploadedStatus() {
        this.m_uploadedStatus = this.m_uploadedResultTable.size() == 0 ? this.m_uploadedGlobalStatus : this.internalGetResultSetStatus(this.m_uploadedResultTable, this.m_uploadedGlobalStatus);
    }

    public int getStatusConditionally(int requestedStatus, int existStatus) {
        if (this.statusWeightage(requestedStatus) > this.statusWeightage(existStatus)) {
            return requestedStatus;
        }
        return existStatus;
    }

    private int statusWeightage(int status) {
        if (status == 5) {
            return 0;
        }
        if (status == 1) {
            return 10;
        }
        if (status == 4) {
            return 15;
        }
        if (status == 3) {
            return 20;
        }
        return 25;
    }

    public void uploadResultSet(ResultSet sourceResultSet) {
        this.uploadResultSet(sourceResultSet, false);
    }

    private void addResultTable(Hashtable targResultTable, Hashtable srcResultTable, boolean isDestContainer) {
        if (srcResultTable.size() == 0) {
            return;
        }
        Trace.out((String)("addResultTable, called from: " + VerificationUtil.getLocationInSource(true)));
        Trace.out((String)("Adding source result table size: '" + srcResultTable.size() + "'\nto target result table size: '" + targResultTable.size() + "'"));
        this.traceResultTable("TARGET ResultTable BEFORE ===>", targResultTable);
        this.traceResultTable("SOURCE ResultTable to ADD ===>", srcResultTable);
        Enumeration e = srcResultTable.keys();
        while (e.hasMoreElements()) {
            int status;
            String node = (String)e.nextElement();
            Result srcNodeRes = (Result)srcResultTable.get(node);
            Result curNodeRes = (Result)targResultTable.get(node);
            int currentStatus = status = srcNodeRes.getStatus();
            int currentStatusWeightage = 0;
            if (curNodeRes != null) {
                currentStatus = curNodeRes.getStatus();
                currentStatusWeightage = curNodeRes.getStatusWeightage();
            }
            if (curNodeRes == null) {
                targResultTable.put(node, new Result(node, status, srcNodeRes.getType()));
            } else {
                curNodeRes.setStatusConditionally(status);
            }
            if (!isDestContainer) {
                Vector uploadResultInfoSet;
                int size;
                Result destNodeRes = (Result)targResultTable.get(node);
                destNodeRes.addErrorDescription(srcNodeRes.getErrors());
                destNodeRes.addErrorInfo(srcNodeRes.getErrorInfoSet());
                destNodeRes.addVerificationMessages(srcNodeRes.getVerificationMessage());
                destNodeRes.setFixupAvailable(srcNodeRes.isFixupAvailable());
                if (srcNodeRes.hasResultValues()) {
                    destNodeRes.setHasResultValues(true);
                    try {
                        destNodeRes.setExpectedValue(srcNodeRes.getExpectedValue());
                        destNodeRes.setActualValue(srcNodeRes.getActualValue());
                    }
                    catch (ResultValuesUnavailableException rve) {
                        Trace.out((String)"ResultValuesUnavailableException thrown when hasResultValues() return true");
                    }
                } else {
                    new Result("Temp");
                    Trace.out((int)1, (String)("currentStatus: " + Result.resultStatusString(currentStatus) + "\nsrcNodeStatus: " + Result.resultStatusString(srcNodeRes.getStatus())));
                    if (currentStatusWeightage < srcNodeRes.getStatusWeightage()) {
                        destNodeRes.setHasResultValues(false);
                        destNodeRes.setExpectedValue(null);
                        destNodeRes.setActualValue(null);
                    }
                }
                if ((size = (uploadResultInfoSet = srcNodeRes.getResultInfoSet()).size()) > 0) {
                    for (int i = 0; i < size; ++i) {
                        destNodeRes.addResultInfo(uploadResultInfoSet.elementAt(i));
                    }
                }
                destNodeRes.addCollectionElements(srcNodeRes.getCollectionElements());
                if (!Trace.isLevelEnabled((int)1)) continue;
                if (curNodeRes != null) {
                    Trace.out((String)("\nUpdating CURRENT UPLOADED result:\n" + curNodeRes.traceResultInfo()));
                } else {
                    Trace.out((String)("\nNo current result for node: " + node));
                }
                Trace.out((String)("\nYielding NEW UPLOADED result:\n" + destNodeRes.traceResultInfo()));
                continue;
            }
            Trace.out((String)"srcNodeRes is for a container task.");
        }
        this.traceResultTable("TARGET ResultTable AFTER ===>", targResultTable);
    }

    public void uploadResultSet(ResultSet sourceResultSet, boolean isDestContainer) {
        if (Trace.isLevelEnabled((int)1)) {
            Trace.out((String)("uploadResultSet, called from: " + VerificationUtil.getLocationInSource(true)));
            this.traceResultSet("Target ResultSet BEFORE Upload===>");
            sourceResultSet.traceResultSet("Source ResultSet ===>");
        }
        this.addResultTable(this.m_uploadedResultTable, sourceResultSet.getUploadedResultTable(), isDestContainer);
        this.setUploadedStatus();
        if (this.m_status == 5) {
            this.m_status = this.m_uploadedStatus;
        }
        this.addResultTable(this.m_uploadedResultTable, sourceResultSet.getOperationalResultTable(), isDestContainer);
        this.setStatus();
        this.m_uploadedErrorList.addAll(sourceResultSet.getErrors());
        if (this.m_uploadedGlobalStatus != 1) {
            this.m_uploadedGlobalStatus = this.getStatusConditionally(this.m_uploadedGlobalStatus, sourceResultSet.getGlobalStatus());
        }
        this.m_uploadedMessageList.addAll(sourceResultSet.getVerificationMessages());
        this.m_uploadedCollectionList.addAll(sourceResultSet.getCollectionElements());
        this.traceResultSet("Target ResultSet AFTER Upload===>");
    }

    public void overwriteResultSet(ResultSet sourceResultSet) {
        Trace.out((String)("Overwriting ResultSet, called from: " + VerificationUtil.getLocationInSource(true)));
        this.clear();
        Hashtable t = sourceResultSet.getOperationalResultTable();
        if (t.size() > 0) {
            Enumeration e = t.keys();
            while (e.hasMoreElements()) {
                Vector srcResultInfoSet;
                int size;
                String node = (String)e.nextElement();
                Result srcNodeRes = (Result)t.get(node);
                int status = srcNodeRes.getStatus();
                this.addResult(node, status, srcNodeRes.getType());
                Result destNodeRes = (Result)this.m_resultTable.get(node);
                destNodeRes.addErrorDescription(srcNodeRes.getErrors());
                destNodeRes.addErrorInfo(srcNodeRes.getErrorInfoSet());
                destNodeRes.addVerificationMessages(srcNodeRes.getVerificationMessage());
                destNodeRes.setFixupAvailable(srcNodeRes.isFixupAvailable());
                if (srcNodeRes.hasResultValues()) {
                    destNodeRes.setHasResultValues(true);
                    try {
                        destNodeRes.setExpectedValue(srcNodeRes.getExpectedValue());
                        destNodeRes.setActualValue(srcNodeRes.getActualValue());
                    }
                    catch (ResultValuesUnavailableException rve) {
                        Trace.out((String)"ResultValuesUnavailableException thrown when hasResultValues() return true");
                    }
                }
                if ((size = (srcResultInfoSet = srcNodeRes.getResultInfoSet()).size()) > 0) {
                    for (int i = 0; i < size; ++i) {
                        destNodeRes.addResultInfo(srcResultInfoSet.elementAt(i));
                    }
                }
                destNodeRes.addCollectionElements(srcNodeRes.getCollectionElements());
            }
        }
        this.m_errorList.addAll(sourceResultSet.getErrors());
        if (this.m_globalStatus != 1) {
            this.m_globalStatus = sourceResultSet.getGlobalStatus();
        }
        this.setStatus();
        this.m_messageList.addAll(sourceResultSet.getVerificationMessages());
        this.m_collectionList.addAll(sourceResultSet.getCollectionElements());
        this.traceResultSet("ResultSet AFTER overwrite ===>");
    }

    public void addResultSetData(ResultSet sourceResultSet) {
        Trace.out((String)("addResultSetData, called from: " + VerificationUtil.getLocationInSource(true)));
        this.traceResultSet("ResultSet BEFORE adding ResultSet data ===>");
        sourceResultSet.traceResultSet("Source ResultSet ===>");
        Hashtable t = sourceResultSet.getResultTable();
        if (t.size() > 0) {
            Enumeration e = t.keys();
            while (e.hasMoreElements()) {
                Vector srcResultInfoSet;
                int size;
                String node = (String)e.nextElement();
                Result srcNodeRes = (Result)t.get(node);
                int status = srcNodeRes.getStatus();
                this.addResult(node, status, srcNodeRes.getType());
                Result destNodeRes = (Result)this.m_resultTable.get(node);
                destNodeRes.addErrorDescription(srcNodeRes.getErrors());
                destNodeRes.addErrorInfo(srcNodeRes.getErrorInfoSet());
                destNodeRes.addVerificationMessages(srcNodeRes.getVerificationMessage());
                destNodeRes.setFixupAvailable(srcNodeRes.isFixupAvailable());
                if (srcNodeRes.hasResultValues()) {
                    destNodeRes.setHasResultValues(true);
                    try {
                        destNodeRes.setExpectedValue(srcNodeRes.getExpectedValue());
                        destNodeRes.setActualValue(srcNodeRes.getActualValue());
                    }
                    catch (ResultValuesUnavailableException rve) {
                        Trace.out((String)"ResultValuesUnavailableException thrown when hasResultValues() return true");
                    }
                }
                if ((size = (srcResultInfoSet = srcNodeRes.getResultInfoSet()).size()) > 0) {
                    for (int i = 0; i < size; ++i) {
                        destNodeRes.addResultInfo(srcResultInfoSet.elementAt(i));
                    }
                }
                destNodeRes.addCollectionElements(srcNodeRes.getCollectionElements());
            }
        }
        this.addResultTable(this.m_resultTable, sourceResultSet.getUploadedResultTable(), false);
        this.m_errorList.addAll(sourceResultSet.getGlobalErrors());
        if (this.m_globalStatus != 1) {
            this.m_globalStatus = sourceResultSet.getGlobalStatus();
        }
        this.setStatus();
        this.setStatus(this.getStatusConditionally(this.m_status, sourceResultSet.getStatus()));
        this.m_messageList.addAll(sourceResultSet.getVerificationMessages());
        this.m_collectionList.addAll(sourceResultSet.getCollectionElements());
        this.traceResultSet("ResultSet AFTER adding ResultSet data ===>");
    }

    public void traceResultSet(String header) {
        boolean showDetails = this.m_status != 5 && this.m_status != 1 || Trace.isLevelEnabled((int)1);
        StringBuffer strBuf = new StringBuffer();
        strBuf.append("\n\n" + header + "\n\tOverall Status->" + ResultSet.resultsetStatusString(this.m_status) + "\n");
        strBuf.append("\n\tUploaded Overall Status->" + ResultSet.resultsetStatusString(this.m_uploadedStatus) + "\n");
        strBuf.append("\n\tGlobalErrors:\n");
        for (VerificationError globalError : this.m_errorList) {
            strBuf.append("\t" + ((ErrorDescription)globalError).getErrorMessage());
        }
        strBuf.append("\n\n\tUploadedGlobalErrors:\n");
        for (VerificationError uploadedGlobalError : this.m_uploadedErrorList) {
            strBuf.append("\t" + ((ErrorDescription)uploadedGlobalError).getErrorMessage());
        }
        strBuf.append("\n\n\tHasNodeResults:\n\t" + Boolean.toString(this.hasNodeResults()));
        if (showDetails) {
            Result result;
            String node;
            strBuf.append("\n\n\tcontents of resultTable\n");
            Enumeration e = this.m_resultTable.keys();
            while (e.hasMoreElements()) {
                node = (String)e.nextElement();
                result = (Result)this.m_resultTable.get(node);
                strBuf.append(result.traceResultInfo());
            }
            strBuf.append("\n\n\tcontents of uploadedResultTable\n");
            e = this.m_uploadedResultTable.keys();
            while (e.hasMoreElements()) {
                node = (String)e.nextElement();
                result = (Result)this.m_uploadedResultTable.get(node);
                strBuf.append(result.traceResultInfo());
            }
            strBuf.append("\n\n");
        }
        Trace.out((Object)strBuf);
    }

    public void traceResultTable(String header, Hashtable resultTable) {
        StringBuffer strBuf = new StringBuffer();
        strBuf.append("\n\n" + header + "\n");
        strBuf.append("\n\tcontents of resultTable\n");
        Enumeration e = resultTable.keys();
        while (e.hasMoreElements()) {
            String node = (String)e.nextElement();
            Result result = (Result)resultTable.get(node);
            strBuf.append(result.traceResultInfo());
        }
        strBuf.append("\n\n");
        Trace.out((Object)strBuf);
    }

    public static String resultsetStatusString(int status) {
        if (status == 1) {
            return "SUCCESSFUL";
        }
        if (status == 2) {
            return "OPERATION_FAILED";
        }
        if (status == 3) {
            return "VERIFICATION_FAILED";
        }
        if (status == 4) {
            return "WARNING";
        }
        if (status == 5) {
            return "UNKNOWN";
        }
        return "--ERROR--";
    }

    public static String resultsetStatusString(OverallStatus status) {
        return status.name();
    }

    public boolean anyFailure() {
        Hashtable completeResultTable = new Hashtable();
        this.addResultTable(completeResultTable, this.m_uploadedResultTable, false);
        this.addResultTable(completeResultTable, this.m_resultTable, false);
        Enumeration e = completeResultTable.keys();
        while (e.hasMoreElements()) {
            String node = (String)e.nextElement();
            int status = ((Result)completeResultTable.get(node)).getStatus();
            if (status == 1 || status == 4 || status == 6) continue;
            return true;
        }
        return false;
    }

    public boolean allSuccess() {
        if (this.m_status == 5) {
            return this.m_uploadedStatus == 1 || this.m_uploadedStatus == 4;
        }
        int testStatus = this.getStatusConditionally(this.m_status, this.m_uploadedStatus);
        return testStatus == 1 || testStatus == 4;
    }

    public boolean operationalSuccess() {
        if (this.m_status != 5) {
            return this.m_status == 1 || this.m_status == 4;
        }
        this.traceResultSet("OPERATIONAL SUCCESS FAILED===>");
        return this.m_uploadedStatus == 1 || this.m_uploadedStatus == 4;
    }

    public boolean anySuccess() {
        if (!(this.m_status != 1 && this.m_status != 4 || this.m_uploadedStatus != 1 && this.m_uploadedStatus != 4)) {
            return true;
        }
        Hashtable completeResultTable = new Hashtable();
        this.addResultTable(completeResultTable, this.m_uploadedResultTable, false);
        this.addResultTable(completeResultTable, this.m_resultTable, false);
        Enumeration e = completeResultTable.keys();
        while (e.hasMoreElements()) {
            String node = (String)e.nextElement();
            int status = ((Result)completeResultTable.get(node)).getStatus();
            if (status != 1 && status != 4) continue;
            return true;
        }
        return false;
    }

    public boolean anyWarning() {
        Hashtable completeResultTable = new Hashtable();
        this.addResultTable(completeResultTable, this.m_uploadedResultTable, false);
        this.addResultTable(completeResultTable, this.m_resultTable, false);
        Enumeration e = completeResultTable.keys();
        while (e.hasMoreElements()) {
            String node = (String)e.nextElement();
            int status = ((Result)completeResultTable.get(node)).getStatus();
            if (status != 4) continue;
            return true;
        }
        return false;
    }

    public String[] getNodesWithStatus(int status) {
        ArrayList<String> nodeVect = new ArrayList<String>();
        Hashtable completeResultTable = new Hashtable();
        this.addResultTable(completeResultTable, this.m_uploadedResultTable, false);
        this.addResultTable(completeResultTable, this.m_resultTable, false);
        Enumeration e = completeResultTable.keys();
        while (e.hasMoreElements()) {
            String node = (String)e.nextElement();
            int resultStatus = ((Result)completeResultTable.get(node)).getStatus();
            if (resultStatus != status || nodeVect.contains(node)) continue;
            nodeVect.add(node);
        }
        return nodeVect.toArray(new String[nodeVect.size()]);
    }

    public String[] getFailureNodes() {
        return this.getFailureByType(ResultKeyType.NODE);
    }

    public String[] getFailureASMParameters() {
        return this.getFailureByType(ResultKeyType.ASMPARAMETERS);
    }

    public String[] getFailureASMInstances() {
        return this.getFailureByType(ResultKeyType.ASMINSTANCE);
    }

    public String[] getFailureASMDiskGroups() {
        return this.getFailureByType(ResultKeyType.ASMDISKGROUP);
    }

    public String[] getFailureASMDisks() {
        return this.getFailureByType(ResultKeyType.ASMDISK);
    }

    public String[] getFailureDatabases() {
        return this.getFailureByType(ResultKeyType.DB);
    }

    public String[] getFailureDatabaseInstances() {
        return this.getFailureByType(ResultKeyType.DB_INSTANCE);
    }

    public String[] getFailureByType(ResultKeyType type) {
        ArrayList<String> errorVect = new ArrayList<String>();
        Hashtable completeResultTable = new Hashtable();
        this.addResultTable(completeResultTable, this.m_uploadedResultTable, false);
        this.addResultTable(completeResultTable, this.m_resultTable, false);
        Enumeration e = completeResultTable.keys();
        while (e.hasMoreElements()) {
            int resultStatus;
            String entity = (String)e.nextElement();
            if (((Result)completeResultTable.get(entity)).getType() != type || (resultStatus = ((Result)completeResultTable.get(entity)).getStatus()) == 1 || resultStatus == 4 || resultStatus == 6 || errorVect.contains(entity)) continue;
            errorVect.add(entity);
        }
        return errorVect.toArray(new String[errorVect.size()]);
    }

    public String[] getSuccessByType(ResultKeyType type) {
        ArrayList<String> succVect = new ArrayList<String>();
        Hashtable completeResultTable = new Hashtable();
        this.addResultTable(completeResultTable, this.m_uploadedResultTable, false);
        this.addResultTable(completeResultTable, this.m_resultTable, false);
        Enumeration e = completeResultTable.keys();
        while (e.hasMoreElements()) {
            int resultStatus;
            String entity = (String)e.nextElement();
            if (((Result)completeResultTable.get(entity)).getType() != type || (resultStatus = ((Result)completeResultTable.get(entity)).getStatus()) != 1 && resultStatus != 4 || succVect.contains(entity)) continue;
            succVect.add(entity);
        }
        return succVect.toArray(new String[succVect.size()]);
    }

    public String[] getNotAppByType(ResultKeyType type) {
        ArrayList<String> naVect = new ArrayList<String>();
        Hashtable completeResultTable = new Hashtable();
        this.addResultTable(completeResultTable, this.m_uploadedResultTable, false);
        this.addResultTable(completeResultTable, this.m_resultTable, false);
        Enumeration e = completeResultTable.keys();
        while (e.hasMoreElements()) {
            int resultStatus;
            String entity = (String)e.nextElement();
            if (((Result)completeResultTable.get(entity)).getType() != type || (resultStatus = ((Result)completeResultTable.get(entity)).getStatus()) != 6 || naVect.contains(entity)) continue;
            naVect.add(entity);
        }
        return naVect.toArray(new String[naVect.size()]);
    }

    public void getSuccNodes(Collection succNodes, Collection otherNodes) {
        ArrayList<String> succNodesLocal = new ArrayList<String>();
        Trace.out((String)"Checking for Success nodes from in the ResultSet hashtables");
        succNodes.clear();
        otherNodes.clear();
        Hashtable completeResultTable = new Hashtable();
        this.addResultTable(completeResultTable, this.m_uploadedResultTable, false);
        this.addResultTable(completeResultTable, this.m_resultTable, false);
        Enumeration e = completeResultTable.keys();
        while (e.hasMoreElements()) {
            String node = (String)e.nextElement();
            int resultStatus = ((Result)completeResultTable.get(node)).getStatus();
            if (resultStatus == 1 || resultStatus == 4) {
                Trace.out((String)("Adding node " + node + " to list of Succ nodes"));
                succNodesLocal.add(node);
                continue;
            }
            otherNodes.add(node);
        }
        if (succNodesLocal.contains(VerificationUtil.getLocalNode())) {
            succNodesLocal.remove(VerificationUtil.getLocalNode());
            succNodesLocal.add(0, VerificationUtil.getLocalNode());
        }
        succNodes.addAll(succNodesLocal);
    }

    public void getFailNodes(Collection failNodes, Collection otherNodes) {
        Trace.out((String)"Checking for FAILED nodes from in the ResultSet hashtables");
        failNodes.clear();
        otherNodes.clear();
        Hashtable completeResultTable = new Hashtable();
        this.addResultTable(completeResultTable, this.m_uploadedResultTable, false);
        this.addResultTable(completeResultTable, this.m_resultTable, false);
        Enumeration e = completeResultTable.keys();
        while (e.hasMoreElements()) {
            String node = (String)e.nextElement();
            int resultStatus = ((Result)completeResultTable.get(node)).getStatus();
            if (resultStatus == 3) {
                Trace.out((String)("Adding node " + node + " to list of FAILED nodes"));
                failNodes.add(node);
                continue;
            }
            otherNodes.add(node);
        }
    }

    public void getUnknownNodes(Collection unknNodes, Collection otherNodes) {
        Trace.out((String)"Checking for UNKNOWN nodes from in the ResultSet hashtables");
        unknNodes.clear();
        otherNodes.clear();
        Hashtable completeResultTable = new Hashtable();
        this.addResultTable(completeResultTable, this.m_uploadedResultTable, false);
        this.addResultTable(completeResultTable, this.m_resultTable, false);
        Enumeration e = completeResultTable.keys();
        while (e.hasMoreElements()) {
            String node = (String)e.nextElement();
            int resultStatus = ((Result)completeResultTable.get(node)).getStatus();
            if (resultStatus != 1 && resultStatus != 3 && resultStatus != 4) {
                Trace.out((String)("Adding node " + node + " to list of UNKNOWN nodes"));
                unknNodes.add(node);
                continue;
            }
            otherNodes.add(node);
        }
    }

    public List<String> getNotApplicableNodes() {
        ArrayList<String> notApplicableNodes = new ArrayList<String>();
        Hashtable completeResultTable = new Hashtable();
        Trace.out((String)"Checking for the not applicable nodes from in the ResultSet hashtables");
        this.addResultTable(completeResultTable, this.m_uploadedResultTable, false);
        this.addResultTable(completeResultTable, this.m_resultTable, false);
        Enumeration e = completeResultTable.keys();
        while (e.hasMoreElements()) {
            String node = (String)e.nextElement();
            int resultStatus = ((Result)completeResultTable.get(node)).getStatus();
            if (resultStatus != 6) continue;
            Trace.out((String)("Adding node " + node + " to list of not applicable nodes"));
            notApplicableNodes.add(node);
        }
        return notApplicableNodes;
    }

    public void filterResult(Collection succNodes, Collection failNodes, Collection unknNodes) {
        Vector otherNodes = new Vector();
        Trace.out((String)"Getting succNodes list");
        this.getSuccNodes(succNodes, otherNodes);
        otherNodes.clear();
        Trace.out((String)"Getting failNodes list");
        this.getFailNodes(failNodes, otherNodes);
        otherNodes.clear();
        Trace.out((String)"Getting unknown Nodes list");
        this.getUnknownNodes(unknNodes, otherNodes);
    }

    public void addResult(String node, Result result) {
        Result localResult = (Result)this.m_resultTable.get(node);
        if (Trace.isLevelEnabled((int)1)) {
            Trace.out((String)"Adding result/resultinfo data: ");
            result.dumpResultInfo();
        }
        this.traceResultSet("ResultSet BEFORE adding Result data ===>");
        if (localResult != null) {
            if (localResult.getStatusWeightage() < result.getStatusWeightage()) {
                this.m_resultTable.put(node, result);
                this.setStatus();
            }
        } else {
            this.m_resultTable.put(node, result);
            this.setStatus();
        }
        this.traceResultSet("ResultSet AFTER adding Result data ===>");
    }

    public void addUploadedResult(String node, int status) {
        Result result = (Result)this.m_uploadedResultTable.get(node);
        if (result == null) {
            this.m_uploadedResultTable.put(node, new Result(node, status));
        } else {
            result.setStatusConditionally(status);
        }
        this.setUploadedStatus();
    }

    public void addResult(String node) {
        this.addResult(node, 5);
    }

    public void addResult(String node, int status) {
        this.addResult(new String[]{node}, status);
    }

    public void addResult(String nameKey, int status, ResultKeyType type) {
        this.addResult(new String[]{nameKey}, status, type);
    }

    public void addResult(String[] nodeArr, int status) {
        this.addResult(Arrays.asList(nodeArr), status);
    }

    public void addResult(String[] nameKeys, int status, ResultKeyType type) {
        this.addResult(Arrays.asList(nameKeys), status, type);
    }

    public void addResult(Collection nodes, int status) {
        this.addResult(nodes, status, ResultKeyType.NODE);
    }

    public void addResult(Collection nameKey, int status, ResultKeyType type) {
        for (Object name : nameKey) {
            if (!this.m_resultTable.containsKey(name)) {
                this.m_resultTable.put(name, new Result(name.toString(), status, type));
                continue;
            }
            ((Result)this.m_resultTable.get(name)).setStatusConditionally(status);
        }
        this.setStatus();
    }

    public void addResult(String[] nodeArr) {
        this.addResult(nodeArr, 5);
    }

    public Result getResult(String node) {
        Result result = (Result)this.m_resultTable.get(node);
        if (result == null) {
            result = (Result)this.m_uploadedResultTable.get(node);
        }
        return result;
    }

    public Hashtable getOperationalResultTable() {
        return this.m_resultTable;
    }

    public Hashtable getResultTable() {
        Hashtable localResultTable = new Hashtable();
        localResultTable.putAll(this.m_uploadedResultTable);
        localResultTable.putAll(this.m_resultTable);
        return localResultTable;
    }

    public Hashtable getUploadedResultTable() {
        return this.m_uploadedResultTable;
    }

    public String[] getSuccNodes() {
        Vector succNodes = new Vector();
        Vector otherNodes = new Vector();
        this.getSuccNodes(succNodes, otherNodes);
        int arrSize = succNodes.size();
        return succNodes.toArray(new String[arrSize]);
    }

    @Override
    public List<String> getFailedNodes() {
        return Arrays.asList(this.getFailureNodes());
    }

    @Override
    public List<String> getSuccessfulNodes() {
        return Arrays.asList(this.getSuccNodes());
    }

    @Override
    public OverallStatus getOverallStatus() {
        int localStatus = this.getStatusConditionally(this.m_status, this.m_uploadedStatus);
        if (localStatus == 1) {
            return OverallStatus.SUCCESSFUL;
        }
        if (localStatus == 2) {
            return OverallStatus.OPERATION_FAILED;
        }
        if (localStatus == 3) {
            return OverallStatus.VERIFICATION_FAILED;
        }
        if (localStatus == 4) {
            return OverallStatus.WARNING;
        }
        return OverallStatus.UNKNOWN;
    }

    @Override
    public boolean hasNodeResults() {
        if (this.m_status == 5 && this.m_uploadedStatus == 5) {
            return false;
        }
        return this.m_hasNodeResults;
    }

    @Override
    public List<VerificationResult> getNodeResults() throws NodeResultsUnavailableException {
        int tableSize = this.m_resultTable.size() + this.m_uploadedResultTable.size();
        ArrayList<VerificationResult> localList = new ArrayList<VerificationResult>();
        List<Object> resultList = null;
        List<VerificationResult> uploadedResultList = null;
        if (!this.hasNodeResults() || tableSize == 0) {
            Trace.out((String)("hasNodeResults: " + this.hasNodeResults() + " tableSize: '" + tableSize + "'"));
            throw new NodeResultsUnavailableException(s_msgBundle.getMessage("7503", false));
        }
        if (this.m_resultTable.size() != 0) {
            if (this.m_uploadedResultTable.size() != 0) {
                resultList = new ArrayList();
                Enumeration e = this.m_resultTable.keys();
                while (e.hasMoreElements()) {
                    String node = (String)e.nextElement();
                    if (this.m_uploadedResultTable.containsKey(node)) {
                        Result nodeRes = (Result)this.m_resultTable.get(node);
                        Result upNodeRes = (Result)this.m_uploadedResultTable.get(node);
                        if (nodeRes.getStatusWeightage() < upNodeRes.getStatusWeightage()) {
                            resultList.add(upNodeRes);
                            continue;
                        }
                        resultList.add(nodeRes);
                        continue;
                    }
                    resultList.add((VerificationResult)this.m_resultTable.get(node));
                }
            } else {
                resultList = Arrays.asList(this.m_resultTable.values().toArray(new VerificationResult[this.m_resultTable.size()]));
            }
            localList.addAll(resultList);
            Trace.out((String)("ResultList size: " + resultList.size() + " localList size: " + localList.size()));
        }
        if (this.m_uploadedResultTable.size() != 0) {
            Hashtable<String, Result> additionalResults = new Hashtable<String, Result>();
            Enumeration e = this.m_uploadedResultTable.keys();
            while (e.hasMoreElements()) {
                String node = (String)e.nextElement();
                Result uploadedResult = (Result)this.m_uploadedResultTable.get(node);
                if (this.m_resultTable.containsKey(node)) continue;
                additionalResults.put(node, uploadedResult);
            }
            if (additionalResults.size() != 0) {
                uploadedResultList = Arrays.asList(additionalResults.values().toArray(new VerificationResult[additionalResults.size()]));
                localList.addAll(uploadedResultList);
                Trace.out((String)("unique uploadedResultList size: " + uploadedResultList.size() + " localList size: " + localList.size()));
            }
        }
        return localList;
    }

    public List<VerificationResult> getOperationalNodeResults() throws NodeResultsUnavailableException {
        int tableSize = this.m_resultTable.size();
        if (!this.hasNodeResults() || tableSize == 0) {
            Trace.out((String)("hasNodeResults: " + this.hasNodeResults() + " tableSize: '" + tableSize + "'"));
            throw new NodeResultsUnavailableException(s_msgBundle.getMessage("7503", false));
        }
        return Arrays.asList(this.m_resultTable.values().toArray(new VerificationResult[this.m_resultTable.size()]));
    }

    @Override
    public VerificationResult getNodeResult(String node) throws NodeResultsUnavailableException {
        return this.getNodeResult(node, false);
    }

    public VerificationResult getNodeResult(String node, boolean addGlobalErrors) throws NodeResultsUnavailableException {
        if (this.hasNodeResults()) {
            Result nodeRes = (Result)this.m_resultTable.get(node);
            Result uploadNodeRes = (Result)this.m_uploadedResultTable.get(node);
            if (nodeRes == null) {
                nodeRes = uploadNodeRes;
            } else if (uploadNodeRes != null && nodeRes.getStatusWeightage() < uploadNodeRes.getStatusWeightage()) {
                nodeRes = uploadNodeRes;
            }
            if (nodeRes == null) {
                Trace.out((String)"NODERESULTSUNAVAILABLE when results expected!");
                throw new NodeResultsUnavailableException(s_msgBundle.getMessage("7503", false));
            }
            if (addGlobalErrors) {
                nodeRes.addErrorDescription(this.getErrors());
            }
            return nodeRes;
        }
        throw new NodeResultsUnavailableException(s_msgBundle.getMessage("7503", false));
    }

    public List<VerificationError> getOperationalErrors() {
        return this.m_errorList;
    }

    @Override
    public List<VerificationError> getErrors() {
        ArrayList<VerificationError> localErrorList = new ArrayList<VerificationError>();
        localErrorList.addAll(this.m_errorList);
        localErrorList.addAll(this.m_uploadedErrorList);
        if (VerificationUtil.isAPIMode() && this.hasNodeResults()) {
            Result resultObj;
            Set nameSet = this.m_resultTable.keySet();
            for (String name : nameSet) {
                resultObj = (Result)this.m_resultTable.get(name);
                if (resultObj.getType() == ResultKeyType.NODE) continue;
                localErrorList.addAll(resultObj.getErrors());
            }
            nameSet = this.m_uploadedResultTable.keySet();
            for (String name : nameSet) {
                resultObj = (Result)this.m_uploadedResultTable.get(name);
                if (resultObj.getType() == ResultKeyType.NODE) continue;
                localErrorList.addAll(resultObj.getErrors());
            }
        }
        return localErrorList;
    }

    public List<VerificationError> getGlobalErrors() {
        ArrayList<VerificationError> localErrorList = new ArrayList<VerificationError>();
        localErrorList.addAll(this.m_errorList);
        localErrorList.addAll(this.m_uploadedErrorList);
        return localErrorList;
    }

    public List<VerificationError> getGlobalAndNodeErrorList() {
        ArrayList<VerificationError> allErrorList = new ArrayList<VerificationError>();
        allErrorList.addAll(this.m_errorList);
        allErrorList.addAll(this.m_uploadedErrorList);
        if (this.hasNodeResults()) {
            Set nodeSet = this.m_resultTable.keySet();
            for (String node : nodeSet) {
                allErrorList.addAll(((Result)this.m_resultTable.get(node)).getErrors());
            }
            nodeSet = this.m_uploadedResultTable.keySet();
            for (String node : nodeSet) {
                allErrorList.addAll(((Result)this.m_uploadedResultTable.get(node)).getErrors());
            }
        }
        return allErrorList;
    }

    public String getAllErrorsStr() {
        return VerificationUtil.errorCollection2String(this.getGlobalAndNodeErrorList());
    }

    public void addErrorDescription(ErrorDescription errorDesc) {
        this.m_errorList.add(errorDesc);
        VerificationLogData.logError(errorDesc.getErrorMessage());
    }

    public void addErrorDescription(String node, ErrorDescription errorDesc) {
        Result result = (Result)this.m_resultTable.get(node);
        if (result == null) {
            result = new Result(node);
        }
        this.m_resultTable.put(node, result);
        result.addErrorDescription(errorDesc);
    }

    public void addErrorDescription(String node, List<ErrorDescription> errDescList) {
        Result result = (Result)this.m_resultTable.get(node);
        if (result == null) {
            result = new Result(node);
        }
        this.m_resultTable.put(node, result);
        for (ErrorDescription errDesc : errDescList) {
            result.addErrorDescription(errDesc);
        }
    }

    public void addErrorDescription(String[] nodeList, ErrorDescription errorDesc) {
        for (String node : nodeList) {
            this.addErrorDescription(node, errorDesc);
        }
    }

    public void addErrorDescription(Collection nodeList, ErrorDescription errorDesc) {
        for (Object node : nodeList) {
            this.addErrorDescription(node.toString(), errorDesc);
        }
    }

    public void addErrorDescriptions(String node, Set<ErrorDescription> errorDescs) {
        Result result = (Result)this.m_resultTable.get(node);
        if (result == null) {
            result = new Result(node);
        }
        this.m_resultTable.put(node, result);
        for (ErrorDescription errorDescription : errorDescs) {
            result.addErrorDescription(errorDescription);
        }
    }

    public void setHasNodeResults(boolean hasNodeResults) {
        this.m_hasNodeResults = hasNodeResults;
    }

    public void clear() {
        this.m_status = 5;
        this.m_resultTable.clear();
        this.m_hasNodeResults = true;
        this.m_errorList.clear();
        this.m_messageList.clear();
        this.m_collectionList.clear();
        this.m_uploadedStatus = 5;
        this.m_uploadedResultTable.clear();
        this.m_uploadedErrorList.clear();
        this.m_uploadedMessageList.clear();
        this.m_uploadedCollectionList.clear();
    }

    public String getResultSummary() {
        return this.m_summary;
    }

    public void setResultSummary(String summary) {
        this.m_summary = summary;
    }

    public void addVerificationMessage(VerificationMessage msg) {
        this.m_messageList.add(msg);
    }

    public List<VerificationMessage> getVerificationMessages() {
        ArrayList<VerificationMessage> localMessageList = new ArrayList<VerificationMessage>();
        localMessageList.addAll(this.m_messageList);
        localMessageList.addAll(this.m_uploadedMessageList);
        return localMessageList;
    }

    public void addCollectionElement(CollectionElement element) {
        this.m_collectionList.add(element);
    }

    public void addCollectionElements(List<CollectionElement> elementList) {
        this.m_collectionList.addAll(elementList);
    }

    public void addCollectionElement(String node, CollectionElement element) {
        this.addCollectionElement(node, element, null);
    }

    public void addCollectionElement(String node, CollectionElement element, ResultKeyType resultKeyType) {
        Result result = (Result)this.m_resultTable.get(node);
        if (result == null) {
            result = resultKeyType == null ? new Result(node) : new Result(node, resultKeyType);
        }
        this.m_resultTable.put(node, result);
        result.addCollectionElement(element);
    }

    public List<CollectionElement> getCollectionElements() {
        ArrayList<CollectionElement> localCollectionList = new ArrayList<CollectionElement>();
        localCollectionList.addAll(this.m_collectionList);
        localCollectionList.addAll(this.m_uploadedCollectionList);
        return localCollectionList;
    }

    public static void updateResultSetWithErrorDescription(String errorMessage, ResultSet resultSet, String[] nodeList, boolean verificationFailed, boolean printError) {
        if (!VerificationUtil.isStringGood(errorMessage)) {
            return;
        }
        Trace.out((String)("Error message " + errorMessage));
        ErrorDescription errorDescription = new ErrorDescription(errorMessage);
        if (verificationFailed) {
            resultSet.addResult(nodeList, 3);
        } else {
            resultSet.addResult(nodeList, 2);
        }
        resultSet.addErrorDescription(errorDescription);
        if (printError) {
            ReportUtil.printError(errorDescription.getErrorMessage());
        }
    }

    public void turnAllErrorsToWarnings() {
        int status;
        Result r;
        String node;
        Trace.out((String)"Turning all result set errors into warnings...");
        if (this.m_globalStatus == 3 || this.m_globalStatus == 2) {
            this.m_globalStatus = 4;
        }
        if (this.m_uploadedGlobalStatus == 3 || this.m_uploadedGlobalStatus == 2) {
            this.m_uploadedGlobalStatus = 4;
        }
        this.m_status = 4;
        this.m_uploadedStatus = 4;
        if (this.m_resultTable.size() != 0) {
            Enumeration rt = this.m_resultTable.keys();
            while (rt.hasMoreElements()) {
                node = (String)rt.nextElement();
                r = (Result)this.m_resultTable.get(node);
                status = r.getStatus();
                if (status != 3 && status != 2) continue;
                r.setStatus(4);
            }
        }
        if (this.m_uploadedResultTable.size() != 0) {
            Enumeration urt = this.m_uploadedResultTable.keys();
            while (urt.hasMoreElements()) {
                node = (String)urt.nextElement();
                r = (Result)this.m_uploadedResultTable.get(node);
                status = r.getStatus();
                if (status != 3 && status != 2) continue;
                r.setStatus(4);
            }
        }
        this.setStatus();
        this.setUploadedStatus();
        Trace.out((String)("Turned all result set errors into warnings. m_status: '" + ResultSet.resultsetStatusString(this.m_status) + "' m_uploadedStatus: '" + ResultSet.resultsetStatusString(this.m_uploadedStatus) + "'"));
    }
}

