/*
 * Decompiled with CFR 0.152.
 */
package oracle.ops.verification.framework.engine;

import oracle.ops.mgmt.trace.Trace;

public enum ResultKeyType {
    NODE("Node"),
    ASMPARAMETERS("ASM Parameters"),
    ASMINSTANCE("ASM Instances"),
    ASMDISKGROUP("ASM Diskgroups"),
    ASMDISK("ASM Disks"),
    ASM("ASM"),
    DB("Database"),
    DB_INSTANCE("Database Instance");

    private String m_resultKeyStr;

    private ResultKeyType(String resultKeyStr) {
        this.m_resultKeyStr = resultKeyStr;
    }

    public String getResultKeyStr() {
        return this.m_resultKeyStr;
    }

    public static ResultKeyType getResultKeyType(String resultKeyString) {
        if (NODE.getResultKeyStr().equals(resultKeyString)) {
            return NODE;
        }
        if (ASMPARAMETERS.getResultKeyStr().equals(resultKeyString)) {
            return ASMPARAMETERS;
        }
        if (ASMINSTANCE.getResultKeyStr().equals(resultKeyString)) {
            return ASMINSTANCE;
        }
        if (ASMDISKGROUP.getResultKeyStr().equals(resultKeyString)) {
            return ASMDISKGROUP;
        }
        if (ASMDISK.getResultKeyStr().equals(resultKeyString)) {
            return ASMDISK;
        }
        if (ASM.getResultKeyStr().equals(resultKeyString)) {
            return ASM;
        }
        if (DB.getResultKeyStr().equals(resultKeyString)) {
            return DB;
        }
        if (DB_INSTANCE.getResultKeyStr().equals(resultKeyString)) {
            return DB_INSTANCE;
        }
        Trace.out((String)("resKeyString unknown: '" + resultKeyString + "'. returning NODE as default"));
        return NODE;
    }
}

