/*
 * Decompiled with CFR 0.152.
 */
package oracle.ops.verification.framework.engine;

import oracle.cluster.verification.VerificationError;
import oracle.ops.mgmt.nls.MessageBundle;
import oracle.ops.mgmt.trace.Trace;
import oracle.ops.verification.framework.util.VerificationUtil;

public class ErrorDescription
implements VerificationError {
    private static MessageBundle s_prvfMsgBundle = VerificationUtil.getMessageBundle("Prvf");
    private static MessageBundle s_prkcMsgBundle = VerificationUtil.getMessageBundle("Prkc");
    private static MessageBundle s_prvgMsgBundle = VerificationUtil.getMessageBundle("Prvg");
    private static MessageBundle s_prveMsgBundle = VerificationUtil.getMessageBundle("Prve");
    private String m_errorMsg = s_prvfMsgBundle.getMessage("7505", false);
    private String m_cause = s_prvfMsgBundle.getMessage("7506", false);
    private String m_action = s_prvfMsgBundle.getMessage("7507", false);
    private boolean m_isWarning = false;

    public ErrorDescription() {
    }

    public ErrorDescription(String errorMsg) {
        this.setErrorMessage(errorMsg);
        if (errorMsg != null && (errorMsg.startsWith("PRKC-") || errorMsg.startsWith("PRVF-") || errorMsg.startsWith("PRVG-") || errorMsg.startsWith("PRVE-"))) {
            MessageBundle messageBundle = null;
            String facility = null;
            if (errorMsg.startsWith("PRKC-")) {
                messageBundle = s_prkcMsgBundle;
                facility = "PRKC-";
            } else if (errorMsg.startsWith("PRVF-")) {
                messageBundle = s_prvfMsgBundle;
                facility = "PRVF-";
            } else if (errorMsg.startsWith("PRVG-")) {
                messageBundle = s_prvgMsgBundle;
                facility = "PRVG-";
            } else if (errorMsg.startsWith("PRVE-")) {
                messageBundle = s_prveMsgBundle;
                facility = "PRVE-";
            }
            String messageKey = errorMsg.substring(facility.length()).split(":", 2)[0].trim();
            this.m_cause = messageBundle.getCause(messageKey, false);
            this.m_action = messageBundle.getAction(messageKey, false);
        }
    }

    public ErrorDescription(String errorMsg, String cause, String action) {
        this.setErrorMessage(errorMsg);
        this.setCause(cause);
        this.setAction(action);
    }

    public ErrorDescription(String errorMsg, MessageBundle msgBundle, String msgId) {
        String action;
        this.setErrorMessage(errorMsg);
        String cause = msgBundle.getCause(msgId, false);
        if (cause != null && cause.trim().length() > 0) {
            this.setCause(cause);
        }
        if ((action = msgBundle.getAction(msgId, false)) != null && action.trim().length() > 0) {
            this.setAction(action);
        }
    }

    public ErrorDescription(String msgId, MessageBundle msgBundle) {
        String action;
        this.setErrorMessage(msgBundle.getMessage(msgId, true));
        String cause = msgBundle.getCause(msgId, false);
        if (cause != null && cause.trim().length() > 0) {
            this.setCause(cause);
        }
        if ((action = msgBundle.getAction(msgId, false)) != null && action.trim().length() > 0) {
            this.setAction(action);
        }
    }

    public ErrorDescription(String msgId, String[] msgArgs, MessageBundle msgBundle) {
        String action;
        this.setErrorMessage(msgBundle.getMessage(msgId, true, (Object[])msgArgs));
        String cause = msgBundle.getCause(msgId, false);
        if (cause != null && cause.trim().length() > 0) {
            this.setCause(cause);
        }
        if ((action = msgBundle.getAction(msgId, false)) != null && action.trim().length() > 0) {
            this.setAction(action);
        }
    }

    public void setCauseAction(String key) {
        if (key != null) {
            if (key.startsWith("PRVF-")) {
                this.m_cause = s_prvfMsgBundle.getCause(key, false);
                this.m_action = s_prvfMsgBundle.getAction(key, false);
            } else if (key.startsWith("PRVG-")) {
                this.m_cause = s_prvgMsgBundle.getCause(key, false);
                this.m_action = s_prvgMsgBundle.getAction(key, false);
            } else if (key.startsWith("PRVE-")) {
                this.m_cause = s_prveMsgBundle.getCause(key, false);
                this.m_action = s_prveMsgBundle.getAction(key, false);
            }
        }
    }

    @Override
    public String getErrorMessage() {
        return this.m_errorMsg;
    }

    @Override
    public String getCause() {
        return this.m_cause;
    }

    @Override
    public String getAction() {
        return this.m_action;
    }

    public void setErrorMessage(String errorMsg) {
        if (errorMsg != null) {
            this.m_errorMsg = errorMsg;
        }
    }

    public void setCause(String cause) {
        if (cause != null) {
            this.m_cause = cause;
        }
    }

    public void setAction(String action) {
        if (action != null) {
            this.m_action = action;
        }
    }

    public void setWarning(boolean isWarning) {
        Trace.out((String)"Setting m_isWarning='%s'", (Object[])new Object[]{isWarning});
        this.m_isWarning = isWarning;
    }

    @Override
    public boolean isWarning() {
        return this.m_isWarning;
    }

    public void setWarning() {
        this.setWarning(true);
    }
}

