/*
 * Decompiled with CFR 0.152.
 */
package oracle.ops.verification.framework.engine;

import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import oracle.cluster.verification.ClusterwideCollectionUnavailableException;
import oracle.cluster.verification.CollectionResult;
import oracle.cluster.verification.CollectionResultSet;
import oracle.ops.verification.framework.engine.CollectionResultImpl;
import oracle.ops.verification.framework.engine.Result;
import oracle.ops.verification.framework.engine.ResultSet;

public class CollectionResultSetImpl<T>
extends ResultSet
implements CollectionResultSet {
    private T m_collectedClusterwideData;

    @Override
    public boolean hasClusterwideDataCollection() {
        return this.m_collectedClusterwideData != null;
    }

    @Override
    public T getCollectedClusterwideValue() throws ClusterwideCollectionUnavailableException {
        if (this.m_collectedClusterwideData != null) {
            return this.m_collectedClusterwideData;
        }
        throw new ClusterwideCollectionUnavailableException(s_gMsgBundle.getMessage("10530", true, (Object[])new String[]{"cluster-wide-collection-missing"}));
    }

    public void setCollectedClusterwideData(T collectedClusterwideData) {
        this.m_collectedClusterwideData = collectedClusterwideData;
    }

    @Override
    public HashMap<String, CollectionResult<T>> getNodeCollectionResults() {
        HashMap<String, CollectionResult<T>> mapNodeRes = new HashMap<String, CollectionResult<T>>();
        Enumeration e = this.m_resultTable.keys();
        while (e.hasMoreElements()) {
            String node = (String)e.nextElement();
            mapNodeRes.put(node, (CollectionResult)this.m_resultTable.get(node));
        }
        return mapNodeRes;
    }

    public void addResult(String node, CollectionResultImpl<T> colRes) {
        super.addResult(node, colRes);
    }

    public void addCollectedData(String node, T collectedData) {
        CollectionResultImpl<T> colRes = new CollectionResultImpl<T>(node, 1);
        colRes.setCollectedData(collectedData);
        super.addResult(node, colRes);
    }

    @Override
    public void addResult(Collection nodes, int status) {
        for (Object node : nodes) {
            Result result = (Result)this.m_resultTable.get(node);
            if (result == null) {
                this.m_resultTable.put(node, new CollectionResultImpl(node.toString(), status));
                continue;
            }
            result.setStatusConditionally(status);
        }
        this.setStatus();
    }

    @Override
    public void clear() {
        super.clear();
        this.m_collectedClusterwideData = null;
    }
}

