/*
 * Decompiled with CFR 0.152.
 */
package oracle.ops.verification.framework.config;

import java.util.Hashtable;
import oracle.ops.mgmt.trace.Trace;
import oracle.ops.verification.framework.config.AdminDataSegment;
import oracle.ops.verification.framework.config.AdminLoader;
import oracle.ops.verification.framework.config.ConstraintLoader;
import oracle.ops.verification.framework.config.DataSegment;
import oracle.ops.verification.framework.config.InvalidAdminDataException;
import oracle.ops.verification.framework.config.InvalidConstraintDataException;
import oracle.ops.verification.framework.config.InvalidDataSegmentException;

public class VerificationDataManager {
    public static final String CONFIG_DATA = "config_data";
    public static final String ADMIN_DATA = "admin_data";
    public static final String CONSTRAINT_DATA = "constraint_data";
    private static final String ROOTCONSTRAINT = "RootConstraint";
    private static final String BRANCHCONSTRAINT = "BranchConstraint";
    private static final String CONSTRAINT = "Constraint";
    private static final String KEYDATA = "KeyData";
    private static final String REFDATA = "RefData";
    private Hashtable m_cvdata = new Hashtable();
    private static VerificationDataManager m_vdm = null;

    private VerificationDataManager() {
        Trace.out((String)"**** VDM constructed");
    }

    public static VerificationDataManager getInstance() {
        if (m_vdm == null) {
            m_vdm = new VerificationDataManager();
        }
        return m_vdm;
    }

    public boolean isDataSegmentValid(String segname) {
        return segname.equals(CONSTRAINT_DATA) || segname.equals(ADMIN_DATA) || segname.equals(CONFIG_DATA);
    }

    public boolean isDataSegmentLoaded(String segname) throws InvalidDataSegmentException {
        if (!this.isDataSegmentValid(segname)) {
            throw new InvalidDataSegmentException("Invalid data-segment name");
        }
        boolean loaded = this.m_cvdata.containsKey(segname);
        Trace.out((String)("**** Load status for segment " + segname + " is " + loaded));
        return loaded;
    }

    public DataSegment getDataSegment(String segname) throws InvalidDataSegmentException {
        DataSegment segment;
        block6: {
            if (this.isDataSegmentLoaded(segname)) {
                Trace.out((String)("DataSegment '" + segname + "' has been loaded"));
                return (DataSegment)this.m_cvdata.get(segname);
            }
            Trace.out((String)("DataSegment '" + segname + "' to be loaded"));
            try {
                if (segname.equals(ADMIN_DATA)) {
                    segment = AdminLoader.createSegment();
                    this.m_cvdata.put(segname, segment);
                    break block6;
                }
                if (segname.equals(CONSTRAINT_DATA)) {
                    segment = ConstraintLoader.createSegment();
                    this.m_cvdata.put(segname, segment);
                    break block6;
                }
                throw new InvalidDataSegmentException("No such data segment '" + segname + "'");
            }
            catch (InvalidAdminDataException admExp) {
                throw new InvalidDataSegmentException(admExp.getMessage());
            }
            catch (InvalidConstraintDataException conExp) {
                throw new InvalidDataSegmentException(conExp.getMessage());
            }
        }
        return segment;
    }

    public static void main(String[] args) {
        System.out.println("VerificationDataManager in action...");
        VerificationDataManager vdm = VerificationDataManager.getInstance();
        try {
            vdm.isDataSegmentLoaded(CONSTRAINT_DATA);
            vdm.getDataSegment(CONSTRAINT_DATA);
            vdm.isDataSegmentLoaded(ADMIN_DATA);
            AdminDataSegment adminDataSegment = (AdminDataSegment)vdm.getDataSegment(ADMIN_DATA);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        System.out.println(" Done with VDM ");
    }
}

