/*
 * Decompiled with CFR 0.152.
 */
package oracle.ops.verification.framework.config;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import oracle.ops.verification.framework.util.VerificationUtil;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class PrereqXMLVerifier {
    public static final void main(String[] args) {
        if (args.length != 2) {
            System.out.println("Usage: java PrereqXMLVerifier <prereq_xsd> <prereq_xml>");
            System.exit(-1);
        }
        String xmlSchema = args[0];
        String xmlFile = args[1];
        try {
            new PrereqXMLVerifier(xmlSchema, xmlFile);
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
            System.exit(-1);
        }
        catch (IOException e) {
            e.printStackTrace();
            System.exit(-1);
        }
        catch (SAXException e) {
            e.printStackTrace();
            System.exit(-1);
        }
        catch (ParserConfigurationException e) {
            e.printStackTrace();
            System.exit(-1);
        }
    }

    public PrereqXMLVerifier(String xmlSchema, String xmlURI) throws IOException, MalformedURLException, SAXException, ParserConfigurationException {
        if (!VerificationUtil.isAbsoluteURI(xmlSchema)) {
            xmlSchema = new File(xmlSchema).toURI().toString();
        }
        if (!VerificationUtil.isAbsoluteURI(xmlURI)) {
            xmlURI = new File(xmlURI).toURI().toString();
        }
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setNamespaceAware(true);
        factory.setValidating(true);
        factory.setAttribute("http://java.sun.com/xml/jaxp/properties/schemaLanguage", "http://www.w3.org/2001/XMLSchema");
        factory.setAttribute("http://java.sun.com/xml/jaxp/properties/schemaSource", xmlSchema);
        DocumentBuilder m_xmlParser = factory.newDocumentBuilder();
        ErrorHandler eh = new ErrorHandler(){

            @Override
            public void error(SAXParseException arg0) throws SAXException {
                throw arg0;
            }

            @Override
            public void fatalError(SAXParseException arg0) throws SAXException {
                throw arg0;
            }

            @Override
            public void warning(SAXParseException arg0) throws SAXException {
                throw arg0;
            }
        };
        m_xmlParser.setErrorHandler(eh);
        m_xmlParser.parse(xmlURI);
        System.out.println("xml " + xmlURI + " passed the schema validation.");
    }
}

