/*
 * Decompiled with CFR 0.152.
 */
package oracle.ops.verification.framework.config;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import oracle.ops.mgmt.trace.Trace;
import oracle.ops.verification.framework.config.Constraint;
import oracle.ops.verification.framework.config.InvalidConstraintDataException;
import oracle.ops.verification.framework.config.PeerCompatible;
import oracle.ops.verification.framework.engine.Result;
import oracle.ops.verification.framework.engine.ResultSet;
import oracle.ops.verification.framework.global.GlobalExecution;
import oracle.ops.verification.framework.report.ReportUtil;

public class OsVerConstraint
extends Constraint
implements PeerCompatible {
    private static String CONSTRAINT_NAME = s_msgBundle.getMessage("1054", false);
    private String m_reqOsVer;

    public OsVerConstraint(String quali, String fbaction, String val) {
        super("OSVER", quali, fbaction);
        this.m_reqOsVer = val;
        this.setValid(false);
    }

    public OsVerConstraint(Hashtable ht) throws InvalidConstraintDataException {
        super("OSVER");
        this.validate(ht);
        this.m_qualifier = (String)ht.get("Qualifier");
        this.m_fbAction = (String)ht.get("FallbackAction");
        if (!this.m_qualifier.equals("COMPARE")) {
            Vector rdVec = (Vector)ht.get("RefData");
            this.m_reqOsVer = (String)rdVec.firstElement();
        }
        this.setValid(true);
    }

    @Override
    public String toString() {
        StringBuffer sb = new StringBuffer(this.getClass().getName());
        sb.append("[Qualifier: " + this.m_qualifier);
        sb.append(", FallbackAction: " + this.m_fbAction);
        sb.append(", Os Version reqd: " + this.m_reqOsVer + "]");
        return sb.toString();
    }

    @Override
    public void validate(Hashtable ht) throws InvalidConstraintDataException {
        super.validate(ht);
        if (!((String)ht.get("Type")).equals("OSVER")) {
            throw new InvalidConstraintDataException("Constraint type does not match");
        }
        String quali = (String)ht.get("Qualifier");
        int dsetlen = 0;
        if (quali.equals("EQUAL")) {
            if (!ht.containsKey("RefData")) {
                throw new InvalidConstraintDataException("Missing RefData");
            }
            dsetlen = 4;
            if (ht.size() != dsetlen) {
                String errtxt = "Invalid data set for " + this.getClass().getName() + ". EXPECTED: " + dsetlen + ", FOUND: " + ht.size();
                throw new InvalidConstraintDataException(errtxt);
            }
        } else if (quali.equals("COMPARE")) {
            dsetlen = 3;
            if (ht.size() != dsetlen) {
                String errtxt = "Invalid data set for " + this.getClass().getName() + ". EXPECTED: " + dsetlen + ", FOUND: " + ht.size();
                throw new InvalidConstraintDataException(errtxt);
            }
        } else {
            throw new InvalidConstraintDataException("Qualifier '" + quali + "' is not supported for " + this.getClass().getName());
        }
    }

    @Override
    public boolean applyConstraint(String[] nodeList, ResultSet rset) throws InvalidConstraintDataException {
        if (!this.isValid()) {
            throw new InvalidConstraintDataException("Can not apply invalid constraint");
        }
        GlobalExecution globalExec = new GlobalExecution();
        return globalExec.checkOSVersion(nodeList, this.m_reqOsVer, rset);
    }

    @Override
    public boolean checkCompatibility(String[] nodeList, String refNode, ResultSet resultSet) throws InvalidConstraintDataException {
        Trace.out((String)("Checking compatibility:" + this));
        if (!this.isValid()) {
            throw new InvalidConstraintDataException("Invalid constraint. Compatibility check can not proceed");
        }
        GlobalExecution globalExec = new GlobalExecution();
        boolean cmdStatus = globalExec.checkOSVersion(nodeList, "", resultSet);
        if (refNode == null || refNode.trim().length() == 0) {
            return cmdStatus;
        }
        Hashtable ht = resultSet.getResultTable();
        if (!ht.containsKey(refNode)) {
            Trace.out((String)"==== ERROR: refnode data missing");
            resultSet.addResult(nodeList, 2);
            resultSet.setStatus();
            return false;
        }
        Result refResult = (Result)ht.get(refNode);
        if (refResult.getStatus() == 2) {
            Trace.out((String)"==== ERROR: execution error at refnode");
            resultSet.addResult(nodeList, 2);
            resultSet.setStatus();
            return false;
        }
        this.m_reqOsVer = (String)refResult.getResultInfoSet().firstElement();
        Trace.out((String)("==== Reference data: " + this.m_reqOsVer));
        Enumeration e = ht.keys();
        while (e.hasMoreElements()) {
            boolean compStatus;
            String node = (String)e.nextElement();
            Result result = (Result)ht.get(node);
            if (node.equals(refNode)) {
                result.setStatus(1);
                continue;
            }
            if (result.getStatus() == 2) continue;
            String data = (String)result.getResultInfoSet().firstElement();
            Trace.out((String)("==== Refdata:" + this.m_reqOsVer + "Nodedata: " + data));
            boolean bl = compStatus = data.equals(this.m_reqOsVer);
            if (compStatus) {
                result.setStatus(1);
                Trace.out((String)"==== Result status reset to op_successful");
                continue;
            }
            result.setStatus(3);
            Trace.out((String)"==== Result status reset to vf_failed");
        }
        resultSet.setStatus();
        return cmdStatus;
    }

    @Override
    public void report(ResultSet resultSet) {
        ReportUtil.blankln();
        ReportUtil.println(s_msgBundle.getMessage("1000", false, (Object[])new String[]{CONSTRAINT_NAME}));
        ReportUtil.writeColHeaders(ReportUtil.NODENAME, ReportUtil.AVAILABLE, ReportUtil.REQUIRED, ReportUtil.COMMENT);
        Hashtable t = resultSet.getResultTable();
        Enumeration e = t.keys();
        while (e.hasMoreElements()) {
            String node = (String)e.nextElement();
            Result result = (Result)t.get(node);
            if (result.getStatus() == 1) {
                ReportUtil.writeRecord(node, (String)result.getResultInfoSet().firstElement(), this.m_reqOsVer, ReportUtil.PASSED);
                continue;
            }
            if (result.getStatus() == 3) {
                ReportUtil.writeRecord(node, (String)result.getResultInfoSet().firstElement(), this.m_reqOsVer, ReportUtil.FAILED);
                continue;
            }
            ReportUtil.writeRecord(node, ReportUtil.UNKNOWN, this.m_reqOsVer, ReportUtil.FAILED);
        }
        if (resultSet.getStatus() == 1) {
            ReportUtil.printResult(s_msgBundle.getMessage("1001", false, (Object[])new String[]{CONSTRAINT_NAME}));
        } else {
            ReportUtil.printResult(s_msgBundle.getMessage("1003", false, (Object[])new String[]{CONSTRAINT_NAME}));
            ReportUtil.printErrorNodes(resultSet);
        }
    }

    @Override
    public void reportCompatibility(ResultSet resultSet) {
        ReportUtil.sureblankln();
        ReportUtil.sureprintln(s_msgBundle.getMessage("1005", false, (Object[])new String[]{CONSTRAINT_NAME}));
        ReportUtil.surewriteColHeaders(ReportUtil.NODENAME, ReportUtil.OSVER);
        Hashtable t = resultSet.getResultTable();
        Enumeration e = t.keys();
        while (e.hasMoreElements()) {
            String node = (String)e.nextElement();
            Result result = (Result)t.get(node);
            String avl = result.getStatus() == 1 ? (String)result.getResultInfoSet().firstElement() : (result.getStatus() == 3 ? (String)result.getResultInfoSet().firstElement() : ReportUtil.UNKNOWN);
            ReportUtil.surewriteRecord(node, avl);
        }
        if (t.size() > 1) {
            ReportUtil.sureprintln(s_msgBundle.getMessage("1007", false, (Object[])new String[]{CONSTRAINT_NAME}));
        }
    }

    @Override
    public void reportCompatibility(String refNode, ResultSet resultSet) {
        ReportUtil.sureblankln();
        ReportUtil.sureprintln(s_msgBundle.getMessage("1009", false, (Object[])new String[]{CONSTRAINT_NAME, refNode}));
        ReportUtil.surewriteColHeaders(ReportUtil.NODENAME, ReportUtil.AVAILABLE, ReportUtil.REF_STATUS, ReportUtil.COMMENT);
        Hashtable t = resultSet.getResultTable();
        String reqd = this.m_reqOsVer;
        Enumeration e = t.keys();
        while (e.hasMoreElements()) {
            String comment;
            String avl;
            String node = (String)e.nextElement();
            if (node.equals(refNode)) continue;
            Result result = (Result)t.get(node);
            if (result.getStatus() == 1) {
                avl = (String)result.getResultInfoSet().firstElement();
                comment = ReportUtil.MATCHED;
            } else if (result.getStatus() == 3) {
                avl = (String)result.getResultInfoSet().firstElement();
                comment = ReportUtil.MISMATCHED;
            } else {
                avl = ReportUtil.UNKNOWN;
                comment = ReportUtil.MISMATCHED;
            }
            ReportUtil.surewriteRecord(node, avl, reqd, comment);
        }
        if (resultSet.getStatus() == 1) {
            ReportUtil.sureprintln(s_msgBundle.getMessage("1001", false, (Object[])new String[]{CONSTRAINT_NAME}));
        } else {
            ReportUtil.sureprintln(s_msgBundle.getMessage("1003", false, (Object[])new String[]{CONSTRAINT_NAME}));
        }
    }
}

