/*
 * Decompiled with CFR 0.152.
 */
package oracle.ops.verification.framework.config;

import java.util.ArrayList;
import java.util.List;
import oracle.ops.mgmt.nativesystem.RuntimeExec;
import oracle.ops.mgmt.trace.Trace;
import oracle.ops.verification.framework.VerificationConstants;
import oracle.ops.verification.framework.config.ComponentCollector;
import oracle.ops.verification.framework.config.ComponentSoftwareDistribution;
import oracle.ops.verification.framework.util.VerificationUtil;

public class DPMComponentCollector
implements ComponentCollector,
VerificationConstants {
    private static final String ORACLE_DIR = "oracle";
    private static final String INSTALL_DIR = "install";
    private static final String COMPONENTS_DIR = "components";
    private static final String PERL_CMD = "perl";
    private static final String DEPMINER_CMD = FSEP + "install" + FSEP + "build" + FSEP + "scripts" + FSEP + "depMiner ";
    private final String GI_TOP_LEVEL_COMPONENT = "oracle.crs";
    private final String GI_TOP_LEVEL_COMPONENT_OPT = "Complete";
    private final String DB_TOP_LEVEL_COMPONENT = "oracle.server";
    private final String DB_TOP_LEVEL_COMPONENT_OPT = "EE";
    private final String SH = "/bin/sh";
    private final String SH_OPT = "-c";
    private final String WIN_CMD = "cmd";
    private final String WIN_CMD_OPT = "/c";
    private String m_shell = null;
    private String m_shellOpt = null;
    private String m_componentCommand = null;

    @Override
    public List<ComponentSoftwareDistribution> getComponentList(String topComponentName) {
        Trace.out((String)"Getting list of components");
        List<ComponentSoftwareDistribution> crsComponents = null;
        String[] cmd = null;
        String viewRoot = System.getenv("ADE_VIEW_ROOT");
        Trace.out((String)("view root [" + viewRoot + "]"));
        if (VerificationUtil.isPlatformWindows()) {
            this.m_shell = "cmd";
            this.m_shellOpt = "/c";
        } else {
            this.m_shell = "/bin/sh";
            this.m_shellOpt = "-c";
        }
        Trace.out((String)(" topComponentName [" + topComponentName + "]"));
        if (topComponentName.equals("crs") || topComponentName.equals("ha")) {
            this.m_componentCommand = DEPMINER_CMD + " " + "oracle.crs" + " " + "Complete";
        }
        if (topComponentName.equals("database")) {
            this.m_componentCommand = DEPMINER_CMD + " " + "oracle.server" + " " + "EE";
        }
        cmd = new String[]{this.m_shell, this.m_shellOpt, "perl " + viewRoot + this.m_componentCommand};
        Trace.out((String)("cmd [" + cmd[2] + "]"));
        crsComponents = this.getComponents(cmd, viewRoot);
        return crsComponents;
    }

    private List<ComponentSoftwareDistribution> getComponents(String[] command, String viewRoot) {
        String[] out = null;
        String[] error = null;
        ComponentSoftwareDistribution component = null;
        ArrayList<ComponentSoftwareDistribution> components = new ArrayList<ComponentSoftwareDistribution>();
        RuntimeExec rt = new RuntimeExec(null, command, null, null);
        rt.runCommand();
        int exitValue = rt.getExitValue();
        if (exitValue != 0) {
            int j;
            out = rt.getOutput();
            error = rt.getError();
            if (out != null && out.length != 0) {
                for (j = 0; j < out.length; ++j) {
                    Trace.out((String)out[j]);
                }
            } else {
                Trace.out((String)"output is NULL/EMPTY");
            }
            if (error != null && error.length != 0) {
                for (j = 0; j < error.length; ++j) {
                    Trace.out((String)error[j]);
                }
            }
            return null;
        }
        Trace.out((String)("exitVal[" + rt.getExitValue() + "]"));
        for (String output : out = rt.getOutput()) {
            component = new ComponentSoftwareDistribution(output);
            component.setMapFileName(viewRoot + FSEP + ORACLE_DIR + FSEP + INSTALL_DIR + FSEP + COMPONENTS_DIR + FSEP + component.getMapFileDirectory() + component.getName() + ".map.xml");
            components.add(component);
        }
        return components;
    }
}

