/*
 * Decompiled with CFR 0.152.
 */
package oracle.ops.verification.framework.config;

import java.io.File;
import java.io.IOException;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.FactoryConfigurationError;
import javax.xml.parsers.ParserConfigurationException;
import oracle.ops.mgmt.cluster.ClusterCmd;
import oracle.ops.mgmt.cluster.ClusterException;
import oracle.ops.mgmt.trace.Trace;
import oracle.ops.verification.framework.config.AdminDataSegment;
import oracle.ops.verification.framework.config.InvalidAdminDataException;
import oracle.ops.verification.framework.config.VDMUtil;
import oracle.ops.verification.framework.util.VerificationLogData;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

class AdminLoader {
    static final String TAG_ROOTPROPERTY = "RootProperty";
    static final String TAG_PROPERTY = "Property";
    static final String TAG_NAME = "Name";
    static final String TAG_VALUE = "Value";
    private static String m_adminXmlFile = VDMUtil.getAdminDataFilename();

    AdminLoader() {
    }

    AdminLoader(String filename) {
        m_adminXmlFile = filename;
    }

    static final AdminDataSegment createSegment() throws InvalidAdminDataException {
        AdminDataSegment ads = new AdminDataSegment("admin_data");
        ClusterCmd cmd = new ClusterCmd();
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            factory.setValidating(true);
            DocumentBuilder parser = factory.newDocumentBuilder();
            DefaultHandler handler = new DefaultHandler();
            parser.setErrorHandler(handler);
            if (!cmd.fileExists(m_adminXmlFile)) {
                VerificationLogData.logError("File not found '" + m_adminXmlFile + "'");
                throw new InvalidAdminDataException("File not found '" + m_adminXmlFile + "'");
            }
            Document doc = parser.parse(new File(m_adminXmlFile));
            Trace.out((String)("Parser validation set to: " + parser.isValidating()));
            Trace.out((String)(m_adminXmlFile + " is well-formed"));
            Element rtElm = doc.getDocumentElement();
            String rootElmTxt = rtElm.getTagName();
            if (!rootElmTxt.equalsIgnoreCase(TAG_ROOTPROPERTY)) {
                Trace.out((String)"ERROR: Invalid root element");
                throw new InvalidAdminDataException("Invalid root element '" + rootElmTxt + "'");
            }
            NodeList allProperties = rtElm.getElementsByTagName(TAG_PROPERTY);
            for (int k = 0; k < allProperties.getLength(); ++k) {
                Element prop = (Element)allProperties.item(k);
                String propName = prop.getAttribute(TAG_NAME);
                String propValue = prop.getAttribute(TAG_VALUE);
                ads.setProperty(propName, propValue);
                Trace.out((int)1, (String)("==== Added Property[" + propName + " = " + propValue + "]"));
            }
        }
        catch (SAXException e) {
            String errtxt = "'" + m_adminXmlFile + " is not well-formed. ";
            throw new InvalidAdminDataException(errtxt + e.getMessage());
        }
        catch (IOException e) {
            throw new InvalidAdminDataException(e.getClass().getName() + ":" + e.getMessage());
        }
        catch (FactoryConfigurationError e) {
            throw new InvalidAdminDataException(e.getClass().getName() + ":" + e.getMessage());
        }
        catch (ParserConfigurationException e) {
            throw new InvalidAdminDataException(e.getClass().getName() + ":" + e.getMessage());
        }
        catch (ClusterException e) {
            String errtxt = "Existance check for '" + m_adminXmlFile + " failed.\n";
            Trace.out((String)(errtxt + e.getMessage()));
            throw new InvalidAdminDataException(errtxt + ((Object)((Object)e)).getClass().getName() + ":" + e.getMessage());
        }
        return ads;
    }
}

