/*
 * Decompiled with CFR 0.152.
 */
package oracle.ops.verification.framework.command;

import java.util.Map;
import java.util.Set;
import oracle.cluster.common.InvalidArgsException;
import oracle.cluster.install.ConfigurationSetup;
import oracle.cluster.install.UserInfo;
import oracle.cluster.remote.ExecCommandNoUserEq;
import oracle.cluster.remote.ExecException;
import oracle.cluster.remote.NodeProgressListener;
import oracle.cluster.remote.RemoteArgs;
import oracle.cluster.remote.RemoteFactory;
import oracle.cluster.util.CompositeOperationException;
import oracle.cluster.util.NoSuchIdentifierException;
import oracle.ops.mgmt.command.CommandResult;
import oracle.ops.mgmt.nativesystem.NativeResult;
import oracle.ops.mgmt.nls.MessageBundle;
import oracle.ops.mgmt.trace.Trace;
import oracle.ops.verification.framework.VerificationConstants;
import oracle.ops.verification.framework.engine.ErrorDescription;
import oracle.ops.verification.framework.engine.ResultSet;
import oracle.ops.verification.framework.util.RootAutomationNotConfiguredException;
import oracle.ops.verification.framework.util.RootUserCredentials;
import oracle.ops.verification.framework.util.VerificationLogData;
import oracle.ops.verification.framework.util.VerificationUtil;

public class RunGenericRootCommand
implements VerificationConstants {
    String[] m_nodeList;
    String[] m_env = null;
    String[] m_args = null;
    String m_location;
    String m_command;
    UserInfo m_userInfo;
    int m_timeout;
    ConfigurationSetup.ConfigMethod m_mode;
    ResultSet m_resultSet = new ResultSet();
    NodeProgressListener m_listener = null;
    private static MessageBundle s_gMsgBundle = VerificationUtil.getMessageBundle("Prvg");

    public RunGenericRootCommand(String[] nodeList, String command, String[] env, String[] args, RootUserCredentials rootCreds, int timeout) throws RootAutomationNotConfiguredException {
        this(nodeList, command, env, args, rootCreds.getRootUserCredentials(), rootCreds.getRootExecutionMode(), rootCreds.getSudoPbrunLocation(), timeout, null);
    }

    public RunGenericRootCommand(String[] nodeList, String command, String[] env, String[] args, RootUserCredentials rootCreds, int timeout, NodeProgressListener listener) throws RootAutomationNotConfiguredException {
        this(nodeList, command, env, args, rootCreds.getRootUserCredentials(), rootCreds.getRootExecutionMode(), rootCreds.getSudoPbrunLocation(), timeout, listener);
    }

    public RunGenericRootCommand(String[] nodeList, String command, String[] env, String[] args, UserInfo userInfo, ConfigurationSetup.ConfigMethod mode, String location, int timeout) {
        this(nodeList, command, env, args, userInfo, mode, location, timeout, null);
    }

    public RunGenericRootCommand(String[] nodeList, String command, String[] env, String[] args, UserInfo userInfo, ConfigurationSetup.ConfigMethod mode, String location, int timeout, NodeProgressListener listener) {
        this.m_userInfo = userInfo;
        this.m_mode = mode;
        this.m_timeout = timeout;
        this.m_command = command;
        this.m_location = location;
        this.m_nodeList = new String[nodeList.length];
        System.arraycopy(nodeList, 0, this.m_nodeList, 0, nodeList.length);
        if (args != null) {
            this.m_args = new String[args.length];
            System.arraycopy(args, 0, this.m_args, 0, args.length);
        }
        if (env != null) {
            this.m_env = new String[env.length];
            System.arraycopy(env, 0, this.m_env, 0, env.length);
        }
        this.m_listener = listener;
    }

    public boolean execute() {
        Map cmdResultMap = null;
        boolean bResult = false;
        RemoteFactory remoteFactory = null;
        RemoteArgs remoteArgs = null;
        ExecCommandNoUserEq execCommand = null;
        Trace.out((String)"Entry");
        try {
            remoteFactory = RemoteFactory.getInstance();
            remoteArgs = this.m_mode == ConfigurationSetup.ConfigMethod.ROOT ? new RemoteArgs(this.m_userInfo.getPassword()) : new RemoteArgs(this.m_userInfo.getUsername(), this.m_userInfo.getPassword(), this.m_location);
            if (this.m_listener != null) {
                remoteArgs.setListener(this.m_listener);
            }
            execCommand = remoteFactory.getExecCommandNoUserEq(remoteArgs);
            cmdResultMap = execCommand.runCmd(this.m_command, this.m_args == null ? new String[]{} : this.m_args, this.m_env == null ? new String[]{} : this.m_env, this.m_nodeList, this.m_timeout);
            for (Map.Entry entry : cmdResultMap.entrySet()) {
                String node = (String)entry.getKey();
                CommandResult result = (CommandResult)entry.getValue();
                this.m_resultSet.addResult(node, 1);
                String[] resultStringArr = result.getResultString();
                String reoutput = VerificationUtil.strArr2String(resultStringArr, LSEP);
                Trace.out((String)("output: " + reoutput));
                this.m_resultSet.getResult(node).addResultInfo(reoutput);
                if (resultStringArr == null) continue;
                this.m_resultSet.getResult(node).addResultInfo(resultStringArr);
            }
            bResult = true;
        }
        catch (ExecException e) {
            Trace.out((String)("Received ExecException while executing command " + this.m_command + " message is: " + e.getMessage()));
            VerificationLogData.logError("ExecException while running command " + this.m_command + " message is " + e.getMessage());
            this.m_resultSet.addResult(this.m_nodeList, 2);
            String errMsg = e.getMessage();
            ErrorDescription errDesc = new ErrorDescription(errMsg);
            this.m_resultSet.addErrorDescription(errDesc);
            return bResult;
        }
        catch (CompositeOperationException e) {
            Trace.out((String)("Received CompositeOperationException  " + e.getMessage()));
            VerificationLogData.logError("Channel exception while running command " + this.m_command + " message is " + e.getMessage());
            try {
                Set compositeErrorSet = e.getOperationIdentifier();
                for (Object obj : compositeErrorSet) {
                    String[] resultStringArr;
                    String errMsg;
                    String reoutput;
                    String[] resultStringArr2;
                    String node = (String)obj;
                    NativeResult nativeResult = e.getNativeResult(obj);
                    int osErrorCode = nativeResult.getOSErrCode();
                    if (e.getStatus(obj) == CompositeOperationException.Status.SUCCESS) {
                        if (osErrorCode <= 2) {
                            Trace.out((String)("execution successful on node: " + node));
                            this.m_resultSet.addResult(node, 1);
                            resultStringArr2 = nativeResult.getResultString();
                            if (resultStringArr2 != null && resultStringArr2.length > 0) {
                                reoutput = VerificationUtil.strArr2String(resultStringArr2);
                                Trace.out((String)("Command output is : " + reoutput));
                                this.m_resultSet.getResult(node).addResultInfo(reoutput);
                                this.m_resultSet.getResult(node).addResultInfo(resultStringArr2);
                                continue;
                            }
                            this.m_resultSet.getResult(node).addResultInfo("");
                            continue;
                        }
                        this.m_resultSet.addResult(node, 2);
                        errMsg = e.getMessage() + LSEP + VerificationUtil.strArr2String(nativeResult.getOutputString(), LSEP);
                        ErrorDescription ed = new ErrorDescription(errMsg);
                        this.m_resultSet.addErrorDescription(node, ed);
                        continue;
                    }
                    if (e.getStatus(obj) == CompositeOperationException.Status.FAILURE) {
                        Trace.out((String)"composite operation exception is having failure status");
                        if (osErrorCode <= 2) {
                            Trace.out((String)("execution successful on node: " + node));
                            this.m_resultSet.addResult(node, 1);
                            resultStringArr2 = nativeResult.getResultString();
                            if (resultStringArr2 != null && resultStringArr2.length > 0) {
                                reoutput = VerificationUtil.strArr2String(resultStringArr2);
                                Trace.out((String)("Command output is : " + reoutput));
                                this.m_resultSet.getResult(node).addResultInfo(reoutput);
                                this.m_resultSet.getResult(node).addResultInfo(resultStringArr2);
                                continue;
                            }
                            this.m_resultSet.getResult(node).addResultInfo("");
                            continue;
                        }
                        this.m_resultSet.addResult(node, 2);
                        errMsg = this.m_mode == ConfigurationSetup.ConfigMethod.ROOT ? s_gMsgBundle.getMessage("11305", true, (Object[])new String[]{node}) + LSEP + e.getMessage() : s_gMsgBundle.getMessage("11303", true, (Object[])new String[]{node}) + LSEP + e.getMessage();
                        resultStringArr = nativeResult.getResultString();
                        if (resultStringArr != null) {
                            errMsg = errMsg + LSEP + VerificationUtil.strArr2String(resultStringArr);
                        }
                        ErrorDescription ed = new ErrorDescription(errMsg);
                        this.m_resultSet.addErrorDescription(node, ed);
                        continue;
                    }
                    Trace.out((String)"composite operation exception is having exception status");
                    if (osErrorCode <= 2) {
                        Trace.out((String)("execution successful on node: " + node));
                        this.m_resultSet.addResult(node, 1);
                        resultStringArr2 = nativeResult.getResultString();
                        if (resultStringArr2 != null && resultStringArr2.length > 0) {
                            reoutput = VerificationUtil.strArr2String(resultStringArr2);
                            Trace.out((String)("Command output is : " + reoutput));
                            this.m_resultSet.getResult(node).addResultInfo(reoutput);
                            this.m_resultSet.getResult(node).addResultInfo(resultStringArr2);
                            continue;
                        }
                        this.m_resultSet.getResult(node).addResultInfo("");
                        continue;
                    }
                    this.m_resultSet.addResult(node, 2);
                    Exception nativeException = e.getException(obj);
                    if (nativeException != null) {
                        this.m_resultSet.addErrorDescription(node, new ErrorDescription(nativeException.getMessage()));
                        continue;
                    }
                    resultStringArr = nativeResult.getResultString();
                    if (resultStringArr == null) continue;
                    this.m_resultSet.addErrorDescription(node, new ErrorDescription(VerificationUtil.strArr2String(resultStringArr)));
                }
            }
            catch (NoSuchIdentifierException ne) {
                VerificationLogData.logError("Channel exception while running command " + this.m_command + " message is " + e.getMessage());
                Trace.out((String)ne.getMessage());
            }
            return bResult;
        }
        catch (InvalidArgsException e) {
            this.m_resultSet.addResult(this.m_nodeList, 2);
            ErrorDescription ed = new ErrorDescription(e.getMessage());
            this.m_resultSet.addErrorDescription(this.m_nodeList, ed);
            Trace.out((String)("Invalid argument " + e.getMessage()));
        }
        return bResult;
    }

    public ResultSet getResultSet() {
        return this.m_resultSet;
    }
}

