/*
 * Decompiled with CFR 0.152.
 */
package oracle.ops.verification.framework.command;

import oracle.cluster.verification.StorageSize;
import oracle.cluster.verification.StorageType;
import oracle.cluster.verification.StorageUnit;
import oracle.cluster.verification.VerificationError;
import oracle.ops.mgmt.trace.Trace;
import oracle.ops.verification.framework.command.VerificationCommand;
import oracle.ops.verification.framework.engine.Entity;
import oracle.ops.verification.framework.engine.EntityStatus;
import oracle.ops.verification.framework.engine.ErrorDescription;
import oracle.ops.verification.framework.engine.Result;
import oracle.ops.verification.framework.storage.StorageData;
import oracle.ops.verification.framework.storage.StorageDataHandler;
import oracle.ops.verification.framework.util.VerificationUtil;

public class GetSpaceCommand
extends VerificationCommand {
    private String m_id;

    public GetSpaceCommand(String nodeName, String id) {
        super(nodeName);
        this.m_id = id;
    }

    @Override
    public boolean execute() {
        Result result = super.getResult();
        Trace.out((Object)"id='%s'", (String)this.m_id);
        StorageDataHandler sdHndlr = new StorageDataHandler();
        StorageData stData = sdHndlr.getStorageData(this.m_id, this.m_node);
        StorageType stType = stData.getStorageTypeEnum();
        Trace.out((Object)"StorageType='%s'", (String)stType.name());
        if (stType != StorageType.UNKNOWN) {
            String derivedPath = stData.getEffectiveID();
            Trace.out((Object)"derivedPath='%s'", (String)derivedPath);
            if (derivedPath != null && VerificationUtil.isSubsetPath(derivedPath, this.m_id)) {
                Trace.out((Object)"derivedPath='%s'", (String)derivedPath);
                result.setStatus(2);
                String errMsg = s_gMsgBundle.getMessage("9021", true, (Object[])new String[]{this.m_id, this.m_node});
                result.addErrorDescription(new ErrorDescription(errMsg));
                for (VerificationError verificationError : stData.getErrors()) {
                    result.addErrorDescription((ErrorDescription)verificationError);
                }
                return false;
            }
            Entity<StorageSize> entity = stData.getFreeSpace();
            if (entity != null && entity.getStatus() == EntityStatus.VALID) {
                long freeSpace = (long)entity.getValue().sizeIn(StorageUnit.BYTE);
                Trace.out((String)("The free space at '" + this.m_id + "' on node '" + this.m_node + "' is '" + freeSpace + "' Bytes"));
                result.addResultInfo(freeSpace);
                result.addResultInfo((Object)stType);
                result.setStatus(1);
                return true;
            }
            Trace.out((String)("Free space is unavailable:: " + entity));
        }
        Trace.out((String)"Failed to get the free space at '%s' on node '%s'", (Object[])new Object[]{this.m_id, this.m_node});
        result.setStatus(2);
        String errMsg = stType == StorageType.ASMDG ? s_gMsgBundle.getMessage("0821", true, (Object[])new String[]{this.m_id}) : s_gMsgBundle.getMessage("0820", true, (Object[])new String[]{this.m_id, this.m_node});
        result.addErrorDescription(new ErrorDescription(errMsg));
        for (VerificationError verificationError : stData.getErrors()) {
            result.addErrorDescription((ErrorDescription)verificationError);
        }
        return false;
    }
}

