/*
 * Decompiled with CFR 0.152.
 */
package oracle.ops.verification.framework.command;

import java.util.Vector;
import oracle.ops.mgmt.trace.Trace;
import oracle.ops.verification.framework.command.VerificationCommand;
import oracle.ops.verification.framework.engine.Result;
import oracle.ops.verification.framework.util.VerificationUtil;

public class GetRLimitCommand
extends VerificationCommand {
    private static String m_arg1 = "-getrlimit";
    private String m_userName;
    private String m_limitType;
    private String m_resource;

    public GetRLimitCommand(String nodeName, String userName, String limitType, String resource) {
        super(nodeName, null, null);
        this.m_userName = userName;
        this.m_limitType = limitType;
        this.m_resource = resource;
        String[] args = new String[]{m_arg1, this.m_userName, this.m_limitType, this.m_resource};
        super.setArgs(args);
    }

    @Override
    public boolean execute() {
        if (Trace.isLevelEnabled((int)2)) {
            Trace.out((String)("GetRLimitCommand::Inside execute() " + Thread.currentThread().getName()));
        }
        boolean bResult = super.execute();
        Result result = this.getResult();
        if (!bResult) {
            String trcTxt = "super.execute() failed for GetRLimitCommand...";
            if (Trace.isLevelEnabled((int)15)) {
                Trace.out((String)trcTxt);
            }
            result.addTraceInfo(trcTxt);
            result.addErrorInfo("GetRLimitCommand failed");
            result.setStatus(2);
            return false;
        }
        if (this.commandResult.getStatus() && this.commandResult.getResultString() != null) {
            String[] resultString = this.getCommandResult().getResultString();
            boolean filterIfTag = false;
            String paramValueString = "";
            String reoutput = VerificationUtil.strArr2String(resultString);
            String retVal = VerificationUtil.fetchVerificationValue(reoutput);
            if (retVal.contains("ULIMIT")) {
                Vector<String> values = VerificationUtil.tagHashFilter(retVal, "ULIMIT");
                if (values.size() > 0) {
                    paramValueString = values.elementAt(0);
                }
            } else {
                paramValueString = retVal;
            }
            if (Trace.isLevelEnabled((int)1)) {
                Trace.out((String)("The value for username= " + this.m_userName + " limitType=" + this.m_limitType + " resouce: " + this.m_resource + " on node:" + this.m_node + " is " + paramValueString));
            }
            result.addResultInfo(paramValueString);
            result.setStatus(1);
            if (Trace.isLevelEnabled((int)2)) {
                Trace.out((String)"GetRLimitCommand: Exit with success");
            }
            return true;
        }
        if (Trace.isLevelEnabled((int)15)) {
            Trace.out((String)("ERROR:GetRLimitCommand:: " + this.commandResult.getResultString()));
        }
        result.addErrorInfo("ERROR:GetRLimitCommand:: " + this.commandResult.getResultString());
        result.addTraceInfo("ERROR:GetRLimitCommand:: " + this.commandResult.getResultString());
        result.setStatus(2);
        return false;
    }
}

