/*
 * Decompiled with CFR 0.152.
 */
package oracle.ops.verification.framework.command;

import oracle.ops.mgmt.trace.Trace;
import oracle.ops.verification.framework.VerificationConstants;
import oracle.ops.verification.framework.command.VerificationCommand;
import oracle.ops.verification.framework.engine.Result;
import oracle.ops.verification.framework.util.CVUAutoUpdateManager;
import oracle.ops.verification.framework.util.VerificationUtil;

public class GetExectaskVerCommand
extends VerificationCommand
implements VerificationConstants {
    private static String[] m_argArray = new String[]{"-getver"};

    public GetExectaskVerCommand(String nodeName) {
        this(nodeName, false);
    }

    public GetExectaskVerCommand(String nodeName, boolean copyFiles) {
        super(VerificationUtil.getCVUSubDirPath() + FSEP + VerificationUtil.getCmd4RemExec(), null, null, nodeName, (String[])(copyFiles ? CVUAutoUpdateManager.getCmdFiles4RemExec() : null), (String[])(copyFiles ? CVUAutoUpdateManager.getFiles4RemExecServer() : null), null, VerificationUtil.getDestLoc());
        if (VerificationUtil.isPlatformWindows()) {
            super.setRemoteExecServerDllLocation(VerificationUtil.getSrcLoc());
        }
        super.setArgs(m_argArray);
    }

    @Override
    public boolean execute() {
        Trace.out((String)("GetExectaskVerCommand::Inside execute() " + Thread.currentThread().getName()));
        boolean bResult = super.execute();
        Result result = this.getResult();
        if (!bResult) {
            String trcTxt = "super.execute() failed for GetExectaskVerCommand...";
            Trace.out((String)trcTxt);
            result.addTraceInfo(trcTxt);
            Trace.out((String)"getting exectask version failed");
            result.addErrorInfo("getting exectask version failed");
            result.setStatus(2);
            return false;
        }
        Trace.out((String)"super.execute() was succcessful for GetExectaskVerCommand...");
        String[] resultString = this.getCommandResult().getResultString();
        String exectaskFmtdStr = VerificationUtil.strArr2List(resultString, "\n");
        if (!VerificationUtil.fetchExecResult(exectaskFmtdStr)) {
            String trcTxt = "Exectask result shows failure for -getver...";
            Trace.out((String)trcTxt);
            result.addTraceInfo(trcTxt);
            Trace.out((String)"getting exectask version failed");
            result.addErrorInfo("getting exectask version failed");
            result.setStatus(2);
            return false;
        }
        String exectaskVer = VerificationUtil.fetchVerificationValue(exectaskFmtdStr);
        Trace.out((String)"after calling fetchVerificationValue() ");
        Trace.out((String)("The version of exectask at node '" + this.getNodeName() + "' is '" + exectaskVer + "'"));
        result.addTraceInfo("The version of exectask at node '" + this.getNodeName() + "' is '" + exectaskVer + "'");
        result.addResultInfo(exectaskVer);
        result.setStatus(1);
        return true;
    }
}

