/*
 * Decompiled with CFR 0.152.
 */
package oracle.ops.verification.framework.command;

import oracle.ops.mgmt.nls.MessageBundle;
import oracle.ops.mgmt.trace.Trace;
import oracle.ops.verification.framework.command.GetFileInfoCommand;
import oracle.ops.verification.framework.command.VerificationCommand;
import oracle.ops.verification.framework.engine.Result;
import oracle.ops.verification.framework.util.VerificationUtil;

public class GetCVUSubDirectoryInfoCommand
extends VerificationCommand {
    protected static MessageBundle s_msgBundle = VerificationUtil.getMessageBundle("Prvf");
    private static final String TAG_FILE_INFO_BEGIN = "<FILE_INFO>";
    private static final String TAG_FILE_INFO_END = "</FILE_INFO>";
    private static final String TAG_EXECTASK_VER_BEGIN = "<EXECTASK_VER>";
    private static final String TAG_EXECTASK_VER_END = "</EXECTASK_VER>";
    private static String m_arg1 = "-getcvusubdirinfo";
    private String m_configFile;

    public GetCVUSubDirectoryInfoCommand(String nodeName, String fname) {
        super(nodeName, null, null);
        this.m_configFile = fname;
        String[] args = new String[]{m_arg1, this.m_configFile};
        super.setArgs(args);
    }

    @Override
    public boolean execute() {
        Trace.out((String)("GetCVUSubDirectoryInfoCommand::Inside execute() " + Thread.currentThread().getName()));
        boolean bResult = super.execute();
        Result result = this.getResult();
        if (!bResult) {
            String trcTxt = "super.execute() failed for GetCVUSubDirectoryInfoCommand...";
            Trace.out((String)trcTxt);
            result.addTraceInfo(trcTxt);
            result.addErrorInfo("checking file version failed");
            result.setStatus(2);
            return false;
        }
        if (result.getStatus() == 1) {
            String outputFileName;
            String[] resultString = this.getCommandResult().getResultString();
            String output = VerificationUtil.fetchVerificationValue(VerificationUtil.strArr2String(resultString));
            String exectaskVersion = VerificationUtil.fetchTextByTags(output, TAG_EXECTASK_VER_BEGIN, TAG_EXECTASK_VER_END);
            if (VerificationUtil.isStringGood(exectaskVersion)) {
                Trace.out((String)("Exectask version on node (" + this.m_node + ") is (" + exectaskVersion + ")"));
                result.addResultInfo(exectaskVersion.trim());
            }
            if (VerificationUtil.isStringGood(outputFileName = VerificationUtil.fetchTextByTags(output, TAG_FILE_INFO_BEGIN, TAG_FILE_INFO_END).trim())) {
                Trace.out((String)("Processing output file (" + outputFileName + ") from node (" + this.m_node + ")"));
                result.addResultInfo(GetFileInfoCommand.processOutputFile(outputFileName.trim(), this.m_node, result));
            }
        } else {
            result.setStatus(2);
        }
        return true;
    }
}

