/*
 * Decompiled with CFR 0.152.
 */
package oracle.ops.verification.framework.command;

import oracle.ops.mgmt.trace.Trace;
import oracle.ops.verification.framework.command.VerificationCommand;
import oracle.ops.verification.framework.engine.Result;
import oracle.ops.verification.framework.nativesystem.ExecutionAnalyzer;
import oracle.ops.verification.framework.nativesystem.ExecutionAnalyzerFactory;
import oracle.ops.verification.framework.util.VerificationUtil;

public class GetAllPackagesCommand
extends VerificationCommand {
    private static String ARG_RUNEXE = "-getallpackages";

    public GetAllPackagesCommand(String nodeName) {
        super(nodeName, null, null);
        String[] args = new String[]{ARG_RUNEXE};
        super.setArgs(args);
    }

    @Override
    public boolean execute() {
        Trace.out((String)("RunExeCommand::Inside execute() " + Thread.currentThread().getName()));
        boolean bResult = super.execute();
        Result result = this.getResult();
        if (!bResult) {
            String trcTxt = "super.execute() failed ...";
            Trace.out((String)trcTxt);
            result.addTraceInfo(trcTxt);
            result.addErrorInfo("Command failed");
            result.setStatus(2);
            return false;
        }
        String[] resultString = this.getCommandResult().getResultString();
        String reoutput = VerificationUtil.strArr2List(resultString, System.getProperty("line.separator"));
        ExecutionAnalyzer analyzer = ExecutionAnalyzerFactory.getExecutionAnalyzer();
        analyzer.pickRunExeOutput(reoutput, result);
        return true;
    }
}

