/*
 * Decompiled with CFR 0.152.
 */
package oracle.ops.verification.framework.command;

import oracle.ops.mgmt.trace.Trace;
import oracle.ops.verification.framework.command.VerificationCommand;
import oracle.ops.verification.framework.engine.CollectionElement;
import oracle.ops.verification.framework.engine.ErrorDescription;
import oracle.ops.verification.framework.engine.Result;
import oracle.ops.verification.framework.util.VerificationUtil;

public class CheckUserEquivRemoteCommand
extends VerificationCommand {
    private final String REMOTE_SSH_CMD = "-checkremotessh";
    private String m_nodeListStr;

    public CheckUserEquivRemoteCommand(String nodeName, String nodeListStr, String sshCommand) {
        super(nodeName, null, null);
        String[] args = new String[]{"-checkremotessh", "\\\"" + sshCommand + "\\\"", nodeListStr};
        this.m_nodeListStr = nodeListStr;
        super.setArgs(args);
    }

    @Override
    public boolean execute() {
        Trace.out((String)("CheckUserEquivRemoteCommand::Inside execute() " + Thread.currentThread().getName()));
        boolean bResult = super.execute();
        Result result = this.getResult();
        if (!bResult) {
            String trcTxt = "super.execute() failed for check remote ssh...";
            Trace.out((String)trcTxt);
            result.addTraceInfo(trcTxt);
            result.addErrorInfo("checking remote ssh failed on node " + this.m_key);
            result.setStatus(2);
            String[] failedNodeArr = this.m_nodeListStr.split(",");
            String excpt = super.getExceptionError();
            ErrorDescription errDesc = null;
            if (VerificationUtil.isStringGood(excpt)) {
                errDesc = new ErrorDescription(excpt);
            }
            for (int i = 0; i < failedNodeArr.length; ++i) {
                String statusStr = Result.resultStatusString(2);
                CollectionElement collElem = new CollectionElement("", failedNodeArr[i], null, null, null, "", statusStr);
                if (errDesc != null) {
                    collElem.addErrorDescription(errDesc);
                }
                result.addCollectionElement(collElem);
            }
            return false;
        }
        String[] outputArr = VerificationUtil.fetchTextByTagsRepeat(this.getOutput(), "CV_USEREQUIV");
        for (int i = 0; i < outputArr.length; ++i) {
            String destNode = VerificationUtil.fetchTextByTags(outputArr[i], "CV_NODE");
            String sshOut = VerificationUtil.fetchTextByTags(outputArr[i], "CV_SSHOUT");
            String nodeStatus = VerificationUtil.fetchTextByTags(outputArr[i], "CV_NODE_VRES");
            Trace.out((String)("creating collection element for node: " + destNode + "with status: " + nodeStatus + " output : " + sshOut));
            String statusStr = Result.resultStatusString(2);
            try {
                int statusInt = Integer.parseInt(nodeStatus);
                statusStr = statusInt == 0 ? Result.resultStatusString(1) : (statusInt == 1 ? Result.resultStatusString(3) : Result.resultStatusString(2));
            }
            catch (NumberFormatException e) {
                Trace.out((String)"number format exception while getting status");
            }
            CollectionElement collElem = new CollectionElement("", destNode, null, null, null, "", statusStr);
            if (VerificationUtil.isStringGood(sshOut)) {
                collElem.addErrorDescription(new ErrorDescription(sshOut));
            }
            result.addCollectionElement(collElem);
        }
        return true;
    }
}

