/*
 * Decompiled with CFR 0.152.
 */
package oracle.ops.verification.framework.command;

import java.util.Hashtable;
import java.util.Vector;
import oracle.ops.mgmt.trace.Trace;
import oracle.ops.verification.framework.command.VerificationCommand;
import oracle.ops.verification.framework.engine.Result;
import oracle.ops.verification.framework.engine.ResultSet;
import oracle.ops.verification.framework.util.RootAutomationNotConfiguredException;
import oracle.ops.verification.framework.util.RootUserCredentials;
import oracle.ops.verification.framework.util.VerificationUtil;

public class CheckOCRIntegrityCommand
extends VerificationCommand {
    private static String m_arg1 = "-runexe";
    private static String m_ocrcheck = VerificationUtil.getCRSHome() + FILE_SEPARATOR + "bin" + FILE_SEPARATOR + "ocrcheck";

    public CheckOCRIntegrityCommand(String nodeName) {
        super(nodeName, null, null);
        String[] args = new String[]{m_arg1, m_ocrcheck};
        super.setArgs(args);
    }

    public CheckOCRIntegrityCommand(String[] nodeArr, RootUserCredentials rootCreds, int timeout, ResultSet resultSet) throws RootAutomationNotConfiguredException {
        super(nodeArr, m_ocrcheck, rootCreds, timeout, resultSet);
    }

    @Override
    public boolean execute() {
        String node = this.getNodeName();
        Trace.out((String)("CheckOCRIntegrityCommand::Inside execute() " + Thread.currentThread().getName()));
        boolean bResult = super.execute();
        Result result = this.getResult();
        if (!bResult) {
            String trcTxt = "super.execute() failed for CheckOCRIntegrityCommand...";
            Trace.out((String)trcTxt);
            result.addTraceInfo(trcTxt);
            result.addErrorInfo("CheckOCRIntegrity failed");
            result.setStatus(2);
            return false;
        }
        String[] resultString = this.getCommandResult().getResultString();
        String exectaskFmtdStr = VerificationUtil.strArr2List(resultString, "\n");
        if (!VerificationUtil.fetchExecResult(exectaskFmtdStr)) {
            result.addTraceInfo("Exectask execution result failed");
            result.addErrorInfo("CheckOCRIntegrity using ocrcheck failed");
            result.setStatus(2);
            return false;
        }
        String exectaskVerfRes = VerificationUtil.fetchVerificationResult(exectaskFmtdStr);
        if (!exectaskVerfRes.equalsIgnoreCase("0")) {
            String errTxt = VerificationUtil.fetchVerificationValue(exectaskFmtdStr);
            Trace.out((String)("Exectask verification result('" + exectaskVerfRes + "') failed"));
            result.addTraceInfo("Exectask verification result('" + exectaskVerfRes + "') failed");
            result.addErrorInfo("CheckOCRIntegrity using ocrcheck failed");
            if (errTxt != null && errTxt.length() != 0) {
                Trace.out((String)("ERROR MESSAGE from node '" + node + "'>> " + errTxt));
                result.addErrorInfo("ERROR MESSAGE from node '" + node + "'>> " + errTxt);
            }
            result.setStatus(2);
            return false;
        }
        String ocrInfoOutput = VerificationUtil.fetchVerificationValue(exectaskFmtdStr);
        String reoutput = VerificationUtil.strArr2String(resultString, LSEP);
        Trace.out((String)("output: " + reoutput));
        result.addResultInfo(reoutput);
        result.addResultInfo(resultString);
        return this.parseUpdateResult(ocrInfoOutput, node, result);
    }

    private boolean parseUpdateResult(String ocrInfoOutput, String node, Result result) {
        if (ocrInfoOutput == null || ocrInfoOutput.length() == 0) {
            Trace.out((String)("NO OUTPUT FROM 'ocrcheck' run on node '" + node + "'"));
            result.addErrorInfo("NO OUTPUT FROM 'ocrcheck' run on node '" + node + "'");
            result.setStatus(2);
            return false;
        }
        Hashtable<String, Object> ocrDetails = new Hashtable<String, Object>();
        String[] ocrInfoArr = ocrInfoOutput.split("\n");
        boolean ocrIntegrity = false;
        Vector<String> devStat = new Vector<String>();
        for (int i = 0; i < ocrInfoArr.length; ++i) {
            String ocrInfoLine = ocrInfoArr[i];
            String[] strKeyVal = ocrInfoLine.split(":");
            if (strKeyVal.length == 2) {
                String itemName = strKeyVal[0].trim();
                String itemVal = strKeyVal[1].trim();
                if (Trace.isLevelEnabled((int)1)) {
                    Trace.out((String)("\nItem Name: " + itemName + "\nItem Val: " + itemVal));
                }
                if (itemName.equals("Version")) {
                    ocrDetails.put("Version", itemVal);
                    continue;
                }
                if (itemName.matches("Total space.*")) {
                    ocrDetails.put("TotalSpace", itemVal);
                    continue;
                }
                if (itemName.matches("ID.*")) {
                    ocrDetails.put("ID", itemVal);
                    continue;
                }
                if (!itemName.matches("Device/File.*")) continue;
                String devInfoStatus = ocrInfoArr[i + 1].trim();
                if (Trace.isLevelEnabled((int)1)) {
                    Trace.out((String)("Checking OCR Dev/File: \n" + itemVal + " - " + devInfoStatus));
                }
                if (devInfoStatus.indexOf("check succeeded") != -1) continue;
                if (Trace.isLevelEnabled((int)5)) {
                    Trace.out((String)("\nDevice: '" + itemVal + "' encoutered problems.\nStatus: " + devInfoStatus));
                }
                devStat.add(itemVal);
                continue;
            }
            if (!ocrInfoLine.trim().equals("Cluster registry integrity check succeeded")) continue;
            ocrIntegrity = true;
        }
        ocrDetails.put("DeviceStatus", devStat);
        if (ocrIntegrity) {
            ocrDetails.put("Integrity", "True");
        } else {
            ocrDetails.put("Integrity", "False");
        }
        result.addResultInfo(ocrDetails);
        result.setStatus(1);
        return true;
    }

    @Override
    public boolean runCmdAsRoot() throws RootAutomationNotConfiguredException {
        this.setEnv(new String[]{"NLS_LANG="});
        boolean status = super.runCmdAsRoot();
        for (int i = 0; i < this.m_nodeArr.length; ++i) {
            Result result = this.m_rootResultSet.getResult(this.m_nodeArr[i]);
            if (result.getStatus() != 1) continue;
            String output = (String)result.getResultInfoSet().get(0);
            status &= this.parseUpdateResult(output, this.m_nodeArr[i], result);
        }
        return status;
    }
}

