/*
 * Decompiled with CFR 0.152.
 */
package oracle.ops.verification.framework.command;

import oracle.ops.mgmt.nls.MessageBundle;
import oracle.ops.mgmt.trace.Trace;
import oracle.ops.verification.framework.command.VerificationCommand;
import oracle.ops.verification.framework.engine.ErrorDescription;
import oracle.ops.verification.framework.engine.Result;
import oracle.ops.verification.framework.util.VerificationUtil;

public class CheckDiskAFDCapableCommand
extends VerificationCommand {
    private static MessageBundle s_gMsgBundle = VerificationUtil.getMessageBundle("Prvg");
    private static String m_arg = "-checkAFDCapable";
    private String m_diskPath;

    public CheckDiskAFDCapableCommand(String nodeName, String diskPath) {
        super(nodeName, null, null);
        this.m_diskPath = diskPath;
        String[] args = new String[]{m_arg, diskPath};
        super.setArgs(args);
    }

    @Override
    public boolean execute() {
        Trace.out((String)("CheckDiskAFDCapableCommand::Inside execute() " + Thread.currentThread().getName()));
        boolean bResult = super.execute();
        Result result = this.getResult();
        if (!bResult) {
            String trcTxt = "super.execute() failed for CheckDiskAFDCapableCommand...";
            Trace.out((String)trcTxt);
            result.addTraceInfo(trcTxt);
            result.addErrorInfo("check for AFD capable disk for disk path " + this.m_diskPath + " failed");
            result.setStatus(2);
            return bResult;
        }
        return this.analyzeOutput();
    }

    public String getDiskPath() {
        return this.m_diskPath;
    }

    private boolean analyzeOutput() {
        Result result = this.getResult();
        String[] resultString = this.getCommandResult().getResultString();
        String reoutput = VerificationUtil.strArr2String(resultString);
        if (!VerificationUtil.fetchExecResult(reoutput)) {
            result.addTraceInfo("Exectask result failed");
            result.addErrorInfo("Error while checking AFD compatibility of disk " + this.m_diskPath);
            String errMsg = VerificationUtil.fetchError(reoutput);
            if (errMsg != null) {
                result.addErrorInfo(errMsg);
            } else {
                result.addErrorInfo("Execution of -checkAFDCapable failed");
            }
            result.setStatus(2);
            result.addErrorDescription(new ErrorDescription(s_gMsgBundle.getMessage("12807", true, (Object[])new String[]{this.m_diskPath, this.m_node}) + LSEP + errMsg));
            return false;
        }
        if (!VerificationUtil.fetchVerificationStatus(reoutput)) {
            result.addTraceInfo("Disk is " + this.m_diskPath + " not afd capable");
            result.addErrorInfo("Disk is " + this.m_diskPath + " not afd capable");
            result.setStatus(3);
            return false;
        }
        result.addTraceInfo("Disk is AFD capable");
        result.setStatus(1);
        return true;
    }
}

