/*
 * Decompiled with CFR 0.152.
 */
package oracle.ops.verification.framework.command;

import oracle.ops.mgmt.trace.Trace;
import oracle.ops.verification.framework.VerificationConstants;
import oracle.ops.verification.framework.command.VerificationCommand;
import oracle.ops.verification.framework.engine.Result;
import oracle.ops.verification.framework.util.VerificationUtil;

public class CheckCRShealthCommand
extends VerificationCommand {
    private static String m_arg1 = "-runexe";

    public CheckCRShealthCommand(String nodeName) {
        super(nodeName, null, null);
        String[] args = new String[]{m_arg1, VerificationUtil.getCRSHome() + FILE_SEPARATOR + "bin" + FILE_SEPARATOR + "crs_stat", "-t"};
        super.setArgs(args);
    }

    @Override
    public boolean execute() {
        String node = this.getNodeName();
        Trace.out((String)("CheckCRShealthCommand::Inside execute() " + Thread.currentThread().getName()));
        boolean bResult = super.execute();
        Result result = this.getResult();
        if (!bResult) {
            String trcTxt = "super.execute() failed for CheckCRShealthCommand...";
            Trace.out((String)trcTxt);
            result.addTraceInfo(trcTxt);
            result.addErrorInfo("CheckCRShealth failed");
            result.setStatus(2);
            return false;
        }
        String[] resultString = this.getCommandResult().getResultString();
        String exectaskFmtdStr = VerificationUtil.strArr2List(resultString, "\n");
        if (!VerificationUtil.fetchExecResult(exectaskFmtdStr)) {
            result.addTraceInfo("Exectask execution result failed");
            result.addErrorInfo("CheckCRShealth using crs_stat failed");
            result.setStatus(2);
            return false;
        }
        String exectaskVerfRes = VerificationUtil.fetchVerificationResult(exectaskFmtdStr);
        if (!exectaskVerfRes.equalsIgnoreCase("0")) {
            String errTxt = VerificationUtil.fetchVerificationValue(exectaskFmtdStr);
            Trace.out((String)("Exectask verification result('" + exectaskVerfRes + "') failed"));
            result.addTraceInfo("Exectask verification result('" + exectaskVerfRes + "') failed");
            result.addErrorInfo("CheckCRShealth using crs_stat failed");
            if (errTxt != null && errTxt.length() != 0) {
                Trace.out((String)("ERROR MESSAGE from node '" + node + "'>> " + errTxt));
                result.addErrorInfo("ERROR MESSAGE from node '" + node + "'>> " + errTxt);
            }
            result.setStatus(2);
            return false;
        }
        String crsInfoOutput = VerificationUtil.fetchVerificationValue(exectaskFmtdStr);
        if (crsInfoOutput == null || crsInfoOutput.length() == 0) {
            Trace.out((String)("NO OUTPUT FROM 'crs_stat' run on node '" + node + "'"));
            result.addErrorInfo("NO OUTPUT FROM 'crs_stat' run on node '" + node + "'");
            result.setStatus(2);
            return false;
        }
        String[] crsInfoArr = crsInfoOutput.split(VerificationConstants.LSEP);
        String strToMatch = crsInfoArr[0].trim();
        if (strToMatch.matches(".*No resources are registered.*") || strToMatch.matches(".*Name.*Type.*Target.*")) {
            result.setStatus(1);
        } else {
            result.setStatus(3);
        }
        return true;
    }
}

