/*
 * Decompiled with CFR 0.152.
 */
package oracle.ops.verification.framework.command;

import java.util.List;
import oracle.ops.mgmt.trace.Trace;
import oracle.ops.verification.framework.command.VerificationCommand;
import oracle.ops.verification.framework.engine.Result;
import oracle.ops.verification.framework.nativesystem.ExecutionAnalyzer;
import oracle.ops.verification.framework.nativesystem.ExecutionAnalyzerFactory;
import oracle.ops.verification.framework.util.VerificationUtil;

public class CheckArchitectureCommand
extends VerificationCommand {
    private static String[] s_args = new String[]{"-getarchitecture"};
    List<String> m_archValList;

    public CheckArchitectureCommand(String nodeName, List<String> archValList) {
        super(nodeName, s_args, null);
        this.m_archValList = archValList;
    }

    @Override
    public boolean execute() {
        Trace.out((String)("CheckArchitectureCommand::Inside execute() " + Thread.currentThread().getName()));
        boolean bResult = super.execute();
        Result result = this.getResult();
        if (!bResult) {
            String trcTxt = "super.execute() failed for CheckArchitectureCommand...";
            Trace.out((String)trcTxt);
            result.addTraceInfo(trcTxt);
            result.addErrorInfo("CheckArchitecture failed");
            result.setStatus(2);
            return false;
        }
        String[] resultString = this.getCommandResult().getResultString();
        String reoutput = VerificationUtil.strArr2String(resultString);
        ExecutionAnalyzer analyzer = ExecutionAnalyzerFactory.getExecutionAnalyzer();
        analyzer.verifyArchitecture(reoutput, this.m_archValList, result);
        return true;
    }
}

