/*
 * Decompiled with CFR 0.152.
 */
package oracle.ops.verification.framework.command;

import oracle.ops.mgmt.nativesystem.SystemFactory;
import oracle.ops.mgmt.nls.MessageBundle;
import oracle.ops.mgmt.trace.Trace;
import oracle.ops.verification.framework.command.VerificationCommand;
import oracle.ops.verification.framework.engine.ErrorDescription;
import oracle.ops.verification.framework.engine.Result;
import oracle.ops.verification.framework.util.VerificationUtil;

public class CheckASMStampCommand
extends VerificationCommand {
    private static String m_arg1 = "-checkasmstamp";
    private static String m_arg2 = "-discoverDevices";
    private static MessageBundle s_gMsgBundle = VerificationUtil.getMessageBundle("Prvg");
    private String m_asmStamp = null;

    public CheckASMStampCommand(String nodeName, String stamp) {
        this(nodeName, stamp, false);
    }

    public CheckASMStampCommand(String nodeName, String stamp, boolean discover) {
        super(nodeName, null, null);
        this.m_asmStamp = stamp;
        String[] args = null;
        args = discover ? new String[]{m_arg1, m_arg2, this.m_asmStamp} : new String[]{m_arg1, this.m_asmStamp};
        super.setArgs(args);
    }

    @Override
    public boolean execute() {
        Trace.out((String)("CheckASMStampCommand::Inside execute() " + Thread.currentThread().getName()));
        boolean bResult = super.execute();
        Result result = this.getResult();
        String[] resultString = this.getCommandResult().getResultString();
        String reoutput = VerificationUtil.strArr2String(resultString);
        Trace.out((String)"super.execute() was succcessful for CheckASMStampCommand...");
        if (!VerificationUtil.fetchExecResult(reoutput)) {
            String trcTxt = "Exectask result shows error for -checkasmstamp...";
            Trace.out((String)trcTxt);
            result.addTraceInfo(trcTxt);
            Trace.out((String)"checking of asm stamp is failed");
            result.addErrorInfo("checking of asm stamp is failed");
            result.setStatus(2);
            return false;
        }
        if (!VerificationUtil.fetchVerificationStatus(reoutput)) {
            String trcTxt = "Exectask result shows verification failure for -checkasmstamp...";
            Trace.out((String)trcTxt);
            result.addTraceInfo(trcTxt);
            Trace.out((String)"checking of asm stamp is unsuccessful");
            result.addErrorInfo("checking of asm stamp is unsuccessful");
            if (VerificationUtil.isPlatformLinux()) {
                result.addErrorDescription(new ErrorDescription(s_gMsgBundle.getMessage("10523", true, (Object[])new String[]{this.m_asmStamp})));
            }
            result.setStatus(3);
            return false;
        }
        if (!new SystemFactory().CreateSystem().isUnixSystem()) {
            String asmDevicePath = VerificationUtil.fetchVerificationValue(reoutput);
            Trace.out((String)"after calling fetchVerificationValue() ");
            Trace.out((String)("The ASM stamp '" + this.m_asmStamp + "' is resolved to device path '" + asmDevicePath + "' on node " + this.getNodeName()));
            result.addTraceInfo("The ASM stamp '" + this.m_asmStamp + "' is resolved to device path '" + asmDevicePath + "' on node " + this.getNodeName());
            result.addResultInfo(asmDevicePath);
            result.setStatus(1);
        }
        return true;
    }
}

