/*
 * Decompiled with CFR 0.152.
 */
package oracle.cluster.verification.util;

import oracle.cluster.verification.util.VerificationType;

public enum CollectionGroup {
    PREREQ_CRS_INST("STAGE_PRE_CRSINST"),
    BESTPRACTICE_PRE_CRS_INST("BESTPRACTICE_PRE_CRS_INST"),
    POSTREQ_CRS_INST("STAGE_POST_CRSINST"),
    BESTPRACTICE_POSTREQ_CRS_INST("BESTPRACTICE_POSTREQ_CRS_INST"),
    PREREQ_DB_INST("STAGE_PRE_DBINST"),
    PREREQ_DB_CONFIG("STAGE_PRE_DBCONFIG"),
    POSTREQ_DB_CONFIG("STAGE_POST_DBCONFIG"),
    BESTPRACTICE_POSTREQ_DB_CONFIG("BESTPRACTICE_POSTREQ_DB_CONFIG"),
    PREREQ_SI_HA_INST("STAGE_PRE_SIHAINST"),
    PREREQ_SI_HA_CONFIG("STAGE_PRE_SIHACONFIG"),
    POSTREQ_SI_HA_CONFIG("STAGE_POST_SIHACONFIG"),
    BESTPRACTICE_POSTREQ_SI_HA_CONFIG("BESTPRACTICE_POSTREQ_SI_HA_CONFIG"),
    PREREQ_SI_DB_INST("STAGE_PRE_SIDBINST"),
    PREREQ_SI_DB_CONFIG("STAGE_PRE_SIDBCONFIG"),
    PREREQ_CFS_SETUP("STAGE_PRE_CFS_SETUP"),
    POSTREQ_CFS_SETUP("STAGE_POST_CFS_SETUP"),
    POSTREQ_HWOS_SETUP("STAGE_POST_HWOS_SETUP"),
    PREREQ_RACNODE_ADD("STAGE_PRE_RACNODE_ADD"),
    PREREQ_NODE_ADD("STAGE_PRE_NODE_ADD"),
    POSTREQ_NODE_ADD("STAGE_POST_NODE_ADD"),
    POSTREQ_NODE_DEL("STAGE_POST_NODE_DEL"),
    SYSREQ_CRS("COMP_SYS_CRS"),
    SYSREQ_DB("COMP_SYS_DB"),
    PREREQ_USM_CONFIG("STAGE_PRE_USM_CONFIG"),
    POSTREQ_USM_CONFIG("STAGE_POST_USM_CONFIG"),
    SYSREQ_SI_HA("COMP_SYS_SI_HA"),
    SYSREQ_SI_DB("COMP_SYS_SI_DB"),
    PREREQ_FARM_HEALTH("COMP_FARM_HEALTH"),
    DB_INIT_PARAMETER_COLLECTION("DB_INIT_PARAMETER_COLLECTION"),
    NETWORK_COLLECTION("NETWORK_COLLECTION"),
    STORAGE_COLLECTION("STORAGE_COLLECTION"),
    CRS_MODEL_COLLECTION("CRS_MODEL_COLLECTION"),
    OHASD_MODEL_COLLECTION("OHASD_MODEL_COLLECTION"),
    CRS_SOFTWARE_COLLECTION("CRS_SOFTWARE_COLLECTION"),
    DB_SOFTWARE_COLLECTION("DB_SOFTWARE_COLLECTION"),
    OCR_COLLECTION("OCR_COLLECTION"),
    GPNP_COLLECTION("GPNP_COLLECTION"),
    OS_COLLECTIONS("OS_COLLECTIONS"),
    OS_PACKAGES("OS_PACKAGES"),
    OS_PATCHES("OS_PATCHES"),
    OS_KERNEL_PARAMS("OS_KERNEL_PARAMS"),
    ENVIRONMENT_VARIABLES("ENVIRONMENT_VARIABLES"),
    OS_RESOURCE_LIMITS("OS_RESOURCE_LIMITS"),
    ENVIRONMENT_VARIABLES_FOR_CRSD("ENVIRONMENT_VARIABLES_FOR_CRSD"),
    OS_RESOURCE_LIMITS_FOR_CRSD("OS_RESOURCE_LIMITS_FOR_CRSD"),
    INITTAB_ENTRIES("INITTAB_ENTRIES"),
    ASM_INIT_PARAMETER_COLLECTION("ASM_INIT_PARAMETER_COLLECTION"),
    COMPONENT_ASM_INTEGRITY("COMP_ASM"),
    COMP_ASM_INTEGRITY("COMP_ASM_INTEGRITY"),
    BESTPRACTICE_ASM("BESTPRACTICE_ASM"),
    ASM_DISK_GROUP_CONFIGURATION_COLLECTION("ASM_DISK_GROUP_CONFIGURATION_COLLECTION"),
    CRS_PATCH_COLLECTION("CRS_PATCH_COLLECTION"),
    DB_PATCH_COLLECTION("DB_PATCH_COLLECTION");

    private String m_id = null;

    private CollectionGroup(String id) {
        this.m_id = id;
    }

    public String getID() {
        return this.m_id;
    }

    public static CollectionGroup getCollectionGroup(VerificationType vType) {
        switch (vType) {
            case PREREQ_CRS_INST: {
                return PREREQ_CRS_INST;
            }
            case BESTPRACTICE_PRE_CRS_INST: {
                return BESTPRACTICE_PRE_CRS_INST;
            }
            case POSTREQ_CRS_INST: {
                return POSTREQ_CRS_INST;
            }
            case BESTPRACTICE_POSTREQ_CRS_INST: {
                return BESTPRACTICE_POSTREQ_CRS_INST;
            }
            case PREREQ_DB_INST: {
                return PREREQ_DB_INST;
            }
            case PREREQ_DB_CONFIG: {
                return PREREQ_DB_CONFIG;
            }
            case POSTREQ_DB_CONFIG: {
                return POSTREQ_DB_CONFIG;
            }
            case BESTPRACTICE_POSTREQ_DB_CONFIG: {
                return BESTPRACTICE_POSTREQ_DB_CONFIG;
            }
            case PREREQ_SI_HA_INST: {
                return PREREQ_SI_HA_INST;
            }
            case PREREQ_SI_HA_CONFIG: {
                return PREREQ_SI_HA_CONFIG;
            }
            case POSTREQ_SI_HA_CONFIG: {
                return POSTREQ_SI_HA_CONFIG;
            }
            case BESTPRACTICE_POSTREQ_SI_HA_CONFIG: {
                return BESTPRACTICE_POSTREQ_SI_HA_CONFIG;
            }
            case PREREQ_SI_DB_INST: {
                return PREREQ_SI_DB_INST;
            }
            case PREREQ_SI_DB_CONFIG: {
                return PREREQ_SI_DB_CONFIG;
            }
            case PREREQ_CFS_SETUP: {
                return PREREQ_CFS_SETUP;
            }
            case POSTREQ_CFS_SETUP: {
                return POSTREQ_CFS_SETUP;
            }
            case POSTREQ_HWOS_SETUP: {
                return POSTREQ_HWOS_SETUP;
            }
            case PREREQ_RACNODE_ADD: {
                return PREREQ_RACNODE_ADD;
            }
            case PREREQ_NODE_ADD: {
                return PREREQ_NODE_ADD;
            }
            case POSTREQ_NODE_ADD: {
                return POSTREQ_NODE_ADD;
            }
            case POSTREQ_NODE_DEL: {
                return POSTREQ_NODE_DEL;
            }
            case SYSREQ_CRS: {
                return SYSREQ_CRS;
            }
            case SYSREQ_DB: {
                return SYSREQ_DB;
            }
            case PREREQ_USM_CONFIG: {
                return PREREQ_USM_CONFIG;
            }
            case POSTREQ_USM_CONFIG: {
                return POSTREQ_USM_CONFIG;
            }
            case SYSREQ_SI_HA: {
                return SYSREQ_SI_HA;
            }
            case SYSREQ_SI_DB: {
                return SYSREQ_SI_DB;
            }
            case PREREQ_FARM_HEALTH: {
                return PREREQ_FARM_HEALTH;
            }
            case OS_COLLECTIONS: {
                return OS_COLLECTIONS;
            }
            case COMPONENT_ASM_INTEGRITY: {
                return COMPONENT_ASM_INTEGRITY;
            }
            case BESTPRACTICE_ASM: {
                return BESTPRACTICE_ASM;
            }
        }
        return PREREQ_CRS_INST;
    }

    public static CollectionGroup getById(String id) {
        if (id != null && id.trim().length() > 0) {
            for (CollectionGroup group : CollectionGroup.values()) {
                if (!group.m_id.equals(id)) continue;
                return group;
            }
        }
        return null;
    }
}

